/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.backup.service;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.ssssssss.magicapi.backup.model.Backup;
import org.ssssssss.magicapi.backup.service.MagicBackupService;
import org.ssssssss.magicapi.core.config.MagicConfiguration;
import org.ssssssss.magicapi.core.event.FileEvent;
import org.ssssssss.magicapi.core.event.GroupEvent;
import org.ssssssss.magicapi.core.model.Group;
import org.ssssssss.magicapi.core.model.MagicEntity;
import org.ssssssss.magicapi.utils.JsonUtils;
import org.ssssssss.magicapi.utils.WebUtils;

public class MagicDatabaseBackupService
implements MagicBackupService {
    private static final String DEFAULT_COLUMNS = "id,create_date,tag,type,name,create_by";
    private final JdbcTemplate template;
    private final String INSERT_SQL;
    private final String FIND_BY_ID;
    private final String FIND_BY_TAG;
    private final String FIND_BY_TIMESTAMP;
    private final String FIND_BY_ID_AND_TIMESTAMP;
    private final String DELETE_BY_ID;
    private final String DELETE_BY_TIMESTAMP;
    private final BeanPropertyRowMapper<Backup> rowMapper = new BeanPropertyRowMapper(Backup.class);
    private static final Logger logger = LoggerFactory.getLogger(MagicDatabaseBackupService.class);

    public MagicDatabaseBackupService(JdbcTemplate template, String tableName) {
        this.template = template;
        this.template.setMaxRows(100);
        this.INSERT_SQL = String.format("insert into %s(%s,content) values(?,?,?,?,?,?,?)", tableName, DEFAULT_COLUMNS);
        this.FIND_BY_ID = String.format("select %s from %s where id = ? order by create_date desc", DEFAULT_COLUMNS, tableName);
        this.DELETE_BY_ID = String.format("delete from %s where id = ?", tableName);
        this.FIND_BY_TAG = String.format("select %s from %s where tag = ? order by create_date desc", DEFAULT_COLUMNS, tableName);
        this.FIND_BY_TIMESTAMP = String.format("select %s from %s where create_date < ? order by create_date desc", DEFAULT_COLUMNS, tableName);
        this.DELETE_BY_TIMESTAMP = String.format("delete from %s where create_date < ?", tableName);
        this.FIND_BY_ID_AND_TIMESTAMP = String.format("select * from %s where id = ? and create_date = ?", tableName);
    }

    @Override
    public void doBackupAll(String name, String createBy) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MagicConfiguration.getMagicResourceService().export(null, null, baos);
        Backup backup = new Backup();
        backup.setId("full");
        backup.setType("full");
        backup.setName(name);
        backup.setCreateBy(createBy);
        backup.setContent(baos.toByteArray());
        this.doBackup(backup);
    }

    @Override
    public void doBackup(Backup backup) {
        try {
            if (backup.getCreateDate() == 0L) {
                backup.setCreateDate(System.currentTimeMillis());
            }
            if (backup.getCreateBy() == null) {
                backup.setCreateBy(WebUtils.currentUserName());
            }
            this.template.update(this.INSERT_SQL, new Object[]{backup.getId(), backup.getCreateDate(), backup.getTag(), backup.getType(), backup.getName(), backup.getCreateBy(), backup.getContent()});
        }
        catch (Exception e) {
            logger.warn("\u5907\u4efd\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public List<Backup> backupList(long timestamp) {
        return this.template.query(this.FIND_BY_TIMESTAMP, this.rowMapper, new Object[]{timestamp});
    }

    @Override
    public List<Backup> backupById(String id) {
        return this.template.query(this.FIND_BY_ID, this.rowMapper, new Object[]{id});
    }

    @Override
    public Backup backupInfo(String id, long timestamp) {
        return (Backup)this.template.queryForObject(this.FIND_BY_ID_AND_TIMESTAMP, this.rowMapper, new Object[]{id, timestamp});
    }

    @Override
    public List<Backup> backupByTag(String tag) {
        return this.template.query(this.FIND_BY_TAG, this.rowMapper, new Object[]{tag});
    }

    @Override
    public long removeBackup(String id) {
        return this.template.update(this.DELETE_BY_ID, new Object[]{id});
    }

    @Override
    public long removeBackupByTimestamp(long timestamp) {
        try {
            return this.template.update(this.DELETE_BY_TIMESTAMP, new Object[]{timestamp});
        }
        catch (Exception e) {
            logger.warn("\u5220\u9664\u5907\u4efd\u5931\u8d25", (Throwable)e);
            return -1L;
        }
    }

    @EventListener(condition="#event.source != T(org.ssssssss.magicapi.core.config.Constants).EVENT_SOURCE_NOTIFY")
    public void onFileEvent(FileEvent event) {
        switch (event.getAction()) {
            case SAVE: 
            case CREATE: 
            case MOVE: {
                break;
            }
            default: {
                return;
            }
        }
        MagicEntity entity = event.getEntity();
        this.doBackup(entity.getId(), JsonUtils.toJsonBytes(entity), entity.getName(), event.getType());
    }

    @EventListener(condition="#event.source != T(org.ssssssss.magicapi.core.config.Constants).EVENT_SOURCE_NOTIFY")
    public void onFolderEvent(GroupEvent event) {
        switch (event.getAction()) {
            case SAVE: 
            case CREATE: 
            case MOVE: {
                break;
            }
            default: {
                return;
            }
        }
        Group group = event.getGroup();
        this.doBackup(group.getId(), JsonUtils.toJsonBytes(group), group.getName(), group.getType() + "-group");
    }

    private void doBackup(String id, byte[] content, String name, String type) {
        Backup backup = new Backup();
        backup.setName(name);
        backup.setId(id);
        backup.setContent(content);
        backup.setType(type);
        this.doBackup(backup);
    }
}

