/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.task.service;

import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.config.CronTask;
import org.springframework.scheduling.support.CronTrigger;
import org.ssssssss.magicapi.core.config.MagicConfiguration;
import org.ssssssss.magicapi.core.event.FileEvent;
import org.ssssssss.magicapi.core.event.GroupEvent;
import org.ssssssss.magicapi.core.model.MagicEntity;
import org.ssssssss.magicapi.core.service.AbstractMagicDynamicRegistry;
import org.ssssssss.magicapi.core.service.MagicResourceStorage;
import org.ssssssss.magicapi.task.model.TaskInfo;
import org.ssssssss.magicapi.utils.ScriptManager;
import org.ssssssss.script.MagicScriptContext;

public class TaskMagicDynamicRegistry
extends AbstractMagicDynamicRegistry<TaskInfo> {
    private final TaskScheduler taskScheduler;
    private static final Logger logger = LoggerFactory.getLogger(TaskMagicDynamicRegistry.class);
    private final boolean showLog;

    public TaskMagicDynamicRegistry(MagicResourceStorage<TaskInfo> magicResourceStorage, TaskScheduler taskScheduler, boolean showLog) {
        super(magicResourceStorage);
        this.taskScheduler = taskScheduler;
        this.showLog = showLog;
    }

    @EventListener(condition="#event.type == 'task'")
    public void onFileEvent(FileEvent event) {
        this.processEvent(event);
    }

    @EventListener(condition="#event.type == 'task'")
    public void onGroupEvent(GroupEvent event) {
        this.processEvent(event);
    }

    public boolean register(TaskInfo entity) {
        this.unregister((MagicEntity)entity);
        return super.register((MagicEntity)entity);
    }

    protected boolean register(AbstractMagicDynamicRegistry.MappingNode<TaskInfo> mappingNode) {
        TaskInfo entity = (TaskInfo)mappingNode.getEntity();
        if (this.taskScheduler != null) {
            String scriptName = MagicConfiguration.getMagicResourceService().getScriptName((MagicEntity)entity);
            try {
                CronTrigger trigger = new CronTrigger(entity.getCron());
                CronTask cronTask = new CronTask(() -> {
                    if (entity.isEnabled()) {
                        try {
                            if (this.showLog) {
                                logger.info("\u5b9a\u65f6\u4efb\u52a1:[{}]\u5f00\u59cb\u6267\u884c", (Object)scriptName);
                            }
                            MagicScriptContext magicScriptContext = new MagicScriptContext();
                            magicScriptContext.setScriptName(scriptName);
                            ScriptManager.executeScript((String)entity.getScript(), (MagicScriptContext)magicScriptContext);
                        }
                        catch (Exception e) {
                            logger.error("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u51fa\u9519", (Throwable)e);
                        }
                        finally {
                            if (this.showLog) {
                                logger.info("\u5b9a\u65f6\u4efb\u52a1:[{}]\u6267\u884c\u5b8c\u6bd5", (Object)scriptName);
                            }
                        }
                    }
                }, trigger);
                mappingNode.setMappingData((Object)this.taskScheduler.schedule(cronTask.getRunnable(), cronTask.getTrigger()));
            }
            catch (Exception e) {
                logger.error("\u5b9a\u65f6\u4efb\u52a1:[{}]\u6ce8\u518c\u5931\u8d25", (Object)scriptName, (Object)e);
            }
            logger.debug("\u6ce8\u518c\u5b9a\u65f6\u4efb\u52a1:[{},{}]", (Object)MagicConfiguration.getMagicResourceService().getScriptName((MagicEntity)entity), (Object)entity.getCron());
        }
        return true;
    }

    protected void unregister(AbstractMagicDynamicRegistry.MappingNode<TaskInfo> mappingNode) {
        if (this.taskScheduler == null) {
            return;
        }
        TaskInfo info = (TaskInfo)mappingNode.getEntity();
        logger.debug("\u53d6\u6d88\u6ce8\u518c\u5b9a\u65f6\u4efb\u52a1:[{}, {}, {}]", new Object[]{info.getName(), info.getPath(), info.getCron()});
        ScheduledFuture scheduledFuture = (ScheduledFuture)mappingNode.getMappingData();
        if (scheduledFuture != null) {
            try {
                scheduledFuture.cancel(true);
            }
            catch (Exception e) {
                String scriptName = MagicConfiguration.getMagicResourceService().getScriptName((MagicEntity)info);
                logger.warn("\u5b9a\u65f6\u4efb\u52a1:[{}]\u53d6\u6d88\u5931\u8d25", (Object)scriptName, (Object)e);
            }
        }
    }
}

