/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.redis;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.DefaultStringRedisConnection;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPipelineException;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.ReflectionUtils;
import org.ssssssss.magicapi.core.annotation.MagicModule;
import org.ssssssss.script.functions.DynamicMethod;
import org.ssssssss.script.reflection.JavaReflection;

@MagicModule(value="redis")
public class RedisModule
implements DynamicMethod {
    private final StringRedisTemplate redisTemplate;
    private final boolean isRedisson;

    public RedisModule(RedisConnectionFactory connectionFactory) {
        this.redisTemplate = new StringRedisTemplate(connectionFactory);
        this.isRedisson = Objects.equals("org.redisson.spring.data.connection.RedissonConnectionFactory", this.redisTemplate.getConnectionFactory().getClass().getName());
    }

    private byte[] serializer(Object value) {
        if (value == null || value instanceof String) {
            return this.redisTemplate.getStringSerializer().serialize((Object)((String)value));
        }
        return this.serializer(value.toString());
    }

    private Object serializerForRedisson(Object value) {
        if (value == null || JavaReflection.isPrimitiveAssignableFrom(value.getClass(), value.getClass())) {
            return value;
        }
        return this.serializer(value.toString());
    }

    private Object deserialize(Object value) {
        if (value != null) {
            if (value instanceof byte[]) {
                return this.redisTemplate.getStringSerializer().deserialize((byte[])value);
            }
            if (value instanceof List) {
                List valueList = (List)value;
                ArrayList<Object> resultList = new ArrayList<Object>(valueList.size());
                for (Object val2 : valueList) {
                    resultList.add(this.deserialize(val2));
                }
                return resultList;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                LinkedHashMap newMap = new LinkedHashMap(map.size());
                map.forEach((key, val) -> newMap.put(this.deserialize(key), this.deserialize(val)));
                return newMap;
            }
        }
        return value;
    }

    public Object execute(String methodName, List<Object> parameters) {
        return this.redisTemplate.execute(connection -> {
            Object result;
            if (this.isRedisson) {
                result = this.executeForRedisson(((DefaultStringRedisConnection)connection).getDelegate(), methodName, parameters);
            } else {
                byte[][] params = new byte[parameters.size()][];
                for (int i = 0; i < params.length; ++i) {
                    params[i] = this.serializer(parameters.get(i));
                }
                result = connection.execute(methodName, (byte[][])params);
            }
            return this.deserialize(result);
        }, this.isRedisson || this.redisTemplate.isExposeConnection());
    }

    private Object executeForRedisson(RedisConnection connection, String command, List<Object> parameters) {
        Method[] methods;
        for (Method method : methods = connection.getClass().getDeclaredMethods()) {
            if (!method.getName().equalsIgnoreCase(command) || !Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != parameters.size()) continue;
            try {
                Object ret = this.execute(connection, method, parameters);
                if (ret instanceof String) {
                    return ((String)ret).getBytes();
                }
                return ret;
            }
            catch (IllegalArgumentException e) {
                if (connection.isPipelined()) {
                    throw new RedisPipelineException((Exception)e);
                }
                throw new InvalidDataAccessApiUsageException(e.getMessage(), (Throwable)e);
            }
        }
        throw new UnsupportedOperationException();
    }

    private Object execute(RedisConnection connection, Method method, List<Object> parameters) {
        if (method.getParameterTypes().length > 0 && method.getParameterTypes()[0] == byte[][].class) {
            return ReflectionUtils.invokeMethod((Method)method, (Object)connection, (Object[])parameters.stream().map(this::serializer).toArray(x$0 -> new byte[x$0][]));
        }
        if (parameters.size() == 0) {
            return ReflectionUtils.invokeMethod((Method)method, (Object)connection);
        }
        return ReflectionUtils.invokeMethod((Method)method, (Object)connection, (Object[])parameters.stream().map(this::serializerForRedisson).toArray());
    }
}

