/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.git;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.FS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ssssssss.magicapi.core.exception.MagicAPIException;
import org.ssssssss.magicapi.git.MagicGitProperties;

public class GitRepo {
    private static final Logger logger = LoggerFactory.getLogger(GitRepo.class);
    private String rootPath;
    private String gitFilePath;
    private MagicGitProperties properties;
    private Git git;

    public GitRepo(String rootPath, MagicGitProperties properties) {
        this.rootPath = rootPath;
        this.gitFilePath = rootPath + File.separator + ".git";
        this.properties = properties;
    }

    private void valid() {
        File repoDir = new File(this.rootPath);
        File gitFile = new File(this.gitFilePath);
        if (!repoDir.exists()) {
            repoDir.mkdirs();
        }
        if (!gitFile.exists() && repoDir.list().length > 0) {
            throw new MagicAPIException("\u521d\u6b21\u9879\u76ee\u542f\u52a8\u65f6\uff0c\u8bf7\u4fdd\u6301\u6587\u4ef6\u5939\u4e3a\u7a7a\u3002");
        }
    }

    private void setSshOrCredentials(TransportCommand transportCommand) {
        if (this.getProperties().getPrivateKey() != null) {
            JschConfigSessionFactory sshSessionFactory = new JschConfigSessionFactory(){

                protected void configure(OpenSshConfig.Host host, Session session) {
                }

                protected JSch createDefaultJSch(FS fs) throws JSchException {
                    JSch defaultJSch = super.createDefaultJSch(fs);
                    defaultJSch.addIdentity(GitRepo.this.getProperties().getPrivateKey());
                    return defaultJSch;
                }
            };
            transportCommand.setTransportConfigCallback(new TransportConfigCallback(){
                final /* synthetic */ SshSessionFactory val$sshSessionFactory;
                {
                    this.val$sshSessionFactory = sshSessionFactory;
                }

                public void configure(Transport transport) {
                    SshTransport sshTransport = (SshTransport)transport;
                    sshTransport.setSshSessionFactory(this.val$sshSessionFactory);
                }
            });
        } else if (StringUtils.isNotBlank((CharSequence)this.properties.getUsername()) && StringUtils.isNotBlank((CharSequence)this.properties.getPassword())) {
            transportCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.properties.getUsername(), this.properties.getPassword()));
        } else if (StringUtils.isNotBlank((CharSequence)this.properties.getUrl()) && this.properties.getUrl().contains("oauth2:")) {
            String url = this.properties.getUrl();
            int start = url.indexOf("oauth2:") + 7;
            int end = url.indexOf("@");
            transportCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider("oauth2", url.substring(start, end)));
        }
    }

    public void setupRepo() throws IOException, GitAPIException {
        this.valid();
        File gitFile = new File(this.gitFilePath);
        try {
            if (gitFile.exists()) {
                FileRepositoryBuilder builder = new FileRepositoryBuilder();
                Repository repository = FileRepositoryBuilder.create((File)gitFile);
                this.git = new Git(repository);
                this.update(false);
                this.update(true);
            } else {
                CloneCommand cloneCommand = Git.cloneRepository().setURI(this.properties.getUrl()).setDirectory(new File(this.rootPath)).setBranch(this.properties.getBranch());
                this.setSshOrCredentials((TransportCommand)cloneCommand);
                this.git = cloneCommand.call();
            }
        }
        catch (IOException | GitAPIException e) {
            logger.error("\u521d\u59cb\u5316git\u4ed3\u5e93\u5931\u8d25", e);
            throw e;
        }
    }

    public boolean update(boolean update) {
        try {
            this.git.add().setUpdate(update).addFilepattern(".").call();
            this.git.commit().setMessage("\u540c\u6b65\u6570\u636e").call();
            PullCommand pull = this.git.pull();
            this.setSshOrCredentials((TransportCommand)pull);
            PullResult pullResult = pull.call();
            if (!pullResult.isSuccessful()) {
                throw new MagicAPIException("git\u66f4\u65b0\u5931\u8d25, \u8bf7\u91cd\u8bd5\u6216\u5c1d\u8bd5\u624b\u52a8\u66f4\u65b0");
            }
            PushCommand pushCommand = this.git.push();
            this.setSshOrCredentials((TransportCommand)pushCommand);
            pushCommand.call();
        }
        catch (GitAPIException e) {
            logger.error("git\u66f4\u65b0\u5931\u8d25", (Throwable)e);
            throw new MagicAPIException("git\u66f4\u65b0\u5931\u8d25, \u8bf7\u91cd\u8bd5\u6216\u5c1d\u8bd5\u624b\u52a8\u66f4\u65b0");
        }
        return true;
    }

    public MagicGitProperties getProperties() {
        return this.properties;
    }
}

