/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.cluster;

import org.springframework.context.event.EventListener;
import org.ssssssss.magicapi.core.event.FileEvent;
import org.ssssssss.magicapi.core.event.GroupEvent;
import org.ssssssss.magicapi.core.event.MagicEvent;
import org.ssssssss.magicapi.core.model.MagicNotify;
import org.ssssssss.magicapi.core.service.MagicNotifyService;

public class MagicSynchronizationService {
    private final MagicNotifyService magicNotifyService;
    private final String instanceId;

    public MagicSynchronizationService(MagicNotifyService magicNotifyService, String instanceId) {
        this.magicNotifyService = magicNotifyService;
        this.instanceId = instanceId;
    }

    @EventListener(condition="#event.source != T(org.ssssssss.magicapi.core.config.Constants).EVENT_SOURCE_NOTIFY")
    public void onFolderEvent(GroupEvent event) {
        switch (event.getAction()) {
            case CREATE: 
            case SAVE: 
            case MOVE: 
            case DELETE: {
                this.magicNotifyService.sendNotify(new MagicNotify(this.instanceId, event.getGroup().getId(), event.getAction(), event.getType()));
            }
        }
    }

    @EventListener(condition="#event.source != T(org.ssssssss.magicapi.core.config.Constants).EVENT_SOURCE_NOTIFY")
    public void onFileEvent(FileEvent event) {
        if ("notify".equals(event.getSource())) {
            return;
        }
        switch (event.getAction()) {
            case CREATE: 
            case SAVE: 
            case MOVE: 
            case DELETE: {
                this.magicNotifyService.sendNotify(new MagicNotify(this.instanceId, event.getEntity().getId(), event.getAction(), "file"));
            }
        }
    }

    @EventListener(condition="#event.action == T(org.ssssssss.magicapi.core.event.EventAction).CLEAR && #event.source != T(org.ssssssss.magicapi.core.config.Constants).EVENT_SOURCE_NOTIFY")
    public void onClearEvent(MagicEvent event) {
        this.magicNotifyService.sendNotify(new MagicNotify(this.instanceId, null, event.getAction(), null));
    }
}

