/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.condition;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.condition.AbstractRequestCondition;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.pattern.PathPatternParser;

@Deprecated(since="7.0", forRemoval=true)
public class PatternsRequestCondition
extends AbstractRequestCondition<PatternsRequestCondition> {
    private static final Set<String> EMPTY_PATH_PATTERN = Collections.singleton("");
    private static final String[] ROOT_PATH_PATTERNS = new String[]{"", "/"};
    private final Set<String> patterns;
    private final PathMatcher pathMatcher;

    public PatternsRequestCondition(String ... patterns) {
        this(patterns, (UrlPathHelper)null, (PathMatcher)null);
    }

    public PatternsRequestCondition(String[] patterns, @Nullable UrlPathHelper urlPathHelper, @Nullable PathMatcher pathMatcher) {
        this.patterns = PatternsRequestCondition.initPatterns(patterns);
        this.pathMatcher = pathMatcher != null ? pathMatcher : new AntPathMatcher();
    }

    private static Set<String> initPatterns(String[] patterns) {
        if (!PatternsRequestCondition.hasPattern(patterns)) {
            return EMPTY_PATH_PATTERN;
        }
        LinkedHashSet result = CollectionUtils.newLinkedHashSet((int)patterns.length);
        for (String pattern : patterns) {
            pattern = PathPatternParser.defaultInstance.initFullPathPattern(pattern);
            result.add(pattern);
        }
        return result;
    }

    private static boolean hasPattern(String[] patterns) {
        if (!ObjectUtils.isEmpty((Object[])patterns)) {
            for (String pattern : patterns) {
                if (!StringUtils.hasText((String)pattern)) continue;
                return true;
            }
        }
        return false;
    }

    private PatternsRequestCondition(Set<String> patterns, PatternsRequestCondition other) {
        this.patterns = patterns;
        this.pathMatcher = other.pathMatcher;
    }

    public Set<String> getPatterns() {
        return this.patterns;
    }

    @Override
    protected Collection<String> getContent() {
        return this.patterns;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    public boolean isEmptyPathMapping() {
        return this.patterns == EMPTY_PATH_PATTERN;
    }

    public Set<String> getDirectPaths() {
        if (this.isEmptyPathMapping()) {
            return EMPTY_PATH_PATTERN;
        }
        HashSet<String> result = Collections.emptySet();
        for (String pattern : this.patterns) {
            if (this.pathMatcher.isPattern(pattern)) continue;
            result = result.isEmpty() ? new HashSet<String>(1) : result;
            result.add(pattern);
        }
        return result;
    }

    @Override
    public PatternsRequestCondition combine(PatternsRequestCondition other) {
        if (this.isEmptyPathMapping() && other.isEmptyPathMapping()) {
            return new PatternsRequestCondition(ROOT_PATH_PATTERNS);
        }
        if (other.isEmptyPathMapping()) {
            return this;
        }
        if (this.isEmptyPathMapping()) {
            return other;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (!this.patterns.isEmpty() && !other.patterns.isEmpty()) {
            for (String pattern1 : this.patterns) {
                for (String pattern2 : other.patterns) {
                    result.add(this.pathMatcher.combine(pattern1, pattern2));
                }
            }
        }
        return new PatternsRequestCondition(result, this);
    }

    @Override
    public @Nullable PatternsRequestCondition getMatchingCondition(HttpServletRequest request) {
        String lookupPath = UrlPathHelper.getResolvedLookupPath((ServletRequest)request);
        List<String> matches = this.getMatchingPatterns(lookupPath);
        return !matches.isEmpty() ? new PatternsRequestCondition(new LinkedHashSet<String>(matches), this) : null;
    }

    public List<String> getMatchingPatterns(String lookupPath) {
        List matches = null;
        for (String pattern : this.patterns) {
            String match = this.getMatchingPattern(pattern, lookupPath);
            if (match == null) continue;
            matches = matches != null ? matches : new ArrayList();
            matches.add(match);
        }
        if (matches == null) {
            return Collections.emptyList();
        }
        if (matches.size() > 1) {
            matches.sort(this.pathMatcher.getPatternComparator(lookupPath));
        }
        return matches;
    }

    private @Nullable String getMatchingPattern(String pattern, String lookupPath) {
        if (pattern.equals(lookupPath)) {
            return pattern;
        }
        if (this.pathMatcher.match(pattern, lookupPath)) {
            return pattern;
        }
        return null;
    }

    @Override
    public int compareTo(PatternsRequestCondition other, HttpServletRequest request) {
        String lookupPath = UrlPathHelper.getResolvedLookupPath((ServletRequest)request);
        Comparator patternComparator = this.pathMatcher.getPatternComparator(lookupPath);
        Iterator<String> iterator = this.patterns.iterator();
        Iterator<String> iteratorOther = other.patterns.iterator();
        while (iterator.hasNext() && iteratorOther.hasNext()) {
            int result = patternComparator.compare(iterator.next(), iteratorOther.next());
            if (result == 0) continue;
            return result;
        }
        if (iterator.hasNext()) {
            return -1;
        }
        if (iteratorOther.hasNext()) {
            return 1;
        }
        return 0;
    }
}

