/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.PathContainer;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PathMatcher;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.WebRequestHandlerInterceptorAdapter;
import org.springframework.web.util.ServletRequestPathUtils;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;
import org.springframework.web.util.pattern.PatternParseException;

public final class MappedInterceptor
implements HandlerInterceptor {
    private static final PathMatcher defaultPathMatcher = new AntPathMatcher();
    private final PatternAdapter @Nullable [] includePatterns;
    private final PatternAdapter @Nullable [] excludePatterns;
    private final HttpMethod @Nullable [] includeHttpMethods;
    private final HttpMethod @Nullable [] excludeHttpMethods;
    private PathMatcher pathMatcher = defaultPathMatcher;
    private final HandlerInterceptor interceptor;

    public MappedInterceptor(String @Nullable [] includePatterns, String @Nullable [] excludePatterns, HttpMethod @Nullable [] includeHttpMethods, HttpMethod @Nullable [] excludeHttpMethods, HandlerInterceptor interceptor, @Nullable PathPatternParser parser) {
        this.includePatterns = PatternAdapter.initPatterns(includePatterns, parser);
        this.excludePatterns = PatternAdapter.initPatterns(excludePatterns, parser);
        this.includeHttpMethods = includeHttpMethods;
        this.excludeHttpMethods = excludeHttpMethods;
        this.interceptor = interceptor;
    }

    @Deprecated(since="7.0", forRemoval=true)
    public MappedInterceptor(String @Nullable [] includePatterns, String @Nullable [] excludePatterns, HandlerInterceptor interceptor, @Nullable PathPatternParser parser) {
        this(includePatterns, excludePatterns, null, null, interceptor, parser);
    }

    public MappedInterceptor(String @Nullable [] includePatterns, HandlerInterceptor interceptor) {
        this(includePatterns, null, null, null, interceptor, null);
    }

    public MappedInterceptor(String @Nullable [] includePatterns, String @Nullable [] excludePatterns, HandlerInterceptor interceptor) {
        this(includePatterns, excludePatterns, null, null, interceptor, null);
    }

    public MappedInterceptor(String @Nullable [] includePatterns, WebRequestInterceptor interceptor) {
        this(includePatterns, null, interceptor);
    }

    public MappedInterceptor(String @Nullable [] includePatterns, String @Nullable [] excludePatterns, WebRequestInterceptor interceptor) {
        this(includePatterns, excludePatterns, null, null, new WebRequestHandlerInterceptorAdapter(interceptor), null);
    }

    public String @Nullable [] getIncludePathPatterns() {
        return !ObjectUtils.isEmpty((Object[])this.includePatterns) ? (String[])Arrays.stream(this.includePatterns).map(PatternAdapter::getPatternString).toArray(String[]::new) : null;
    }

    public String @Nullable [] getExcludePathPatterns() {
        return !ObjectUtils.isEmpty((Object[])this.excludePatterns) ? (String[])Arrays.stream(this.excludePatterns).map(PatternAdapter::getPatternString).toArray(String[]::new) : null;
    }

    public HandlerInterceptor getInterceptor() {
        return this.interceptor;
    }

    @Deprecated(since="7.0", forRemoval=true)
    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    @Deprecated(since="7.0", forRemoval=true)
    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    /*
     * WARNING - void declaration
     */
    public boolean matches(HttpServletRequest request) {
        int n;
        Object path = ServletRequestPathUtils.getCachedPath((ServletRequest)request);
        HttpMethod httpMethod = HttpMethod.valueOf((String)request.getMethod());
        if (this.pathMatcher != defaultPathMatcher) {
            path = path.toString();
        }
        boolean isPathContainer = path instanceof PathContainer;
        if (!ObjectUtils.isEmpty((Object[])this.excludePatterns)) {
            for (PatternAdapter patternAdapter : this.excludePatterns) {
                if (!patternAdapter.match(path, isPathContainer, this.pathMatcher)) continue;
                return false;
            }
        }
        if (!ObjectUtils.isEmpty((Object[])this.excludeHttpMethods)) {
            for (PatternAdapter patternAdapter : this.excludeHttpMethods) {
                if (patternAdapter != httpMethod) continue;
                return false;
            }
        }
        if (!ObjectUtils.isEmpty((Object[])this.includePatterns)) {
            void var8_16;
            boolean match = false;
            PatternAdapter[] patternAdapterArray = this.includePatterns;
            n = patternAdapterArray.length;
            boolean bl = false;
            while (var8_16 < n) {
                PatternAdapter adapter = patternAdapterArray[var8_16];
                if (adapter.match(path, isPathContainer, this.pathMatcher)) {
                    match = true;
                    break;
                }
                ++var8_16;
            }
            if (!match) {
                return false;
            }
        }
        if (!ObjectUtils.isEmpty((Object[])this.includeHttpMethods)) {
            void var8_18;
            boolean match = false;
            HttpMethod[] httpMethodArray = this.includeHttpMethods;
            n = httpMethodArray.length;
            boolean bl = false;
            while (var8_18 < n) {
                HttpMethod included = httpMethodArray[var8_18];
                if (included == httpMethod) {
                    match = true;
                    break;
                }
                ++var8_18;
            }
            if (!match) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        return this.interceptor.preHandle(request, response, handler);
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable ModelAndView modelAndView) throws Exception {
        this.interceptor.postHandle(request, response, handler, modelAndView);
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable Exception ex) throws Exception {
        this.interceptor.afterCompletion(request, response, handler, ex);
    }

    private static class PatternAdapter {
        private final String patternString;
        private final @Nullable PathPattern pathPattern;

        public PatternAdapter(String pattern, @Nullable PathPatternParser parser) {
            this.patternString = pattern;
            this.pathPattern = PatternAdapter.initPathPattern(pattern, parser);
        }

        private static @Nullable PathPattern initPathPattern(String pattern, @Nullable PathPatternParser parser) {
            try {
                return (parser != null ? parser : PathPatternParser.defaultInstance).parse(pattern);
            }
            catch (PatternParseException ex) {
                return null;
            }
        }

        public String getPatternString() {
            return this.patternString;
        }

        public boolean match(Object path, boolean isPathContainer, PathMatcher pathMatcher) {
            if (isPathContainer) {
                PathContainer pathContainer = (PathContainer)path;
                if (this.pathPattern != null) {
                    return this.pathPattern.matches(pathContainer);
                }
                String lookupPath = pathContainer.value();
                path = UrlPathHelper.defaultInstance.removeSemicolonContent(lookupPath);
            }
            return pathMatcher.match(this.patternString, (String)path);
        }

        public static PatternAdapter @Nullable [] initPatterns(String @Nullable [] patterns, @Nullable PathPatternParser parser) {
            if (ObjectUtils.isEmpty((Object[])patterns)) {
                return null;
            }
            return (PatternAdapter[])Arrays.stream(patterns).map(pattern -> new PatternAdapter((String)pattern, parser)).toArray(PatternAdapter[]::new);
        }
    }
}

