/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import java.beans.PropertyEditor;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import org.springframework.web.servlet.support.RequestContext;
import org.springframework.web.util.HtmlUtils;

public class BindStatus {
    private final RequestContext requestContext;
    private final String path;
    private final boolean htmlEscape;
    private final String expression;
    private final Errors errors;
    private PropertyEditor editor;
    private Object value;
    private List objectErrors;
    private String[] errorCodes;
    private String[] errorMessages;

    public BindStatus(RequestContext requestContext, String path, boolean htmlEscape) throws IllegalStateException {
        this.requestContext = requestContext;
        this.path = path;
        this.htmlEscape = htmlEscape;
        String beanName = null;
        int dotPos = path.indexOf(46);
        if (dotPos == -1) {
            beanName = path;
            this.expression = null;
        } else {
            beanName = path.substring(0, dotPos);
            this.expression = path.substring(dotPos + 1);
        }
        this.errors = requestContext.getErrors(beanName, false);
        if (this.errors != null) {
            if (this.expression != null) {
                if ("*".equals(this.expression)) {
                    this.objectErrors = this.errors.getAllErrors();
                } else if (this.expression.endsWith("*")) {
                    this.objectErrors = this.errors.getFieldErrors(this.expression);
                } else {
                    this.objectErrors = this.errors.getFieldErrors(this.expression);
                    if (this.errors instanceof BindException) {
                        this.editor = ((BindException)this.errors).getCustomEditor(this.expression);
                    }
                    this.value = this.errors.getFieldValue(this.expression);
                }
            } else {
                this.objectErrors = this.errors.getGlobalErrors();
            }
            this.initErrorCodes();
        } else {
            Object target = requestContext.getModelObject(beanName);
            if (target == null) {
                throw new IllegalStateException("Neither Errors instance nor plain target object for bean name '" + beanName + "' available as request attribute");
            }
            if (this.expression != null && !"*".equals(this.expression) && !this.expression.endsWith("*")) {
                BeanWrapperImpl bw = new BeanWrapperImpl(target);
                this.value = bw.getPropertyValue(this.expression);
            }
            this.errorCodes = new String[0];
            this.errorMessages = new String[0];
        }
        if (htmlEscape && this.value instanceof String) {
            this.value = HtmlUtils.htmlEscape((String)((String)this.value));
        }
    }

    private void initErrorCodes() {
        this.errorCodes = new String[this.objectErrors.size()];
        for (int i = 0; i < this.objectErrors.size(); ++i) {
            ObjectError error = (ObjectError)this.objectErrors.get(i);
            this.errorCodes[i] = error.getCode();
        }
    }

    private void initErrorMessages() throws NoSuchMessageException {
        if (this.errorMessages == null) {
            this.errorMessages = new String[this.objectErrors.size()];
            for (int i = 0; i < this.objectErrors.size(); ++i) {
                ObjectError error = (ObjectError)this.objectErrors.get(i);
                this.errorMessages[i] = this.requestContext.getMessage((MessageSourceResolvable)error, this.htmlEscape);
            }
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getExpression() {
        return this.expression;
    }

    public Object getValue() {
        return this.value;
    }

    public String getDisplayValue() {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        if (this.value != null) {
            return this.htmlEscape ? HtmlUtils.htmlEscape((String)this.value.toString()) : this.value.toString();
        }
        return "";
    }

    public boolean isError() {
        return this.errorCodes != null && this.errorCodes.length > 0;
    }

    public String[] getErrorCodes() {
        return this.errorCodes;
    }

    public String getErrorCode() {
        return this.errorCodes.length > 0 ? this.errorCodes[0] : "";
    }

    public String[] getErrorMessages() {
        this.initErrorMessages();
        return this.errorMessages;
    }

    public String getErrorMessage() {
        this.initErrorMessages();
        return this.errorMessages.length > 0 ? this.errorMessages[0] : "";
    }

    public String getErrorMessagesAsString(String delimiter) {
        this.initErrorMessages();
        return StringUtils.arrayToDelimitedString((Object[])this.errorMessages, (String)delimiter);
    }

    public Errors getErrors() {
        return this.errors;
    }

    public PropertyEditor getEditor() {
        return this.editor;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("BindStatus: ");
        sb.append("expression=[").append(this.expression).append("]; ");
        sb.append("value=[").append(this.value).append("]");
        if (this.isError()) {
            sb.append("; errorCodes=" + Arrays.asList(this.errorCodes));
        }
        return sb.toString();
    }
}

