/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.BaseCommandController;

public abstract class AbstractFormController
extends BaseCommandController {
    private boolean bindOnNewForm = false;
    private boolean sessionForm = false;

    public AbstractFormController() {
        this.setCacheSeconds(0);
    }

    public final void setBindOnNewForm(boolean bindOnNewForm) {
        this.bindOnNewForm = bindOnNewForm;
    }

    public final boolean isBindOnNewForm() {
        return this.bindOnNewForm;
    }

    public final void setSessionForm(boolean sessionForm) {
        this.sessionForm = sessionForm;
    }

    public final boolean isSessionForm() {
        return this.sessionForm;
    }

    protected final ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isFormSubmission(request)) {
            HttpSession session;
            if (this.isSessionForm() && ((session = request.getSession(false)) == null || session.getAttribute(this.getFormSessionAttributeName(request)) == null)) {
                return this.handleInvalidSubmit(request, response);
            }
            Object command = this.getCommand(request);
            ServletRequestDataBinder binder = this.bindAndValidate(request, command);
            return this.processFormSubmission(request, response, command, binder.getErrors());
        }
        return this.showNewForm(request, response);
    }

    protected boolean isFormSubmission(HttpServletRequest request) {
        return "POST".equals(request.getMethod());
    }

    protected String getFormSessionAttributeName(HttpServletRequest request) {
        return this.getFormSessionAttributeName();
    }

    protected String getFormSessionAttributeName() {
        return this.getClass().getName() + ".FORM." + this.getCommandName();
    }

    protected final ModelAndView showNewForm(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logger.debug((Object)"Displaying new form");
        return this.showForm(request, response, this.getErrorsForNewForm(request));
    }

    protected final BindException getErrorsForNewForm(HttpServletRequest request) throws Exception {
        Object command = this.formBackingObject(request);
        if (command == null) {
            throw new ServletException("Form object returned by formBackingObject() must not be null");
        }
        if (!this.checkCommand(command)) {
            throw new ServletException("Form object returned by formBackingObject() must match commandClass");
        }
        ServletRequestDataBinder binder = this.createBinder(request, command);
        if (this.isBindOnNewForm()) {
            this.logger.debug((Object)"Binding to new form");
            binder.bind((ServletRequest)request);
            this.onBindOnNewForm(request, command, binder.getErrors());
        }
        return binder.getErrors();
    }

    protected void onBindOnNewForm(HttpServletRequest request, Object command, BindException errors) throws Exception {
        this.onBindOnNewForm(request, command);
    }

    protected void onBindOnNewForm(HttpServletRequest request, Object command) throws Exception {
    }

    protected final Object getCommand(HttpServletRequest request) throws Exception {
        if (!this.isSessionForm()) {
            return this.formBackingObject(request);
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            throw new ServletException("Must have session when trying to bind (in session-form mode)");
        }
        String formAttrName = this.getFormSessionAttributeName(request);
        Object sessionFormObject = session.getAttribute(formAttrName);
        if (sessionFormObject == null) {
            throw new ServletException("Form object not found in session (in session-form mode)");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Removing form session attribute [" + formAttrName + "]"));
        }
        session.removeAttribute(formAttrName);
        return sessionFormObject;
    }

    protected Object formBackingObject(HttpServletRequest request) throws Exception {
        return this.createCommand();
    }

    protected abstract ModelAndView showForm(HttpServletRequest var1, HttpServletResponse var2, BindException var3) throws Exception;

    protected final ModelAndView showForm(HttpServletRequest request, BindException errors, String viewName) throws Exception {
        return this.showForm(request, errors, viewName, null);
    }

    protected final ModelAndView showForm(HttpServletRequest request, BindException errors, String viewName, Map controlModel) throws Exception {
        if (this.isSessionForm()) {
            String formAttrName = this.getFormSessionAttributeName(request);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Setting form session attribute [" + formAttrName + "] to: " + errors.getTarget()));
            }
            request.getSession().setAttribute(formAttrName, errors.getTarget());
        }
        Map model = errors.getModel();
        Map referenceData = this.referenceData(request, errors.getTarget(), (Errors)errors);
        if (referenceData != null) {
            model.putAll(referenceData);
        }
        if (controlModel != null) {
            model.putAll(controlModel);
        }
        return new ModelAndView(viewName, model);
    }

    protected Map referenceData(HttpServletRequest request, Object command, Errors errors) throws Exception {
        return null;
    }

    protected abstract ModelAndView processFormSubmission(HttpServletRequest var1, HttpServletResponse var2, Object var3, BindException var4) throws Exception;

    protected ModelAndView handleInvalidSubmit(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object command = this.formBackingObject(request);
        ServletRequestDataBinder binder = this.bindAndValidate(request, command);
        return this.processFormSubmission(request, response, command, binder.getErrors());
    }
}

