/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.accept;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import org.jspecify.annotations.Nullable;
import org.springframework.http.MediaType;
import org.springframework.web.accept.ApiVersionResolver;

public class MediaTypeParamApiVersionResolver
implements ApiVersionResolver {
    private final MediaType compatibleMediaType;
    private final String parameterName;

    public MediaTypeParamApiVersionResolver(MediaType compatibleMediaType, String paramName) {
        this.compatibleMediaType = compatibleMediaType;
        this.parameterName = paramName;
    }

    @Override
    public @Nullable String resolveVersion(HttpServletRequest request) {
        String header;
        Enumeration headers = request.getHeaders("Accept");
        while (headers.hasMoreElements()) {
            header = (String)headers.nextElement();
            for (MediaType mediaType : MediaType.parseMediaTypes(header)) {
                if (!this.compatibleMediaType.isCompatibleWith(mediaType)) continue;
                return mediaType.getParameter(this.parameterName);
            }
        }
        header = request.getHeader("Content-Type");
        for (MediaType mediaType : MediaType.parseMediaTypes(header)) {
            if (!this.compatibleMediaType.isCompatibleWith(mediaType)) continue;
            return mediaType.getParameter(this.parameterName);
        }
        return null;
    }
}

