/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.annotation.support;

import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.MethodArgumentResolutionException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;

public class MethodArgumentNotValidException
extends MethodArgumentResolutionException {
    private BindingResult bindingResult;

    public MethodArgumentNotValidException(Message<?> message, MethodParameter parameter) {
        super(message, parameter);
    }

    public MethodArgumentNotValidException(Message<?> message, MethodParameter parameter, BindingResult bindingResult) {
        super(message, parameter, MethodArgumentNotValidException.getValidationErrorMessage(bindingResult));
        this.bindingResult = bindingResult;
    }

    @Nullable
    public final BindingResult getBindingResult() {
        return this.bindingResult;
    }

    private static String getValidationErrorMessage(BindingResult bindingResult) {
        StringBuilder sb = new StringBuilder();
        sb.append(bindingResult.getErrorCount()).append(" error(s): ");
        for (ObjectError error : bindingResult.getAllErrors()) {
            sb.append("[").append(error).append("] ");
        }
        return sb.toString();
    }
}

