/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;

public class CompositeMessageConverter
implements MessageConverter {
    private final List<MessageConverter> converters;

    public CompositeMessageConverter(Collection<MessageConverter> converters) {
        Assert.notEmpty(converters, (String)"Converters must not be empty");
        this.converters = new ArrayList<MessageConverter>(converters);
    }

    public List<MessageConverter> getConverters() {
        return this.converters;
    }

    @Override
    public Object fromMessage(Message<?> message, Class<?> targetClass) {
        for (MessageConverter converter : this.converters) {
            Object result = converter.fromMessage(message, targetClass);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Message<?> toMessage(Object payload, MessageHeaders headers) {
        for (MessageConverter converter : this.converters) {
            Message<?> result = converter.toMessage(payload, headers);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public String toString() {
        return "CompositeMessageConverter[converters=" + this.converters + "]";
    }
}

