/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.beanvalidation;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.Iterator;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.Assert;

public class BeanValidationPostProcessor
implements BeanPostProcessor,
InitializingBean {
    private @Nullable Validator validator;
    private boolean afterInitialization = false;

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void setValidatorFactory(ValidatorFactory validatorFactory) {
        this.validator = validatorFactory.getValidator();
    }

    public void setAfterInitialization(boolean afterInitialization) {
        this.afterInitialization = afterInitialization;
    }

    public void afterPropertiesSet() {
        if (this.validator == null) {
            this.validator = Validation.buildDefaultValidatorFactory().getValidator();
        }
    }

    public Object postProcessBeforeInitialization(Object bean2, String beanName) throws BeansException {
        if (!this.afterInitialization) {
            this.doValidate(bean2);
        }
        return bean2;
    }

    public Object postProcessAfterInitialization(Object bean2, String beanName) throws BeansException {
        if (this.afterInitialization) {
            this.doValidate(bean2);
        }
        return bean2;
    }

    protected void doValidate(Object bean2) {
        Set result;
        Assert.state((this.validator != null ? 1 : 0) != 0, (String)"No Validator set");
        Object objectToValidate = AopProxyUtils.getSingletonTarget((Object)bean2);
        if (objectToValidate == null) {
            objectToValidate = bean2;
        }
        if (!(result = this.validator.validate(objectToValidate, new Class[0])).isEmpty()) {
            StringBuilder sb = new StringBuilder("Bean state is invalid: ");
            Iterator it = result.iterator();
            while (it.hasNext()) {
                ConstraintViolation violation = (ConstraintViolation)it.next();
                sb.append(violation.getPropertyPath()).append(" - ").append(violation.getMessage());
                if (!it.hasNext()) continue;
                sb.append("; ");
            }
            throw new BeanInitializationException(sb.toString());
        }
    }
}

