/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public interface Errors {
    public static final String NESTED_PATH_SEPARATOR = ".";

    public String getObjectName();

    default public void setNestedPath(String nestedPath) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support nested paths");
    }

    default public String getNestedPath() {
        return "";
    }

    default public void pushNestedPath(String subPath) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support nested paths");
    }

    default public void popNestedPath() throws IllegalStateException {
        throw new IllegalStateException("Cannot pop nested path: no nested path on stack");
    }

    default public void reject(String errorCode) {
        this.reject(errorCode, null, null);
    }

    default public void reject(String errorCode, String defaultMessage) {
        this.reject(errorCode, null, defaultMessage);
    }

    public void reject(String var1, Object @Nullable [] var2, @Nullable String var3);

    default public void rejectValue(@Nullable String field, String errorCode) {
        this.rejectValue(field, errorCode, null, null);
    }

    default public void rejectValue(@Nullable String field, String errorCode, String defaultMessage) {
        this.rejectValue(field, errorCode, null, defaultMessage);
    }

    public void rejectValue(@Nullable String var1, String var2, Object @Nullable [] var3, @Nullable String var4);

    default public void addAllErrors(Errors errors) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support addAllErrors");
    }

    default public <T extends Throwable> void failOnError(Function<String, T> messageToException) throws T {
        if (this.hasErrors()) {
            throw (Throwable)messageToException.apply(this.toString());
        }
    }

    default public boolean hasErrors() {
        return !this.getGlobalErrors().isEmpty() || !this.getFieldErrors().isEmpty();
    }

    default public int getErrorCount() {
        return this.getGlobalErrors().size() + this.getFieldErrors().size();
    }

    default public List<ObjectError> getAllErrors() {
        return Stream.concat(this.getGlobalErrors().stream(), this.getFieldErrors().stream()).toList();
    }

    default public boolean hasGlobalErrors() {
        return !this.getGlobalErrors().isEmpty();
    }

    default public int getGlobalErrorCount() {
        return this.getGlobalErrors().size();
    }

    public List<ObjectError> getGlobalErrors();

    default public @Nullable ObjectError getGlobalError() {
        return this.getGlobalErrors().stream().findFirst().orElse(null);
    }

    default public boolean hasFieldErrors() {
        return !this.getFieldErrors().isEmpty();
    }

    default public int getFieldErrorCount() {
        return this.getFieldErrors().size();
    }

    public List<FieldError> getFieldErrors();

    default public @Nullable FieldError getFieldError() {
        return this.getFieldErrors().stream().findFirst().orElse(null);
    }

    default public boolean hasFieldErrors(String field) {
        return this.getFieldError(field) != null;
    }

    default public int getFieldErrorCount(String field) {
        return this.getFieldErrors(field).size();
    }

    default public List<FieldError> getFieldErrors(String field) {
        return this.getFieldErrors().stream().filter(error -> field.equals(error.getField())).toList();
    }

    default public @Nullable FieldError getFieldError(String field) {
        return this.getFieldErrors().stream().filter(error -> field.equals(error.getField())).findFirst().orElse(null);
    }

    public @Nullable Object getFieldValue(String var1);

    default public @Nullable Class<?> getFieldType(String field) {
        return Optional.ofNullable(this.getFieldValue(field)).map(Object::getClass).orElse(null);
    }

    public String toString();
}

