/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.jcache.interceptor;

import javax.cache.annotation.CacheRemove;
import org.jspecify.annotations.Nullable;
import org.springframework.cache.Cache;
import org.springframework.cache.interceptor.CacheErrorHandler;
import org.springframework.cache.interceptor.CacheOperationInvocationContext;
import org.springframework.cache.interceptor.CacheOperationInvoker;
import org.springframework.cache.jcache.interceptor.AbstractKeyCacheInterceptor;
import org.springframework.cache.jcache.interceptor.CacheRemoveOperation;

class CacheRemoveEntryInterceptor
extends AbstractKeyCacheInterceptor<CacheRemoveOperation, CacheRemove> {
    protected CacheRemoveEntryInterceptor(CacheErrorHandler errorHandler) {
        super(errorHandler);
    }

    @Override
    protected @Nullable Object invoke(CacheOperationInvocationContext<CacheRemoveOperation> context, CacheOperationInvoker invoker) {
        CacheRemoveOperation operation = (CacheRemoveOperation)context.getOperation();
        boolean earlyRemove = operation.isEarlyRemove();
        if (earlyRemove) {
            this.removeValue(context);
        }
        try {
            Object result = invoker.invoke();
            if (!earlyRemove) {
                this.removeValue(context);
            }
            return result;
        }
        catch (CacheOperationInvoker.ThrowableWrapper ex) {
            Throwable original = ex.getOriginal();
            if (!earlyRemove && operation.getExceptionTypeFilter().match(original)) {
                this.removeValue(context);
            }
            throw ex;
        }
    }

    private void removeValue(CacheOperationInvocationContext<CacheRemoveOperation> context) {
        Object key = this.generateKey(context);
        Cache cache = this.resolveCache(context);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Invalidating key [" + String.valueOf(key) + "] on cache '" + cache.getName() + "' for operation " + String.valueOf(context.getOperation())));
        }
        this.doEvict(cache, key, ((CacheRemoveOperation)context.getOperation()).isEarlyRemove());
    }
}

