/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.test.context.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.function.Supplier;
import org.springframework.beans.BeanUtils;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.test.context.TestSecurityContextHolder;
import org.springframework.security.test.context.support.TestExecutionEvent;
import org.springframework.security.test.context.support.WithSecurityContext;
import org.springframework.security.test.context.support.WithSecurityContextFactory;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class WithSecurityContextTestExecutionListener
extends AbstractTestExecutionListener {
    static final String SECURITY_CONTEXT_ATTR_NAME = WithSecurityContextTestExecutionListener.class.getName().concat(".SECURITY_CONTEXT");

    public void beforeTestMethod(TestContext testContext) {
        TestSecurityContext testSecurityContext = this.createTestSecurityContext(testContext.getTestMethod(), testContext);
        if (testSecurityContext == null) {
            testSecurityContext = this.createTestSecurityContext(testContext.getTestClass(), testContext);
        }
        if (testSecurityContext == null) {
            return;
        }
        Supplier<SecurityContext> supplier = testSecurityContext.getSecurityContextSupplier();
        if (testSecurityContext.getTestExecutionEvent() == TestExecutionEvent.TEST_METHOD) {
            TestSecurityContextHolder.setContext(supplier.get());
        } else {
            testContext.setAttribute(SECURITY_CONTEXT_ATTR_NAME, supplier);
        }
    }

    public void beforeTestExecution(TestContext testContext) {
        Supplier supplier = (Supplier)testContext.removeAttribute(SECURITY_CONTEXT_ATTR_NAME);
        if (supplier != null) {
            TestSecurityContextHolder.setContext((SecurityContext)supplier.get());
        }
    }

    private TestSecurityContext createTestSecurityContext(AnnotatedElement annotated, TestContext context) {
        WithSecurityContext withSecurityContext = (WithSecurityContext)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)annotated, WithSecurityContext.class);
        return this.createTestSecurityContext(annotated, withSecurityContext, context);
    }

    private TestSecurityContext createTestSecurityContext(Class<?> annotated, TestContext context) {
        TestContextAnnotationUtils.AnnotationDescriptor withSecurityContextDescriptor = TestContextAnnotationUtils.findAnnotationDescriptor(annotated, WithSecurityContext.class);
        if (withSecurityContextDescriptor == null) {
            return null;
        }
        WithSecurityContext withSecurityContext = (WithSecurityContext)withSecurityContextDescriptor.getAnnotation();
        Class rootDeclaringClass = withSecurityContextDescriptor.getRootDeclaringClass();
        return this.createTestSecurityContext(rootDeclaringClass, withSecurityContext, context);
    }

    private TestSecurityContext createTestSecurityContext(AnnotatedElement annotated, WithSecurityContext withSecurityContext, TestContext context) {
        if (withSecurityContext == null) {
            return null;
        }
        withSecurityContext = (WithSecurityContext)AnnotationUtils.synthesizeAnnotation((Annotation)withSecurityContext, (AnnotatedElement)annotated);
        WithSecurityContextFactory<? extends Annotation> factory = this.createFactory(withSecurityContext, context);
        Class type = GenericTypeResolver.resolveTypeArgument(factory.getClass(), WithSecurityContextFactory.class);
        Annotation annotation = this.findAnnotation(annotated, type);
        Supplier<SecurityContext> supplier = () -> {
            try {
                return factory.createSecurityContext(annotation);
            }
            catch (RuntimeException ex) {
                throw new IllegalStateException("Unable to create SecurityContext using " + annotation, ex);
            }
        };
        TestExecutionEvent initialize = withSecurityContext.setupBefore();
        return new TestSecurityContext(supplier, initialize);
    }

    private Annotation findAnnotation(AnnotatedElement annotated, Class<? extends Annotation> type) {
        Annotation[] allAnnotations;
        Annotation findAnnotation = AnnotationUtils.findAnnotation((AnnotatedElement)annotated, type);
        if (findAnnotation != null) {
            return findAnnotation;
        }
        for (Annotation annotationToTest : allAnnotations = AnnotationUtils.getAnnotations((AnnotatedElement)annotated)) {
            WithSecurityContext withSecurityContext = (WithSecurityContext)AnnotationUtils.findAnnotation(annotationToTest.annotationType(), WithSecurityContext.class);
            if (withSecurityContext == null) continue;
            return annotationToTest;
        }
        return null;
    }

    private WithSecurityContextFactory<? extends Annotation> createFactory(WithSecurityContext withSecurityContext, TestContext testContext) {
        Class<? extends WithSecurityContextFactory<? extends Annotation>> clazz = withSecurityContext.factory();
        try {
            return (WithSecurityContextFactory)testContext.getApplicationContext().getAutowireCapableBeanFactory().createBean(clazz);
        }
        catch (IllegalStateException ex) {
            return (WithSecurityContextFactory)BeanUtils.instantiateClass(clazz);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void afterTestMethod(TestContext testContext) {
        TestSecurityContextHolder.clearContext();
    }

    public int getOrder() {
        return 10000;
    }

    static class TestSecurityContext {
        private final Supplier<SecurityContext> securityContextSupplier;
        private final TestExecutionEvent testExecutionEvent;

        TestSecurityContext(Supplier<SecurityContext> securityContextSupplier, TestExecutionEvent testExecutionEvent) {
            this.securityContextSupplier = securityContextSupplier;
            this.testExecutionEvent = testExecutionEvent;
        }

        Supplier<SecurityContext> getSecurityContextSupplier() {
            return this.securityContextSupplier;
        }

        TestExecutionEvent getTestExecutionEvent() {
            return this.testExecutionEvent;
        }
    }
}

