/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.test.web.servlet.request;

import javax.servlet.ServletContext;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.web.util.UriComponentsBuilder;

public final class SecurityMockMvcRequestBuilders {
    public static FormLoginRequestBuilder formLogin() {
        return new FormLoginRequestBuilder();
    }

    public static FormLoginRequestBuilder formLogin(String loginProcessingUrl) {
        return SecurityMockMvcRequestBuilders.formLogin().loginProcessingUrl(loginProcessingUrl);
    }

    public static LogoutRequestBuilder logout() {
        return new LogoutRequestBuilder();
    }

    public static LogoutRequestBuilder logout(String logoutUrl) {
        return new LogoutRequestBuilder().logoutUrl(logoutUrl);
    }

    private SecurityMockMvcRequestBuilders() {
    }

    public static final class FormLoginRequestBuilder
    implements RequestBuilder {
        private String usernameParam = "username";
        private String passwordParam = "password";
        private String username = "user";
        private String password = "password";
        private String loginProcessingUrl = "/login";
        private MediaType acceptMediaType = MediaType.APPLICATION_FORM_URLENCODED;
        private RequestPostProcessor postProcessor = SecurityMockMvcRequestPostProcessors.csrf();

        public MockHttpServletRequest buildRequest(ServletContext servletContext) {
            MockHttpServletRequest request = MockMvcRequestBuilders.post((String)this.loginProcessingUrl, (Object[])new Object[0]).accept(new MediaType[]{this.acceptMediaType}).param(this.usernameParam, new String[]{this.username}).param(this.passwordParam, new String[]{this.password}).buildRequest(servletContext);
            return this.postProcessor.postProcessRequest(request);
        }

        public FormLoginRequestBuilder loginProcessingUrl(String loginProcessingUrl) {
            this.loginProcessingUrl = loginProcessingUrl;
            return this;
        }

        public FormLoginRequestBuilder loginProcessingUrl(String loginProcessingUrl, Object ... uriVars) {
            this.loginProcessingUrl = UriComponentsBuilder.fromPath((String)loginProcessingUrl).buildAndExpand(uriVars).encode().toString();
            return this;
        }

        public FormLoginRequestBuilder userParameter(String usernameParameter) {
            this.usernameParam = usernameParameter;
            return this;
        }

        public FormLoginRequestBuilder passwordParam(String passwordParameter) {
            this.passwordParam = passwordParameter;
            return this;
        }

        public FormLoginRequestBuilder password(String password) {
            this.password = password;
            return this;
        }

        public FormLoginRequestBuilder user(String username) {
            this.username = username;
            return this;
        }

        public FormLoginRequestBuilder password(String passwordParameter, String password) {
            this.passwordParam(passwordParameter);
            this.password = password;
            return this;
        }

        public FormLoginRequestBuilder user(String usernameParameter, String username) {
            this.userParameter(usernameParameter);
            this.username = username;
            return this;
        }

        public FormLoginRequestBuilder acceptMediaType(MediaType acceptMediaType) {
            this.acceptMediaType = acceptMediaType;
            return this;
        }

        private FormLoginRequestBuilder() {
        }
    }

    public static final class LogoutRequestBuilder
    implements RequestBuilder {
        private String logoutUrl = "/logout";
        private RequestPostProcessor postProcessor = SecurityMockMvcRequestPostProcessors.csrf();

        public MockHttpServletRequest buildRequest(ServletContext servletContext) {
            MockHttpServletRequest request = MockMvcRequestBuilders.post((String)this.logoutUrl, (Object[])new Object[0]).accept(new MediaType[]{MediaType.TEXT_HTML, MediaType.ALL}).buildRequest(servletContext);
            return this.postProcessor.postProcessRequest(request);
        }

        public LogoutRequestBuilder logoutUrl(String logoutUrl) {
            this.logoutUrl = logoutUrl;
            return this;
        }

        public LogoutRequestBuilder logoutUrl(String logoutUrl, Object ... uriVars) {
            this.logoutUrl = UriComponentsBuilder.fromPath((String)logoutUrl).buildAndExpand(uriVars).encode().toString();
            return this;
        }

        private LogoutRequestBuilder() {
        }
    }
}

