/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.builders;

import io.micrometer.observation.ObservationRegistry;
import jakarta.servlet.Filter;
import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.access.intercept.AbstractSecurityInterceptor;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.config.annotation.AbstractConfiguredSecurityBuilder;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.SecurityBuilder;
import org.springframework.security.config.annotation.web.AbstractRequestMatcherRegistry;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.ObservationFilterChainDecorator;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AuthorizationManagerWebInvocationPrivilegeEvaluator;
import org.springframework.security.web.access.DefaultWebInvocationPrivilegeEvaluator;
import org.springframework.security.web.access.RequestMatcherDelegatingWebInvocationPrivilegeEvaluator;
import org.springframework.security.web.access.WebInvocationPrivilegeEvaluator;
import org.springframework.security.web.access.expression.DefaultWebSecurityExpressionHandler;
import org.springframework.security.web.access.intercept.AuthorizationFilter;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.debug.DebugFilter;
import org.springframework.security.web.firewall.CompositeRequestRejectedHandler;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.firewall.HttpStatusRequestRejectedHandler;
import org.springframework.security.web.firewall.ObservationMarkingRequestRejectedHandler;
import org.springframework.security.web.firewall.RequestRejectedHandler;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcherEntry;
import org.springframework.util.Assert;
import org.springframework.web.context.ServletContextAware;

public final class WebSecurity
extends AbstractConfiguredSecurityBuilder<Filter, WebSecurity>
implements SecurityBuilder<Filter>,
ApplicationContextAware,
ServletContextAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final List<RequestMatcher> ignoredRequests = new ArrayList<RequestMatcher>();
    private final List<SecurityBuilder<? extends SecurityFilterChain>> securityFilterChainBuilders = new ArrayList<SecurityBuilder<? extends SecurityFilterChain>>();
    private IgnoredRequestConfigurer ignoredRequestRegistry;
    private HttpFirewall httpFirewall;
    private RequestRejectedHandler requestRejectedHandler;
    private boolean debugEnabled;
    private WebInvocationPrivilegeEvaluator privilegeEvaluator;
    private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;
    private AuthorizationManagerWebInvocationPrivilegeEvaluator.HttpServletRequestTransformer privilegeEvaluatorRequestTransformer;
    private DefaultWebSecurityExpressionHandler defaultWebSecurityExpressionHandler;
    private SecurityExpressionHandler<FilterInvocation> expressionHandler = this.defaultWebSecurityExpressionHandler = new DefaultWebSecurityExpressionHandler();
    private Runnable postBuildAction = () -> {};
    private ServletContext servletContext;

    public WebSecurity(ObjectPostProcessor<Object> objectPostProcessor) {
        super(objectPostProcessor);
    }

    public IgnoredRequestConfigurer ignoring() {
        return this.ignoredRequestRegistry;
    }

    public WebSecurity httpFirewall(HttpFirewall httpFirewall) {
        this.httpFirewall = httpFirewall;
        return this;
    }

    public WebSecurity debug(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
        return this;
    }

    public WebSecurity addSecurityFilterChainBuilder(SecurityBuilder<? extends SecurityFilterChain> securityFilterChainBuilder) {
        this.securityFilterChainBuilders.add(securityFilterChainBuilder);
        return this;
    }

    public WebSecurity privilegeEvaluator(WebInvocationPrivilegeEvaluator privilegeEvaluator) {
        this.privilegeEvaluator = privilegeEvaluator;
        return this;
    }

    public WebSecurity expressionHandler(SecurityExpressionHandler<FilterInvocation> expressionHandler) {
        Assert.notNull(expressionHandler, (String)"expressionHandler cannot be null");
        this.expressionHandler = expressionHandler;
        return this;
    }

    public SecurityExpressionHandler<FilterInvocation> getExpressionHandler() {
        return this.expressionHandler;
    }

    public WebInvocationPrivilegeEvaluator getPrivilegeEvaluator() {
        return this.privilegeEvaluator;
    }

    public WebSecurity postBuildAction(Runnable postBuildAction) {
        this.postBuildAction = postBuildAction;
        return this;
    }

    public WebSecurity requestRejectedHandler(RequestRejectedHandler requestRejectedHandler) {
        Assert.notNull((Object)requestRejectedHandler, (String)"requestRejectedHandler cannot be null");
        this.requestRejectedHandler = requestRejectedHandler;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Filter performBuild() throws Exception {
        void var5_12;
        SecurityFilterChain securityFilterChain;
        Assert.state((!this.securityFilterChainBuilders.isEmpty() ? 1 : 0) != 0, () -> "At least one SecurityBuilder<? extends SecurityFilterChain> needs to be specified. Typically this is done by exposing a SecurityFilterChain bean. More advanced users can invoke " + WebSecurity.class.getSimpleName() + ".addSecurityFilterChainBuilder directly");
        int chainSize = this.ignoredRequests.size() + this.securityFilterChainBuilders.size();
        ArrayList<SecurityFilterChain> securityFilterChains = new ArrayList<SecurityFilterChain>(chainSize);
        ArrayList<RequestMatcherEntry<List<WebInvocationPrivilegeEvaluator>>> requestMatcherPrivilegeEvaluatorsEntries = new ArrayList<RequestMatcherEntry<List<WebInvocationPrivilegeEvaluator>>>();
        for (RequestMatcher requestMatcher : this.ignoredRequests) {
            this.logger.warn((Object)("You are asking Spring Security to ignore " + String.valueOf(requestMatcher) + ". This is not recommended -- please use permitAll via HttpSecurity#authorizeHttpRequests instead."));
            securityFilterChain = new DefaultSecurityFilterChain(requestMatcher, new Filter[0]);
            securityFilterChains.add(securityFilterChain);
            requestMatcherPrivilegeEvaluatorsEntries.add(this.getRequestMatcherPrivilegeEvaluatorsEntry(securityFilterChain));
        }
        for (SecurityBuilder securityBuilder : this.securityFilterChainBuilders) {
            securityFilterChain = (SecurityFilterChain)securityBuilder.build();
            securityFilterChains.add(securityFilterChain);
            requestMatcherPrivilegeEvaluatorsEntries.add(this.getRequestMatcherPrivilegeEvaluatorsEntry(securityFilterChain));
        }
        if (this.privilegeEvaluator == null) {
            this.privilegeEvaluator = new RequestMatcherDelegatingWebInvocationPrivilegeEvaluator(requestMatcherPrivilegeEvaluatorsEntries);
        }
        FilterChainProxy filterChainProxy = new FilterChainProxy(securityFilterChains);
        if (this.httpFirewall != null) {
            filterChainProxy.setFirewall(this.httpFirewall);
        }
        if (this.requestRejectedHandler != null) {
            filterChainProxy.setRequestRejectedHandler(this.requestRejectedHandler);
        } else if (!this.observationRegistry.isNoop()) {
            CompositeRequestRejectedHandler compositeRequestRejectedHandler = new CompositeRequestRejectedHandler(new RequestRejectedHandler[]{new ObservationMarkingRequestRejectedHandler(this.observationRegistry), new HttpStatusRequestRejectedHandler()});
            filterChainProxy.setRequestRejectedHandler((RequestRejectedHandler)compositeRequestRejectedHandler);
        }
        filterChainProxy.setFilterChainDecorator(this.getFilterChainDecorator());
        filterChainProxy.afterPropertiesSet();
        FilterChainProxy filterChainProxy2 = filterChainProxy;
        if (this.debugEnabled) {
            this.logger.warn((Object)"\n\n********************************************************************\n**********        Security debugging is enabled.       *************\n**********    This may include sensitive information.  *************\n**********      Do not use in a production system!     *************\n********************************************************************\n\n");
            DebugFilter debugFilter = new DebugFilter(filterChainProxy);
        }
        this.postBuildAction.run();
        return var5_12;
    }

    private RequestMatcherEntry<List<WebInvocationPrivilegeEvaluator>> getRequestMatcherPrivilegeEvaluatorsEntry(SecurityFilterChain securityFilterChain) {
        ArrayList<Object> privilegeEvaluators = new ArrayList<Object>();
        for (Filter filter : securityFilterChain.getFilters()) {
            if (filter instanceof FilterSecurityInterceptor) {
                DefaultWebInvocationPrivilegeEvaluator defaultWebInvocationPrivilegeEvaluator = new DefaultWebInvocationPrivilegeEvaluator((AbstractSecurityInterceptor)((FilterSecurityInterceptor)filter));
                defaultWebInvocationPrivilegeEvaluator.setServletContext(this.servletContext);
                privilegeEvaluators.add(defaultWebInvocationPrivilegeEvaluator);
                continue;
            }
            if (!(filter instanceof AuthorizationFilter)) continue;
            AuthorizationManager authorizationManager = ((AuthorizationFilter)filter).getAuthorizationManager();
            AuthorizationManagerWebInvocationPrivilegeEvaluator evaluator = new AuthorizationManagerWebInvocationPrivilegeEvaluator(authorizationManager);
            evaluator.setServletContext(this.servletContext);
            if (this.privilegeEvaluatorRequestTransformer != null) {
                evaluator.setRequestTransformer(this.privilegeEvaluatorRequestTransformer);
            }
            privilegeEvaluators.add(evaluator);
        }
        return new RequestMatcherEntry(arg_0 -> ((SecurityFilterChain)securityFilterChain).matches(arg_0), privilegeEvaluators);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.defaultWebSecurityExpressionHandler.setApplicationContext(applicationContext);
        try {
            this.defaultWebSecurityExpressionHandler.setRoleHierarchy((RoleHierarchy)applicationContext.getBean(RoleHierarchy.class));
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        try {
            this.defaultWebSecurityExpressionHandler.setPermissionEvaluator((PermissionEvaluator)applicationContext.getBean(PermissionEvaluator.class));
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        this.ignoredRequestRegistry = new IgnoredRequestConfigurer(applicationContext);
        try {
            this.httpFirewall = (HttpFirewall)applicationContext.getBean(HttpFirewall.class);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        try {
            this.requestRejectedHandler = (RequestRejectedHandler)applicationContext.getBean(RequestRejectedHandler.class);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        try {
            this.observationRegistry = (ObservationRegistry)applicationContext.getBean(ObservationRegistry.class);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        Class<AuthorizationManagerWebInvocationPrivilegeEvaluator.HttpServletRequestTransformer> requestTransformerClass = AuthorizationManagerWebInvocationPrivilegeEvaluator.HttpServletRequestTransformer.class;
        this.privilegeEvaluatorRequestTransformer = (AuthorizationManagerWebInvocationPrivilegeEvaluator.HttpServletRequestTransformer)applicationContext.getBeanProvider(requestTransformerClass).getIfUnique();
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    FilterChainProxy.FilterChainDecorator getFilterChainDecorator() {
        if (this.observationRegistry.isNoop()) {
            return new FilterChainProxy.VirtualFilterChainDecorator();
        }
        return new ObservationFilterChainDecorator(this.observationRegistry);
    }

    public class IgnoredRequestConfigurer
    extends AbstractRequestMatcherRegistry<IgnoredRequestConfigurer> {
        IgnoredRequestConfigurer(ApplicationContext context) {
            this.setApplicationContext(context);
        }

        @Override
        protected IgnoredRequestConfigurer chainRequestMatchers(List<RequestMatcher> requestMatchers) {
            WebSecurity.this.ignoredRequests.addAll(requestMatchers);
            return this;
        }

        public WebSecurity and() {
            return WebSecurity.this;
        }
    }
}

