/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import io.micrometer.observation.ObservationRegistry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.annotation.Role;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.access.hierarchicalroles.NullRoleHierarchy;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authorization.AuthorizationEventPublisher;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.method.AuthorizationAdvisor;
import org.springframework.security.authorization.method.AuthorizationManagerAfterMethodInterceptor;
import org.springframework.security.authorization.method.AuthorizationManagerBeforeMethodInterceptor;
import org.springframework.security.authorization.method.PostAuthorizeAuthorizationManager;
import org.springframework.security.authorization.method.PostFilterAuthorizationMethodInterceptor;
import org.springframework.security.authorization.method.PreAuthorizeAuthorizationManager;
import org.springframework.security.authorization.method.PreFilterAuthorizationMethodInterceptor;
import org.springframework.security.authorization.method.PrePostTemplateDefaults;
import org.springframework.security.config.annotation.method.configuration.DeferringObservationAuthorizationManager;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.core.GrantedAuthorityDefaults;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.util.function.SingletonSupplier;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
final class PrePostMethodSecurityConfiguration
implements ImportAware,
AopInfrastructureBean {
    private int interceptorOrderOffset;

    PrePostMethodSecurityConfiguration() {
    }

    @Bean
    @Role(value=2)
    static MethodInterceptor preFilterAuthorizationMethodInterceptor(ObjectProvider<GrantedAuthorityDefaults> defaultsProvider, ObjectProvider<PrePostTemplateDefaults> methodSecurityDefaultsProvider, ObjectProvider<MethodSecurityExpressionHandler> expressionHandlerProvider, ObjectProvider<SecurityContextHolderStrategy> strategyProvider, ObjectProvider<RoleHierarchy> roleHierarchyProvider, PrePostMethodSecurityConfiguration configuration, ApplicationContext context) {
        PreFilterAuthorizationMethodInterceptor preFilter = new PreFilterAuthorizationMethodInterceptor();
        preFilter.setOrder(preFilter.getOrder() + configuration.interceptorOrderOffset);
        return new DeferringMethodInterceptor<PreFilterAuthorizationMethodInterceptor>(preFilter, f -> {
            methodSecurityDefaultsProvider.ifAvailable(arg_0 -> ((PreFilterAuthorizationMethodInterceptor)f).setTemplateDefaults(arg_0));
            f.setExpressionHandler((MethodSecurityExpressionHandler)expressionHandlerProvider.getIfAvailable(() -> PrePostMethodSecurityConfiguration.defaultExpressionHandler(defaultsProvider, roleHierarchyProvider, context)));
            strategyProvider.ifAvailable(arg_0 -> ((PreFilterAuthorizationMethodInterceptor)f).setSecurityContextHolderStrategy(arg_0));
        });
    }

    @Bean
    @Role(value=2)
    static MethodInterceptor preAuthorizeAuthorizationMethodInterceptor(ObjectProvider<GrantedAuthorityDefaults> defaultsProvider, ObjectProvider<PrePostTemplateDefaults> methodSecurityDefaultsProvider, ObjectProvider<MethodSecurityExpressionHandler> expressionHandlerProvider, ObjectProvider<SecurityContextHolderStrategy> strategyProvider, ObjectProvider<AuthorizationEventPublisher> eventPublisherProvider, ObjectProvider<ObservationRegistry> registryProvider, ObjectProvider<RoleHierarchy> roleHierarchyProvider, PrePostMethodSecurityConfiguration configuration, ApplicationContext context) {
        PreAuthorizeAuthorizationManager manager = new PreAuthorizeAuthorizationManager();
        manager.setApplicationContext(context);
        AuthorizationManagerBeforeMethodInterceptor preAuthorize = AuthorizationManagerBeforeMethodInterceptor.preAuthorize(PrePostMethodSecurityConfiguration.manager(manager, registryProvider));
        preAuthorize.setOrder(preAuthorize.getOrder() + configuration.interceptorOrderOffset);
        return new DeferringMethodInterceptor<AuthorizationManagerBeforeMethodInterceptor>(preAuthorize, f -> {
            methodSecurityDefaultsProvider.ifAvailable(arg_0 -> ((PreAuthorizeAuthorizationManager)manager).setTemplateDefaults(arg_0));
            manager.setExpressionHandler((MethodSecurityExpressionHandler)expressionHandlerProvider.getIfAvailable(() -> PrePostMethodSecurityConfiguration.defaultExpressionHandler(defaultsProvider, roleHierarchyProvider, context)));
            strategyProvider.ifAvailable(arg_0 -> ((AuthorizationManagerBeforeMethodInterceptor)f).setSecurityContextHolderStrategy(arg_0));
            eventPublisherProvider.ifAvailable(arg_0 -> ((AuthorizationManagerBeforeMethodInterceptor)f).setAuthorizationEventPublisher(arg_0));
        });
    }

    @Bean
    @Role(value=2)
    static MethodInterceptor postAuthorizeAuthorizationMethodInterceptor(ObjectProvider<GrantedAuthorityDefaults> defaultsProvider, ObjectProvider<PrePostTemplateDefaults> methodSecurityDefaultsProvider, ObjectProvider<MethodSecurityExpressionHandler> expressionHandlerProvider, ObjectProvider<SecurityContextHolderStrategy> strategyProvider, ObjectProvider<AuthorizationEventPublisher> eventPublisherProvider, ObjectProvider<ObservationRegistry> registryProvider, ObjectProvider<RoleHierarchy> roleHierarchyProvider, PrePostMethodSecurityConfiguration configuration, ApplicationContext context) {
        PostAuthorizeAuthorizationManager manager = new PostAuthorizeAuthorizationManager();
        manager.setApplicationContext(context);
        AuthorizationManagerAfterMethodInterceptor postAuthorize = AuthorizationManagerAfterMethodInterceptor.postAuthorize(PrePostMethodSecurityConfiguration.manager(manager, registryProvider));
        postAuthorize.setOrder(postAuthorize.getOrder() + configuration.interceptorOrderOffset);
        return new DeferringMethodInterceptor<AuthorizationManagerAfterMethodInterceptor>(postAuthorize, f -> {
            methodSecurityDefaultsProvider.ifAvailable(arg_0 -> ((PostAuthorizeAuthorizationManager)manager).setTemplateDefaults(arg_0));
            manager.setExpressionHandler((MethodSecurityExpressionHandler)expressionHandlerProvider.getIfAvailable(() -> PrePostMethodSecurityConfiguration.defaultExpressionHandler(defaultsProvider, roleHierarchyProvider, context)));
            strategyProvider.ifAvailable(arg_0 -> ((AuthorizationManagerAfterMethodInterceptor)f).setSecurityContextHolderStrategy(arg_0));
            eventPublisherProvider.ifAvailable(arg_0 -> ((AuthorizationManagerAfterMethodInterceptor)f).setAuthorizationEventPublisher(arg_0));
        });
    }

    @Bean
    @Role(value=2)
    static MethodInterceptor postFilterAuthorizationMethodInterceptor(ObjectProvider<GrantedAuthorityDefaults> defaultsProvider, ObjectProvider<PrePostTemplateDefaults> methodSecurityDefaultsProvider, ObjectProvider<MethodSecurityExpressionHandler> expressionHandlerProvider, ObjectProvider<SecurityContextHolderStrategy> strategyProvider, ObjectProvider<RoleHierarchy> roleHierarchyProvider, PrePostMethodSecurityConfiguration configuration, ApplicationContext context) {
        PostFilterAuthorizationMethodInterceptor postFilter = new PostFilterAuthorizationMethodInterceptor();
        postFilter.setOrder(postFilter.getOrder() + configuration.interceptorOrderOffset);
        return new DeferringMethodInterceptor<PostFilterAuthorizationMethodInterceptor>(postFilter, f -> {
            methodSecurityDefaultsProvider.ifAvailable(arg_0 -> ((PostFilterAuthorizationMethodInterceptor)f).setTemplateDefaults(arg_0));
            f.setExpressionHandler((MethodSecurityExpressionHandler)expressionHandlerProvider.getIfAvailable(() -> PrePostMethodSecurityConfiguration.defaultExpressionHandler(defaultsProvider, roleHierarchyProvider, context)));
            strategyProvider.ifAvailable(arg_0 -> ((PostFilterAuthorizationMethodInterceptor)f).setSecurityContextHolderStrategy(arg_0));
        });
    }

    private static MethodSecurityExpressionHandler defaultExpressionHandler(ObjectProvider<GrantedAuthorityDefaults> defaultsProvider, ObjectProvider<RoleHierarchy> roleHierarchyProvider, ApplicationContext context) {
        DefaultMethodSecurityExpressionHandler handler = new DefaultMethodSecurityExpressionHandler();
        RoleHierarchy roleHierarchy = (RoleHierarchy)roleHierarchyProvider.getIfAvailable(NullRoleHierarchy::new);
        handler.setRoleHierarchy(roleHierarchy);
        defaultsProvider.ifAvailable(d -> handler.setDefaultRolePrefix(d.getRolePrefix()));
        handler.setApplicationContext(context);
        return handler;
    }

    static <T> AuthorizationManager<T> manager(AuthorizationManager<T> delegate, ObjectProvider<ObservationRegistry> registryProvider) {
        return new DeferringObservationAuthorizationManager<T>(registryProvider, delegate);
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        EnableMethodSecurity annotation = (EnableMethodSecurity)importMetadata.getAnnotations().get(EnableMethodSecurity.class).synthesize();
        this.interceptorOrderOffset = annotation.offset();
    }

    private static final class DeferringMethodInterceptor<M extends AuthorizationAdvisor>
    implements AuthorizationAdvisor {
        private final Pointcut pointcut;
        private final int order;
        private final Supplier<M> delegate;

        DeferringMethodInterceptor(M delegate, Consumer<M> supplier) {
            this.pointcut = delegate.getPointcut();
            this.order = delegate.getOrder();
            this.delegate = SingletonSupplier.of(() -> {
                supplier.accept(delegate);
                return delegate;
            });
        }

        @Nullable
        public Object invoke(@NotNull MethodInvocation invocation) throws Throwable {
            return ((AuthorizationAdvisor)this.delegate.get()).invoke(invocation);
        }

        public Pointcut getPointcut() {
            return this.pointcut;
        }

        public Advice getAdvice() {
            return this;
        }

        public int getOrder() {
            return this.order;
        }

        public boolean isPerInstance() {
            return true;
        }
    }
}

