/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.security.config.annotation.SecurityConfigurer;
import org.springframework.security.config.annotation.web.WebSecurityConfigurer;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.util.Assert;

final class AutowiredWebSecurityConfigurersIgnoreParents {
    private final ConfigurableListableBeanFactory beanFactory;

    public AutowiredWebSecurityConfigurersIgnoreParents(ConfigurableListableBeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"beanFactory cannot be null");
        this.beanFactory = beanFactory;
    }

    public List<SecurityConfigurer<Filter, WebSecurity>> getWebSecurityConfigurers() {
        ArrayList<SecurityConfigurer<Filter, WebSecurity>> webSecurityConfigurers = new ArrayList<SecurityConfigurer<Filter, WebSecurity>>();
        Map beansOfType = this.beanFactory.getBeansOfType(WebSecurityConfigurer.class);
        for (Map.Entry entry : beansOfType.entrySet()) {
            webSecurityConfigurers.add((SecurityConfigurer<Filter, WebSecurity>)entry.getValue());
        }
        return webSecurityConfigurers;
    }
}

