/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.context.ApplicationContext;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractConfigAttributeRequestMatcherRegistry;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.web.PortMapper;
import org.springframework.security.web.access.channel.ChannelDecisionManager;
import org.springframework.security.web.access.channel.ChannelDecisionManagerImpl;
import org.springframework.security.web.access.channel.ChannelEntryPoint;
import org.springframework.security.web.access.channel.ChannelProcessingFilter;
import org.springframework.security.web.access.channel.ChannelProcessor;
import org.springframework.security.web.access.channel.InsecureChannelProcessor;
import org.springframework.security.web.access.channel.RetryWithHttpEntryPoint;
import org.springframework.security.web.access.channel.RetryWithHttpsEntryPoint;
import org.springframework.security.web.access.channel.SecureChannelProcessor;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.util.matcher.RequestMatcher;

public final class ChannelSecurityConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<ChannelSecurityConfigurer<H>, H> {
    private ChannelProcessingFilter channelFilter = new ChannelProcessingFilter();
    private LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> requestMap = new LinkedHashMap();
    private List<ChannelProcessor> channelProcessors;
    private final ChannelRequestMatcherRegistry REGISTRY;

    public ChannelSecurityConfigurer(ApplicationContext context) {
        this.REGISTRY = new ChannelRequestMatcherRegistry(context);
    }

    public ChannelRequestMatcherRegistry getRegistry() {
        return this.REGISTRY;
    }

    @Override
    public void configure(H http) throws Exception {
        ChannelDecisionManagerImpl channelDecisionManager = new ChannelDecisionManagerImpl();
        channelDecisionManager.setChannelProcessors(this.getChannelProcessors(http));
        channelDecisionManager = this.postProcess(channelDecisionManager);
        this.channelFilter.setChannelDecisionManager((ChannelDecisionManager)channelDecisionManager);
        DefaultFilterInvocationSecurityMetadataSource filterInvocationSecurityMetadataSource = new DefaultFilterInvocationSecurityMetadataSource(this.requestMap);
        this.channelFilter.setSecurityMetadataSource((FilterInvocationSecurityMetadataSource)filterInvocationSecurityMetadataSource);
        this.channelFilter = this.postProcess(this.channelFilter);
        http.addFilter((Filter)this.channelFilter);
    }

    private List<ChannelProcessor> getChannelProcessors(H http) {
        if (this.channelProcessors != null) {
            return this.channelProcessors;
        }
        InsecureChannelProcessor insecureChannelProcessor = new InsecureChannelProcessor();
        SecureChannelProcessor secureChannelProcessor = new SecureChannelProcessor();
        PortMapper portMapper = http.getSharedObject(PortMapper.class);
        if (portMapper != null) {
            RetryWithHttpEntryPoint httpEntryPoint = new RetryWithHttpEntryPoint();
            httpEntryPoint.setPortMapper(portMapper);
            insecureChannelProcessor.setEntryPoint((ChannelEntryPoint)httpEntryPoint);
            RetryWithHttpsEntryPoint httpsEntryPoint = new RetryWithHttpsEntryPoint();
            httpsEntryPoint.setPortMapper(portMapper);
            secureChannelProcessor.setEntryPoint((ChannelEntryPoint)httpsEntryPoint);
        }
        insecureChannelProcessor = this.postProcess(insecureChannelProcessor);
        secureChannelProcessor = this.postProcess(secureChannelProcessor);
        return Arrays.asList(insecureChannelProcessor, secureChannelProcessor);
    }

    private ChannelRequestMatcherRegistry addAttribute(String attribute, List<RequestMatcher> matchers) {
        for (RequestMatcher matcher : matchers) {
            List<ConfigAttribute> attrs = Arrays.asList(new SecurityConfig(attribute));
            this.requestMap.put(matcher, attrs);
        }
        return this.REGISTRY;
    }

    public final class RequiresChannelUrl {
        private List<RequestMatcher> requestMatchers;

        private RequiresChannelUrl(List<RequestMatcher> requestMatchers) {
            this.requestMatchers = requestMatchers;
        }

        public ChannelRequestMatcherRegistry requiresSecure() {
            return this.requires("REQUIRES_SECURE_CHANNEL");
        }

        public ChannelRequestMatcherRegistry requiresInsecure() {
            return this.requires("REQUIRES_INSECURE_CHANNEL");
        }

        public ChannelRequestMatcherRegistry requires(String attribute) {
            return ChannelSecurityConfigurer.this.addAttribute(attribute, this.requestMatchers);
        }
    }

    public final class ChannelRequestMatcherRegistry
    extends AbstractConfigAttributeRequestMatcherRegistry<RequiresChannelUrl> {
        private ChannelRequestMatcherRegistry(ApplicationContext context) {
            this.setApplicationContext(context);
        }

        @Override
        protected RequiresChannelUrl chainRequestMatchersInternal(List<RequestMatcher> requestMatchers) {
            return new RequiresChannelUrl(requestMatchers);
        }

        public ChannelRequestMatcherRegistry withObjectPostProcessor(ObjectPostProcessor<?> objectPostProcessor) {
            ChannelSecurityConfigurer.this.addObjectPostProcessor(objectPostProcessor);
            return this;
        }

        public ChannelRequestMatcherRegistry channelProcessors(List<ChannelProcessor> channelProcessors) {
            ChannelSecurityConfigurer.this.channelProcessors = channelProcessors;
            return this;
        }

        public H and() {
            return (HttpSecurityBuilder)ChannelSecurityConfigurer.this.and();
        }
    }
}

