/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.authentication.configurers.userdetails;

import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.authentication.ProviderManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.userdetails.UserDetailsAwareConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractDaoAuthenticationConfigurer<B extends ProviderManagerBuilder<B>, C extends AbstractDaoAuthenticationConfigurer<B, C, U>, U extends UserDetailsService>
extends UserDetailsAwareConfigurer<B, U> {
    private DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
    private final U userDetailsService;

    protected AbstractDaoAuthenticationConfigurer(U userDetailsService) {
        this.userDetailsService = userDetailsService;
        this.provider.setUserDetailsService(userDetailsService);
    }

    public C withObjectPostProcessor(ObjectPostProcessor<?> objectPostProcessor) {
        this.addObjectPostProcessor(objectPostProcessor);
        return (C)this;
    }

    public C passwordEncoder(PasswordEncoder passwordEncoder) {
        this.provider.setPasswordEncoder((Object)passwordEncoder);
        return (C)this;
    }

    public C passwordEncoder(org.springframework.security.authentication.encoding.PasswordEncoder passwordEncoder) {
        this.provider.setPasswordEncoder((Object)passwordEncoder);
        return (C)this;
    }

    @Override
    public void configure(B builder) throws Exception {
        this.provider = this.postProcess(this.provider);
        builder.authenticationProvider((AuthenticationProvider)this.provider);
    }

    @Override
    public U getUserDetailsService() {
        return this.userDetailsService;
    }
}

