/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.listener.BatchErrorHandler;

public class BatchLoggingErrorHandler
implements BatchErrorHandler {
    private static final LogAccessor LOGGER = new LogAccessor(LogFactory.getLog(BatchLoggingErrorHandler.class));

    @Override
    public void handle(Exception thrownException, ConsumerRecords<?, ?> data) {
        StringBuilder message = new StringBuilder("Error while processing:\n");
        if (data == null) {
            message.append("null ");
        } else {
            for (ConsumerRecord record : data) {
                message.append(record).append('\n');
            }
        }
        LOGGER.error((Throwable)thrownException, () -> message.substring(0, message.length() - 1));
    }
}

