/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiPredicate;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.listener.ListenerUtils;
import org.springframework.util.backoff.FixedBackOff;

public final class SeekUtils {
    public static final int DEFAULT_MAX_FAILURES = 10;
    public static final FixedBackOff DEFAULT_BACK_OFF = new FixedBackOff(0L, 9L);

    private SeekUtils() {
    }

    public static boolean doSeeks(List<ConsumerRecord<?, ?>> records, Consumer<?, ?> consumer, Exception exception, boolean recoverable, BiPredicate<ConsumerRecord<?, ?>, Exception> skipper, LogAccessor logger) {
        LinkedHashMap<TopicPartition, Long> partitions = new LinkedHashMap<TopicPartition, Long>();
        AtomicBoolean first = new AtomicBoolean(true);
        AtomicBoolean skipped = new AtomicBoolean();
        records.forEach(record -> {
            if (recoverable && first.get()) {
                try {
                    boolean test = skipper.test((ConsumerRecord<?, ?>)record, exception);
                    skipped.set(test);
                }
                catch (Exception ex) {
                    logger.error((Throwable)ex, (CharSequence)("Failed to determine if this record (" + ListenerUtils.recordToString(record) + ") should be recovererd, including in seeks"));
                    skipped.set(false);
                }
                if (skipped.get()) {
                    logger.debug(() -> "Skipping seek of: " + ListenerUtils.recordToString(record));
                }
            }
            if (!(recoverable && first.get() && skipped.get())) {
                partitions.computeIfAbsent(new TopicPartition(record.topic(), record.partition()), offset -> record.offset());
            }
            first.set(false);
        });
        partitions.forEach((topicPartition, offset) -> {
            try {
                logger.trace(() -> "Seeking: " + topicPartition + " to: " + offset);
                consumer.seek(topicPartition, offset.longValue());
            }
            catch (Exception e) {
                logger.error((Throwable)e, () -> "Failed to seek " + topicPartition + " to " + offset);
            }
        });
        return skipped.get();
    }
}

