/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.event.ContainerStoppedEvent;
import org.springframework.kafka.listener.AfterRollbackProcessor;
import org.springframework.kafka.listener.BatchErrorHandler;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.DefaultAfterRollbackProcessor;
import org.springframework.kafka.listener.ErrorHandler;
import org.springframework.kafka.listener.GenericErrorHandler;
import org.springframework.kafka.listener.GenericMessageListener;
import org.springframework.kafka.listener.GenericMessageListenerContainer;
import org.springframework.kafka.listener.RecordInterceptor;
import org.springframework.kafka.support.TopicPartitionOffset;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractMessageListenerContainer<K, V>
implements GenericMessageListenerContainer<K, V>,
BeanNameAware,
ApplicationEventPublisherAware,
ApplicationContextAware {
    public static final int DEFAULT_PHASE = 2147483547;
    private static final int DEFAULT_TOPIC_CHECK_TIMEOUT = 30;
    protected final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    protected final ConsumerFactory<K, V> consumerFactory;
    private final ContainerProperties containerProperties;
    protected final Object lifecycleMonitor = new Object();
    private String beanName;
    private ApplicationEventPublisher applicationEventPublisher;
    private GenericErrorHandler<?> errorHandler;
    private boolean autoStartup = true;
    private int phase = 2147483547;
    private AfterRollbackProcessor<? super K, ? super V> afterRollbackProcessor = new DefaultAfterRollbackProcessor<K, V>();
    private int topicCheckTimeout = 30;
    private RecordInterceptor<K, V> recordInterceptor;
    private boolean interceptBeforeTx;
    private volatile boolean running = false;
    private volatile boolean paused;
    private ApplicationContext applicationContext;

    @Deprecated
    protected AbstractMessageListenerContainer(ContainerProperties containerProperties) {
        this(null, containerProperties);
    }

    protected AbstractMessageListenerContainer(ConsumerFactory<? super K, ? super V> consumerFactory, ContainerProperties containerProperties) {
        Assert.notNull((Object)containerProperties, (String)"'containerProperties' cannot be null");
        this.consumerFactory = consumerFactory;
        if (containerProperties.getTopics() != null) {
            this.containerProperties = new ContainerProperties(containerProperties.getTopics());
        } else if (containerProperties.getTopicPattern() != null) {
            this.containerProperties = new ContainerProperties(containerProperties.getTopicPattern());
        } else if (containerProperties.getTopicPartitionsToAssign() != null) {
            this.containerProperties = new ContainerProperties(containerProperties.getTopicPartitionsToAssign());
        } else {
            throw new IllegalStateException("topics, topicPattern, or topicPartitions must be provided");
        }
        BeanUtils.copyProperties((Object)containerProperties, (Object)this.containerProperties, (String[])new String[]{"topics", "topicPartitions", "topicPattern", "ackCount", "ackTime"});
        if (containerProperties.getAckCount() > 0) {
            this.containerProperties.setAckCount(containerProperties.getAckCount());
        }
        if (containerProperties.getAckTime() > 0L) {
            this.containerProperties.setAckTime(containerProperties.getAckTime());
        }
        if (this.containerProperties.getConsumerRebalanceListener() == null) {
            this.containerProperties.setConsumerRebalanceListener(this.createSimpleLoggingConsumerRebalanceListener());
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setGenericErrorHandler(GenericErrorHandler<?> errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setBatchErrorHandler(BatchErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public GenericErrorHandler<?> getGenericErrorHandler() {
        return this.errorHandler;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    @Override
    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    protected void setRunning(boolean running) {
        this.running = running;
    }

    public boolean isRunning() {
        return this.running;
    }

    protected boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean isPauseRequested() {
        return this.paused;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    public AfterRollbackProcessor<? super K, ? super V> getAfterRollbackProcessor() {
        return this.afterRollbackProcessor;
    }

    public void setAfterRollbackProcessor(AfterRollbackProcessor<? super K, ? super V> afterRollbackProcessor) {
        Assert.notNull(afterRollbackProcessor, (String)"'afterRollbackProcessor' cannot be null");
        this.afterRollbackProcessor = afterRollbackProcessor;
    }

    @Override
    public ContainerProperties getContainerProperties() {
        return this.containerProperties;
    }

    @Override
    public String getGroupId() {
        return this.containerProperties.getGroupId() == null ? (String)this.consumerFactory.getConfigurationProperties().get("group.id") : this.containerProperties.getGroupId();
    }

    @Override
    @Nullable
    public String getListenerId() {
        return this.beanName;
    }

    public void setTopicCheckTimeout(int topicCheckTimeout) {
        this.topicCheckTimeout = topicCheckTimeout;
    }

    protected RecordInterceptor<K, V> getRecordInterceptor() {
        return this.recordInterceptor;
    }

    public void setRecordInterceptor(RecordInterceptor<K, V> recordInterceptor) {
        this.recordInterceptor = recordInterceptor;
    }

    protected boolean isInterceptBeforeTx() {
        return this.interceptBeforeTx;
    }

    public void setInterceptBeforeTx(boolean interceptBeforeTx) {
        this.interceptBeforeTx = interceptBeforeTx;
    }

    @Override
    public void setupMessageListener(Object messageListener) {
        this.containerProperties.setMessageListener(messageListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        this.checkGroupId();
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.isRunning()) {
                Assert.state((boolean)(this.containerProperties.getMessageListener() instanceof GenericMessageListener), () -> "A " + GenericMessageListener.class.getName() + " implementation must be provided");
                this.doStart();
            }
        }
    }

    protected void checkTopics() {
        if (this.containerProperties.isMissingTopicsFatal() && this.containerProperties.getTopicPattern() == null) {
            Map<String, Object> configs = this.consumerFactory.getConfigurationProperties().entrySet().stream().filter(entry -> AdminClientConfig.configNames().contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            List missing = null;
            try (AdminClient client = AdminClient.create(configs);){
                if (client != null) {
                    String[] topics = this.containerProperties.getTopics();
                    if (topics == null) {
                        topics = (String[])Arrays.stream(this.containerProperties.getTopicPartitionsToAssign()).map(TopicPartitionOffset::getTopic).toArray(String[]::new);
                    }
                    DescribeTopicsResult result = client.describeTopics(Arrays.asList(topics));
                    missing = result.values().entrySet().stream().filter(entry -> {
                        try {
                            ((KafkaFuture)entry.getValue()).get((long)this.topicCheckTimeout, TimeUnit.SECONDS);
                            return false;
                        }
                        catch (Exception e) {
                            return true;
                        }
                    }).map(Map.Entry::getKey).collect(Collectors.toList());
                }
            }
            catch (Exception e) {
                this.logger.error((Throwable)e, (CharSequence)"Failed to check topic existence");
            }
            if (missing != null && missing.size() > 0) {
                throw new IllegalStateException("Topic(s) " + missing.toString() + " is/are not present and missingTopicsFatal is true");
            }
        }
    }

    public void checkGroupId() {
        if (this.containerProperties.getTopicPartitionsToAssign() == null) {
            boolean hasGroupIdConsumerConfig = true;
            if (this.consumerFactory != null) {
                Object groupIdConfig = this.consumerFactory.getConfigurationProperties().get("group.id");
                hasGroupIdConsumerConfig = groupIdConfig instanceof String && StringUtils.hasText((String)((String)groupIdConfig));
            }
            Assert.state((hasGroupIdConsumerConfig || StringUtils.hasText((String)this.containerProperties.getGroupId()) ? 1 : 0) != 0, (String)"No group.id found in consumer config, container properties, or @KafkaListener annotation; a group.id is required when group management is used.");
        }
    }

    protected abstract void doStart();

    public final void stop() {
        this.stop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(boolean wait) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.isRunning()) {
                if (wait) {
                    CountDownLatch latch = new CountDownLatch(1);
                    this.doStop(latch::countDown);
                    try {
                        latch.await(this.containerProperties.getShutdownTimeout(), TimeUnit.MILLISECONDS);
                        this.publishContainerStoppedEvent();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                } else {
                    this.doStop(() -> this.publishContainerStoppedEvent());
                }
            }
        }
    }

    @Override
    public void pause() {
        this.paused = true;
    }

    @Override
    public void resume() {
        this.paused = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Runnable callback) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.isRunning()) {
                this.doStop(callback);
                this.publishContainerStoppedEvent();
            } else {
                callback.run();
            }
        }
    }

    protected abstract void doStop(Runnable var1);

    protected final ConsumerRebalanceListener createSimpleLoggingConsumerRebalanceListener() {
        return new ConsumerRebalanceListener(){

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                AbstractMessageListenerContainer.this.logger.info(() -> AbstractMessageListenerContainer.this.getGroupId() + ": partitions revoked: " + partitions);
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                AbstractMessageListenerContainer.this.logger.info(() -> AbstractMessageListenerContainer.this.getGroupId() + ": partitions assigned: " + partitions);
            }

            public void onPartitionsLost(Collection<TopicPartition> partitions) {
                AbstractMessageListenerContainer.this.logger.info(() -> AbstractMessageListenerContainer.this.getGroupId() + ": partitions lost: " + partitions);
            }
        };
    }

    protected void publishContainerStoppedEvent() {
        ApplicationEventPublisher eventPublisher = this.getApplicationEventPublisher();
        if (eventPublisher != null) {
            eventPublisher.publishEvent((ApplicationEvent)new ContainerStoppedEvent(this, this.parentOrThis()));
        }
    }

    protected AbstractMessageListenerContainer<?, ?> parentOrThis() {
        return this;
    }
}

