/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.annotation;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.config.KafkaStreamsConfiguration;
import org.springframework.kafka.config.StreamsBuilderFactoryBean;

@Configuration
public class KafkaStreamsDefaultConfiguration {
    public static final String DEFAULT_STREAMS_CONFIG_BEAN_NAME = "defaultKafkaStreamsConfig";
    public static final String DEFAULT_STREAMS_BUILDER_BEAN_NAME = "defaultKafkaStreamsBuilder";

    @Bean(name={"defaultKafkaStreamsBuilder"})
    public StreamsBuilderFactoryBean defaultKafkaStreamsBuilder(@Qualifier(value="defaultKafkaStreamsConfig") ObjectProvider<KafkaStreamsConfiguration> streamsConfigProvider) {
        KafkaStreamsConfiguration streamsConfig = (KafkaStreamsConfiguration)streamsConfigProvider.getIfAvailable();
        if (streamsConfig != null) {
            return new StreamsBuilderFactoryBean(streamsConfig);
        }
        throw new UnsatisfiedDependencyException(KafkaStreamsDefaultConfiguration.class.getName(), DEFAULT_STREAMS_BUILDER_BEAN_NAME, "streamsConfig", "There is no 'defaultKafkaStreamsConfig' Properties bean in the application context.\nConsider declaring one or don't use @EnableKafkaStreams.");
    }
}

