/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.outbound;

import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.ReturnedMessage;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.Expression;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.integration.amqp.support.NackedAmqpMessageException;
import org.springframework.integration.amqp.support.ReturnedAmqpMessageException;
import org.springframework.integration.channel.NullChannel;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.integration.mapping.AbstractHeaderMapper;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.DefaultErrorMessageStrategy;
import org.springframework.integration.support.ErrorMessageStrategy;
import org.springframework.integration.support.management.ManageableLifecycle;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.concurrent.SettableListenableFuture;

public abstract class AbstractAmqpOutboundEndpoint
extends AbstractReplyProducingMessageHandler
implements ManageableLifecycle {
    private static final String NO_ID = new UUID(0L, 0L).toString();
    private String exchangeName;
    private String routingKey;
    private Expression exchangeNameExpression;
    private Expression routingKeyExpression;
    private ExpressionEvaluatingMessageProcessor<String> routingKeyGenerator;
    private ExpressionEvaluatingMessageProcessor<String> exchangeNameGenerator;
    private AmqpHeaderMapper headerMapper = DefaultAmqpHeaderMapper.outboundMapper();
    private Expression confirmCorrelationExpression;
    private ExpressionEvaluatingMessageProcessor<Object> correlationDataGenerator;
    private MessageChannel confirmAckChannel;
    private String confirmAckChannelName;
    private MessageChannel confirmNackChannel;
    private String confirmNackChannelName;
    private MessageChannel returnChannel;
    private MessageDeliveryMode defaultDeliveryMode;
    private boolean lazyConnect = true;
    private ConnectionFactory connectionFactory;
    private Expression delayExpression;
    private ExpressionEvaluatingMessageProcessor<Integer> delayGenerator;
    private boolean headersMappedLast;
    private ErrorMessageStrategy errorMessageStrategy = new DefaultErrorMessageStrategy();
    private Duration confirmTimeout;
    private volatile boolean running;
    private volatile ScheduledFuture<?> confirmChecker;

    public void setHeaderMapper(AmqpHeaderMapper headerMapper) {
        Assert.notNull((Object)headerMapper, (String)"headerMapper must not be null");
        this.headerMapper = headerMapper;
    }

    public void setHeadersMappedLast(boolean headersMappedLast) {
        this.headersMappedLast = headersMappedLast;
    }

    public void setExchangeName(String exchangeName) {
        Assert.notNull((Object)exchangeName, (String)"exchangeName must not be null");
        this.exchangeName = exchangeName;
    }

    public void setExchangeNameExpression(Expression exchangeNameExpression) {
        this.exchangeNameExpression = exchangeNameExpression;
    }

    public void setExchangeNameExpressionString(String exchangeNameExpression) {
        Assert.hasText((String)exchangeNameExpression, (String)"'exchangeNameExpression' must not be empty");
        this.exchangeNameExpression = EXPRESSION_PARSER.parseExpression(exchangeNameExpression);
    }

    public void setRoutingKey(String routingKey) {
        Assert.notNull((Object)routingKey, (String)"routingKey must not be null");
        this.routingKey = routingKey;
    }

    public void setRoutingKeyExpression(Expression routingKeyExpression) {
        this.routingKeyExpression = routingKeyExpression;
    }

    public void setRoutingKeyExpressionString(String routingKeyExpression) {
        Assert.hasText((String)routingKeyExpression, (String)"'routingKeyExpression' must not be empty");
        this.routingKeyExpression = EXPRESSION_PARSER.parseExpression(routingKeyExpression);
    }

    public void setConfirmCorrelationExpression(Expression confirmCorrelationExpression) {
        this.confirmCorrelationExpression = confirmCorrelationExpression;
    }

    public void setConfirmCorrelationExpressionString(String confirmCorrelationExpression) {
        Assert.hasText((String)confirmCorrelationExpression, (String)"'confirmCorrelationExpression' must not be empty");
        this.confirmCorrelationExpression = EXPRESSION_PARSER.parseExpression(confirmCorrelationExpression);
    }

    public void setConfirmAckChannel(MessageChannel ackChannel) {
        this.confirmAckChannel = ackChannel;
    }

    public void setConfirmAckChannelName(String ackChannelName) {
        this.confirmAckChannelName = ackChannelName;
    }

    public void setConfirmNackChannel(MessageChannel nackChannel) {
        this.confirmNackChannel = nackChannel;
    }

    public void setConfirmNackChannelName(String nackChannelName) {
        this.confirmNackChannelName = nackChannelName;
    }

    public void setReturnChannel(MessageChannel returnChannel) {
        this.returnChannel = returnChannel;
    }

    public void setDefaultDeliveryMode(MessageDeliveryMode defaultDeliveryMode) {
        this.defaultDeliveryMode = defaultDeliveryMode;
    }

    public void setLazyConnect(boolean lazyConnect) {
        this.lazyConnect = lazyConnect;
    }

    public void setDelay(int delay) {
        this.delayExpression = new ValueExpression((Object)delay);
    }

    public void setDelayExpression(Expression delayExpression) {
        this.delayExpression = delayExpression;
    }

    public void setDelayExpressionString(@Nullable String delayExpression) {
        this.delayExpression = delayExpression == null ? null : EXPRESSION_PARSER.parseExpression(delayExpression);
    }

    public void setErrorMessageStrategy(ErrorMessageStrategy errorMessageStrategy) {
        this.errorMessageStrategy = errorMessageStrategy;
    }

    public void setConfirmTimeout(long confirmTimeout) {
        this.confirmTimeout = Duration.ofMillis(confirmTimeout);
    }

    protected final synchronized void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    protected String getExchangeName() {
        return this.exchangeName;
    }

    protected String getRoutingKey() {
        return this.routingKey;
    }

    protected Expression getExchangeNameExpression() {
        return this.exchangeNameExpression;
    }

    protected Expression getRoutingKeyExpression() {
        return this.routingKeyExpression;
    }

    protected ExpressionEvaluatingMessageProcessor<String> getRoutingKeyGenerator() {
        return this.routingKeyGenerator;
    }

    protected ExpressionEvaluatingMessageProcessor<String> getExchangeNameGenerator() {
        return this.exchangeNameGenerator;
    }

    public AmqpHeaderMapper getHeaderMapper() {
        return this.headerMapper;
    }

    protected Expression getConfirmCorrelationExpression() {
        return this.confirmCorrelationExpression;
    }

    protected ExpressionEvaluatingMessageProcessor<Object> getCorrelationDataGenerator() {
        return this.correlationDataGenerator;
    }

    protected MessageChannel getConfirmAckChannel() {
        if (this.confirmAckChannel == null && this.confirmAckChannelName != null) {
            this.confirmAckChannel = (MessageChannel)this.getChannelResolver().resolveDestination(this.confirmAckChannelName);
        }
        return this.confirmAckChannel;
    }

    protected MessageChannel getConfirmNackChannel() {
        if (this.confirmNackChannel == null && this.confirmNackChannelName != null) {
            this.confirmNackChannel = (MessageChannel)this.getChannelResolver().resolveDestination(this.confirmNackChannelName);
        }
        return this.confirmNackChannel;
    }

    protected MessageChannel getReturnChannel() {
        return this.returnChannel;
    }

    protected MessageDeliveryMode getDefaultDeliveryMode() {
        return this.defaultDeliveryMode;
    }

    protected boolean isLazyConnect() {
        return this.lazyConnect;
    }

    protected boolean isHeadersMappedLast() {
        return this.headersMappedLast;
    }

    @Nullable
    protected Duration getConfirmTimeout() {
        return this.confirmTimeout;
    }

    protected final void doInit() {
        BeanFactory beanFactory = this.getBeanFactory();
        this.configureExchangeNameGenerator(beanFactory);
        this.configureRoutingKeyGenerator(beanFactory);
        this.configureCorrelationDataGenerator(beanFactory);
        this.configureDelayGenerator(beanFactory);
        this.endpointInit();
        if (this.headerMapper instanceof AbstractHeaderMapper) {
            ((AbstractHeaderMapper)this.headerMapper).setBeanClassLoader(this.getBeanClassLoader());
        }
    }

    private void configureExchangeNameGenerator(BeanFactory beanFactory) {
        Assert.state((this.exchangeNameExpression == null || this.exchangeName == null ? 1 : 0) != 0, (String)"Either an exchangeName or an exchangeNameExpression can be provided, but not both");
        if (this.exchangeNameExpression != null) {
            this.exchangeNameGenerator = new ExpressionEvaluatingMessageProcessor(this.exchangeNameExpression, String.class);
            if (beanFactory != null) {
                this.exchangeNameGenerator.setBeanFactory(beanFactory);
            }
        }
    }

    private void configureRoutingKeyGenerator(BeanFactory beanFactory) {
        Assert.state((this.routingKeyExpression == null || this.routingKey == null ? 1 : 0) != 0, (String)"Either a routingKey or a routingKeyExpression can be provided, but not both");
        if (this.routingKeyExpression != null) {
            this.routingKeyGenerator = new ExpressionEvaluatingMessageProcessor(this.routingKeyExpression, String.class);
            if (beanFactory != null) {
                this.routingKeyGenerator.setBeanFactory(beanFactory);
            }
        }
    }

    private void configureCorrelationDataGenerator(BeanFactory beanFactory) {
        if (this.confirmCorrelationExpression != null) {
            this.correlationDataGenerator = new ExpressionEvaluatingMessageProcessor(this.confirmCorrelationExpression, Object.class);
            if (beanFactory != null) {
                this.correlationDataGenerator.setBeanFactory(beanFactory);
            }
        } else {
            NullChannel nullChannel = (NullChannel)AbstractAmqpOutboundEndpoint.extractTypeIfPossible((Object)this.confirmAckChannel, NullChannel.class);
            Assert.state(((this.confirmAckChannel == null || nullChannel != null) && this.confirmAckChannelName == null ? 1 : 0) != 0, (String)"A 'confirmCorrelationExpression' is required when specifying a 'confirmAckChannel'");
            nullChannel = (NullChannel)AbstractAmqpOutboundEndpoint.extractTypeIfPossible((Object)this.confirmNackChannel, NullChannel.class);
            Assert.state(((this.confirmNackChannel == null || nullChannel != null) && this.confirmNackChannelName == null ? 1 : 0) != 0, (String)"A 'confirmCorrelationExpression' is required when specifying a 'confirmNackChannel'");
        }
    }

    private void configureDelayGenerator(BeanFactory beanFactory) {
        if (this.delayExpression != null) {
            this.delayGenerator = new ExpressionEvaluatingMessageProcessor(this.delayExpression, Integer.class);
            if (beanFactory != null) {
                this.delayGenerator.setBeanFactory(beanFactory);
            }
        }
    }

    protected void endpointInit() {
    }

    public synchronized void start() {
        if (!this.running) {
            if (!this.lazyConnect && this.connectionFactory != null) {
                try {
                    Connection connection = this.connectionFactory.createConnection();
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (RuntimeException ex) {
                    this.logger.error((Throwable)ex, (CharSequence)"Failed to eagerly establish the connection.");
                }
            }
            this.doStart();
            if (this.confirmTimeout != null && this.getConfirmNackChannel() != null && this.getRabbitTemplate() != null) {
                this.confirmChecker = this.getTaskScheduler().scheduleAtFixedRate(this.checkUnconfirmed(), this.confirmTimeout.dividedBy(2L));
            }
            this.running = true;
        }
    }

    private Runnable checkUnconfirmed() {
        return () -> {
            Collection unconfirmed;
            RabbitTemplate rabbitTemplate = this.getRabbitTemplate();
            if (rabbitTemplate != null && (unconfirmed = rabbitTemplate.getUnconfirmed(this.getConfirmTimeout().toMillis())) != null) {
                unconfirmed.forEach(correlation -> this.handleConfirm((CorrelationData)correlation, false, "Confirm timed out"));
            }
        };
    }

    @Nullable
    protected abstract RabbitTemplate getRabbitTemplate();

    public synchronized void stop() {
        if (this.running) {
            this.doStop();
        }
        this.running = false;
        if (this.confirmChecker != null) {
            this.confirmChecker.cancel(false);
            this.confirmChecker = null;
        }
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    public boolean isRunning() {
        return this.running;
    }

    protected CorrelationData generateCorrelationData(Message<?> requestMessage) {
        CorrelationData correlationData = null;
        UUID uuid = requestMessage.getHeaders().getId();
        String messageId = uuid == null ? NO_ID : uuid.toString();
        if (this.correlationDataGenerator != null) {
            Object userData = this.correlationDataGenerator.processMessage(requestMessage);
            if (userData != null) {
                correlationData = new CorrelationDataWrapper(messageId, userData, requestMessage);
            } else {
                this.logger.debug((CharSequence)"'confirmCorrelationExpression' resolved to 'null'; no publisher confirm will be sent to the ack or nack channel");
            }
        }
        if (correlationData == null) {
            Object correlation = requestMessage.getHeaders().get((Object)"amqp_publishConfirmCorrelation");
            if (correlation instanceof CorrelationData) {
                correlationData = (CorrelationData)correlation;
            }
            if (correlationData != null) {
                correlationData = new CorrelationDataWrapper(messageId, correlationData, requestMessage);
            }
        }
        return correlationData;
    }

    protected String generateExchangeName(Message<?> requestMessage) {
        String exchange = this.exchangeName;
        if (this.exchangeNameGenerator != null) {
            exchange = (String)this.exchangeNameGenerator.processMessage(requestMessage);
        }
        return exchange;
    }

    protected String generateRoutingKey(Message<?> requestMessage) {
        String key = this.routingKey;
        if (this.routingKeyGenerator != null) {
            key = (String)this.routingKeyGenerator.processMessage(requestMessage);
        }
        return key;
    }

    protected void addDelayProperty(Message<?> message, org.springframework.amqp.core.Message amqpMessage) {
        if (this.delayGenerator != null) {
            amqpMessage.getMessageProperties().setDelay((Integer)this.delayGenerator.processMessage(message));
        }
    }

    protected AbstractIntegrationMessageBuilder<?> buildReply(MessageConverter converter, org.springframework.amqp.core.Message amqpReplyMessage) {
        Object replyObject = converter.fromMessage(amqpReplyMessage);
        AbstractIntegrationMessageBuilder<?> builder = this.prepareMessageBuilder(replyObject);
        Map headers = this.getHeaderMapper().toHeadersFromReply(amqpReplyMessage.getMessageProperties());
        builder.copyHeadersIfAbsent(headers);
        return builder;
    }

    private AbstractIntegrationMessageBuilder<?> prepareMessageBuilder(Object replyObject) {
        return replyObject instanceof Message ? this.getMessageBuilderFactory().fromMessage((Message)replyObject) : this.getMessageBuilderFactory().withPayload(replyObject);
    }

    @Deprecated
    protected Message<?> buildReturnedMessage(org.springframework.amqp.core.Message message, int replyCode, String replyText, String exchange, String returnedRoutingKey, MessageConverter converter) {
        return this.buildReturnedMessage(new ReturnedMessage(message, replyCode, replyText, exchange, returnedRoutingKey), converter);
    }

    protected Message<?> buildReturnedMessage(ReturnedMessage returnedMessage, MessageConverter converter) {
        org.springframework.amqp.core.Message amqpMessage = returnedMessage.getMessage();
        Object returnedObject = converter.fromMessage(amqpMessage);
        AbstractIntegrationMessageBuilder<?> builder = this.prepareMessageBuilder(returnedObject);
        Map headers = this.getHeaderMapper().toHeadersFromReply(amqpMessage.getMessageProperties());
        if (this.errorMessageStrategy == null) {
            builder.copyHeadersIfAbsent(headers).setHeader("amqp_returnReplyCode", (Object)returnedMessage.getReplyCode()).setHeader("amqp_returnReplyText", (Object)returnedMessage.getReplyText()).setHeader("amqp_returnExchange", (Object)returnedMessage.getExchange()).setHeader("amqp_returnRoutingKey", (Object)returnedMessage.getRoutingKey());
        }
        Message message = builder.build();
        if (this.errorMessageStrategy != null) {
            message = this.errorMessageStrategy.buildErrorMessage((Throwable)((Object)new ReturnedAmqpMessageException(message, amqpMessage, returnedMessage.getReplyCode(), returnedMessage.getReplyText(), returnedMessage.getExchange(), returnedMessage.getRoutingKey())), null);
        }
        return message;
    }

    protected void handleConfirm(CorrelationData correlationData, boolean ack, String cause) {
        CorrelationDataWrapper wrapper = (CorrelationDataWrapper)correlationData;
        if (correlationData == null) {
            this.logger.debug(() -> "No correlation data provided for ack: " + ack + " cause:" + cause);
            return;
        }
        Object userCorrelationData = wrapper.getUserData();
        MessageChannel ackChannel = this.getConfirmAckChannel();
        if (ack && ackChannel != null) {
            this.sendOutput(this.buildConfirmMessage(ack, cause, wrapper, userCorrelationData), ackChannel, true);
        } else {
            MessageChannel nackChannel = this.getConfirmNackChannel();
            if (!ack && nackChannel != null) {
                this.sendOutput(this.buildConfirmMessage(ack, cause, wrapper, userCorrelationData), nackChannel, true);
            } else {
                this.logger.debug(() -> "Nowhere to send publisher confirm " + (ack ? "ack" : "nack") + " for " + userCorrelationData);
            }
        }
    }

    private Message<?> buildConfirmMessage(boolean ack, String cause, CorrelationDataWrapper wrapper, Object userCorrelationData) {
        if (this.errorMessageStrategy == null || ack) {
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put("amqp_publishConfirm", ack);
            if (!ack && StringUtils.hasText((String)cause)) {
                headers.put("amqp_publishConfirmNackCause", cause);
            }
            return this.prepareMessageBuilder(userCorrelationData).copyHeaders(headers).build();
        }
        return this.errorMessageStrategy.buildErrorMessage((Throwable)((Object)new NackedAmqpMessageException(wrapper.getMessage(), wrapper.getUserData(), cause)), null);
    }

    protected static final class CorrelationDataWrapper
    extends CorrelationData {
        private final Object userData;
        private final Message<?> message;

        CorrelationDataWrapper(String id, Object userData, Message<?> message) {
            super(id);
            this.userData = userData;
            this.message = message;
        }

        public Object getUserData() {
            return this.userData;
        }

        public Message<?> getMessage() {
            return this.message;
        }

        public SettableListenableFuture<CorrelationData.Confirm> getFuture() {
            if (this.userData instanceof CorrelationData) {
                return ((CorrelationData)this.userData).getFuture();
            }
            return super.getFuture();
        }

        @Deprecated
        public void setReturnedMessage(org.springframework.amqp.core.Message returnedMessage) {
            if (this.userData instanceof CorrelationData) {
                ((CorrelationData)this.userData).setReturnedMessage(returnedMessage);
            }
            super.setReturnedMessage(returnedMessage);
        }

        public void setReturned(ReturnedMessage returned) {
            if (this.userData instanceof CorrelationData) {
                ((CorrelationData)this.userData).setReturned(returned);
            }
            super.setReturned(returned);
        }
    }
}

