/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.outbound;

import java.util.HashMap;
import java.util.Map;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.Lifecycle;
import org.springframework.expression.Expression;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.integration.channel.NullChannel;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractAmqpOutboundEndpoint
extends AbstractReplyProducingMessageHandler
implements Lifecycle {
    private volatile String exchangeName;
    private volatile String routingKey;
    private volatile Expression exchangeNameExpression;
    private volatile Expression routingKeyExpression;
    private volatile ExpressionEvaluatingMessageProcessor<String> routingKeyGenerator;
    private volatile ExpressionEvaluatingMessageProcessor<String> exchangeNameGenerator;
    private volatile AmqpHeaderMapper headerMapper = DefaultAmqpHeaderMapper.outboundMapper();
    private volatile Expression confirmCorrelationExpression;
    private volatile ExpressionEvaluatingMessageProcessor<Object> correlationDataGenerator;
    private volatile MessageChannel confirmAckChannel;
    private volatile MessageChannel confirmNackChannel;
    private volatile MessageChannel returnChannel;
    private volatile MessageDeliveryMode defaultDeliveryMode;
    private volatile boolean lazyConnect = true;
    private volatile ConnectionFactory connectionFactory;
    private volatile Expression delayExpression;
    private volatile ExpressionEvaluatingMessageProcessor<Integer> delayGenerator;
    private volatile boolean running;

    public void setHeaderMapper(AmqpHeaderMapper headerMapper) {
        Assert.notNull((Object)headerMapper, (String)"headerMapper must not be null");
        this.headerMapper = headerMapper;
    }

    public void setExchangeName(String exchangeName) {
        Assert.notNull((Object)exchangeName, (String)"exchangeName must not be null");
        this.exchangeName = exchangeName;
    }

    public void setExchangeNameExpression(Expression exchangeNameExpression) {
        this.exchangeNameExpression = exchangeNameExpression;
    }

    public void setExchangeNameExpressionString(String exchangeNameExpression) {
        Assert.hasText((String)exchangeNameExpression, (String)"'exchangeNameExpression' must not be empty");
        this.exchangeNameExpression = EXPRESSION_PARSER.parseExpression(exchangeNameExpression);
    }

    public void setRoutingKey(String routingKey) {
        Assert.notNull((Object)routingKey, (String)"routingKey must not be null");
        this.routingKey = routingKey;
    }

    public void setRoutingKeyExpression(Expression routingKeyExpression) {
        this.routingKeyExpression = routingKeyExpression;
    }

    public void setRoutingKeyExpressionString(String routingKeyExpression) {
        Assert.hasText((String)routingKeyExpression, (String)"'routingKeyExpression' must not be empty");
        this.routingKeyExpression = EXPRESSION_PARSER.parseExpression(routingKeyExpression);
    }

    public void setConfirmCorrelationExpression(Expression confirmCorrelationExpression) {
        this.confirmCorrelationExpression = confirmCorrelationExpression;
    }

    public void setConfirmCorrelationExpressionString(String confirmCorrelationExpression) {
        Assert.hasText((String)confirmCorrelationExpression, (String)"'confirmCorrelationExpression' must not be empty");
        this.confirmCorrelationExpression = EXPRESSION_PARSER.parseExpression(confirmCorrelationExpression);
    }

    public void setConfirmAckChannel(MessageChannel ackChannel) {
        this.confirmAckChannel = ackChannel;
    }

    public void setConfirmNackChannel(MessageChannel nackChannel) {
        this.confirmNackChannel = nackChannel;
    }

    public void setReturnChannel(MessageChannel returnChannel) {
        this.returnChannel = returnChannel;
    }

    public void setDefaultDeliveryMode(MessageDeliveryMode defaultDeliveryMode) {
        this.defaultDeliveryMode = defaultDeliveryMode;
    }

    public void setLazyConnect(boolean lazyConnect) {
        this.lazyConnect = lazyConnect;
    }

    public void setDelay(int delay) {
        this.delayExpression = new ValueExpression((Object)delay);
    }

    public void setDelayExpression(Expression delayExpression) {
        this.delayExpression = delayExpression;
    }

    public void setDelayExpressionString(String delayExpression) {
        this.delayExpression = delayExpression == null ? null : EXPRESSION_PARSER.parseExpression(delayExpression);
    }

    protected final void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    protected String getExchangeName() {
        return this.exchangeName;
    }

    protected String getRoutingKey() {
        return this.routingKey;
    }

    protected Expression getExchangeNameExpression() {
        return this.exchangeNameExpression;
    }

    protected Expression getRoutingKeyExpression() {
        return this.routingKeyExpression;
    }

    protected ExpressionEvaluatingMessageProcessor<String> getRoutingKeyGenerator() {
        return this.routingKeyGenerator;
    }

    protected ExpressionEvaluatingMessageProcessor<String> getExchangeNameGenerator() {
        return this.exchangeNameGenerator;
    }

    protected AmqpHeaderMapper getHeaderMapper() {
        return this.headerMapper;
    }

    protected Expression getConfirmCorrelationExpression() {
        return this.confirmCorrelationExpression;
    }

    protected ExpressionEvaluatingMessageProcessor<Object> getCorrelationDataGenerator() {
        return this.correlationDataGenerator;
    }

    protected MessageChannel getConfirmAckChannel() {
        return this.confirmAckChannel;
    }

    protected MessageChannel getConfirmNackChannel() {
        return this.confirmNackChannel;
    }

    protected MessageChannel getReturnChannel() {
        return this.returnChannel;
    }

    protected MessageDeliveryMode getDefaultDeliveryMode() {
        return this.defaultDeliveryMode;
    }

    protected boolean isLazyConnect() {
        return this.lazyConnect;
    }

    protected final void doInit() {
        Assert.state((this.exchangeNameExpression == null || this.exchangeName == null ? 1 : 0) != 0, (String)"Either an exchangeName or an exchangeNameExpression can be provided, but not both");
        BeanFactory beanFactory = this.getBeanFactory();
        if (this.exchangeNameExpression != null) {
            this.exchangeNameGenerator = new ExpressionEvaluatingMessageProcessor(this.exchangeNameExpression, String.class);
            if (beanFactory != null) {
                this.exchangeNameGenerator.setBeanFactory(beanFactory);
            }
        }
        Assert.state((this.routingKeyExpression == null || this.routingKey == null ? 1 : 0) != 0, (String)"Either a routingKey or a routingKeyExpression can be provided, but not both");
        if (this.routingKeyExpression != null) {
            this.routingKeyGenerator = new ExpressionEvaluatingMessageProcessor(this.routingKeyExpression, String.class);
            if (beanFactory != null) {
                this.routingKeyGenerator.setBeanFactory(beanFactory);
            }
        }
        if (this.confirmCorrelationExpression != null) {
            this.correlationDataGenerator = new ExpressionEvaluatingMessageProcessor(this.confirmCorrelationExpression, Object.class);
            if (beanFactory != null) {
                this.correlationDataGenerator.setBeanFactory(beanFactory);
            }
        } else {
            NullChannel nullChannel = (NullChannel)this.extractTypeIfPossible(this.confirmAckChannel, NullChannel.class);
            Assert.state((this.confirmAckChannel == null || nullChannel != null ? 1 : 0) != 0, (String)"A 'confirmCorrelationExpression' is required when specifying a 'confirmAckChannel'");
            nullChannel = (NullChannel)this.extractTypeIfPossible(this.confirmNackChannel, NullChannel.class);
            Assert.state((this.confirmNackChannel == null || nullChannel != null ? 1 : 0) != 0, (String)"A 'confirmCorrelationExpression' is required when specifying a 'confirmNackChannel'");
        }
        if (this.delayExpression != null) {
            this.delayGenerator = new ExpressionEvaluatingMessageProcessor(this.delayExpression, Integer.class);
            if (beanFactory != null) {
                this.delayGenerator.setBeanFactory(beanFactory);
            }
        }
        this.endpointInit();
    }

    protected void endpointInit() {
    }

    public synchronized void start() {
        if (!this.running) {
            if (!this.lazyConnect && this.connectionFactory != null) {
                try {
                    Connection connection = this.connectionFactory.createConnection();
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (RuntimeException e) {
                    this.logger.error((Object)"Failed to eagerly establish the connection.", (Throwable)e);
                }
            }
            this.doStart();
            this.running = true;
        }
    }

    public synchronized void stop() {
        if (this.running) {
            this.doStop();
        }
        this.running = false;
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    public boolean isRunning() {
        return this.running;
    }

    protected CorrelationData generateCorrelationData(Message<?> requestMessage) {
        Object userCorrelationData;
        Object correlationData = null;
        if (this.correlationDataGenerator != null && (userCorrelationData = this.correlationDataGenerator.processMessage(requestMessage)) != null) {
            correlationData = userCorrelationData instanceof CorrelationData ? (CorrelationData)userCorrelationData : new CorrelationDataWrapper(requestMessage.getHeaders().getId().toString(), userCorrelationData);
        }
        return correlationData;
    }

    protected String generateExchangeName(Message<?> requestMessage) {
        String exchangeName = this.exchangeName;
        if (this.exchangeNameGenerator != null) {
            exchangeName = (String)this.exchangeNameGenerator.processMessage(requestMessage);
        }
        return exchangeName;
    }

    protected String generateRoutingKey(Message<?> requestMessage) {
        String routingKey = this.routingKey;
        if (this.routingKeyGenerator != null) {
            routingKey = (String)this.routingKeyGenerator.processMessage(requestMessage);
        }
        return routingKey;
    }

    protected void addDelayProperty(Message<?> message, org.springframework.amqp.core.Message amqpMessage) {
        if (this.delayGenerator != null) {
            amqpMessage.getMessageProperties().setDelay((Integer)this.delayGenerator.processMessage(message));
        }
    }

    protected Message<?> buildReplyMessage(MessageConverter converter, org.springframework.amqp.core.Message amqpReplyMessage) {
        Object replyObject = converter.fromMessage(amqpReplyMessage);
        AbstractIntegrationMessageBuilder builder = replyObject instanceof Message ? this.getMessageBuilderFactory().fromMessage((Message)replyObject) : this.getMessageBuilderFactory().withPayload(replyObject);
        Map headers = this.getHeaderMapper().toHeadersFromReply(amqpReplyMessage.getMessageProperties());
        builder.copyHeadersIfAbsent(headers);
        return builder.build();
    }

    protected Message<?> buildReturnedMessage(org.springframework.amqp.core.Message message, int replyCode, String replyText, String exchange, String routingKey, MessageConverter converter) {
        Object returnedObject = converter.fromMessage(message);
        AbstractIntegrationMessageBuilder builder = returnedObject instanceof Message ? this.getMessageBuilderFactory().fromMessage((Message)returnedObject) : this.getMessageBuilderFactory().withPayload(returnedObject);
        Map headers = this.getHeaderMapper().toHeadersFromReply(message.getMessageProperties());
        builder.copyHeadersIfAbsent(headers).setHeader("amqp_returnReplyCode", (Object)replyCode).setHeader("amqp_returnReplyText", (Object)replyText).setHeader("amqp_returnExchange", (Object)exchange).setHeader("amqp_returnRoutingKey", (Object)routingKey);
        return builder.build();
    }

    protected void handleConfirm(CorrelationData correlationData, boolean ack, String cause) {
        Object userCorrelationData = correlationData;
        if (correlationData == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No correlation data provided for ack: " + ack + " cause:" + cause));
            }
            return;
        }
        if (correlationData instanceof CorrelationDataWrapper) {
            userCorrelationData = ((CorrelationDataWrapper)correlationData).getUserData();
        }
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("amqp_publishConfirm", ack);
        if (!ack && StringUtils.hasText((String)cause)) {
            headers.put("amqp_publishConfirmNackCause", cause);
        }
        AbstractIntegrationMessageBuilder builder = userCorrelationData instanceof Message ? this.getMessageBuilderFactory().fromMessage((Message)userCorrelationData) : this.getMessageBuilderFactory().withPayload(userCorrelationData);
        Message confirmMessage = builder.copyHeaders(headers).build();
        if (ack && this.confirmAckChannel != null) {
            this.sendOutput(confirmMessage, this.confirmAckChannel, true);
        } else if (!ack && this.confirmNackChannel != null) {
            this.sendOutput(confirmMessage, this.confirmNackChannel, true);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Nowhere to send publisher confirm " + (ack ? "ack" : "nack") + " for " + userCorrelationData));
        }
    }

    protected static final class CorrelationDataWrapper
    extends CorrelationData {
        private final Object userData;

        private CorrelationDataWrapper(String id, Object userData) {
            super(id);
            this.userData = userData;
        }

        public Object getUserData() {
            return this.userData;
        }
    }
}

