/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.query;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.solr.VersionUtil;
import org.springframework.data.solr.core.SolrOperations;
import org.springframework.data.solr.core.SolrTransactionSynchronizationAdapterBuilder;
import org.springframework.data.solr.core.convert.DateTimeConverters;
import org.springframework.data.solr.core.convert.NumberConverters;
import org.springframework.data.solr.core.geo.GeoConverters;
import org.springframework.data.solr.core.query.FacetAndHighlightQuery;
import org.springframework.data.solr.core.query.FacetOptions;
import org.springframework.data.solr.core.query.FacetQuery;
import org.springframework.data.solr.core.query.HighlightOptions;
import org.springframework.data.solr.core.query.HighlightQuery;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.SimpleFacetAndHighlightQuery;
import org.springframework.data.solr.core.query.SimpleFacetQuery;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.data.solr.core.query.SimpleHighlightQuery;
import org.springframework.data.solr.core.query.SimpleQuery;
import org.springframework.data.solr.core.query.SimpleStringCriteria;
import org.springframework.data.solr.core.query.SolrPageRequest;
import org.springframework.data.solr.core.query.StatsOptions;
import org.springframework.data.solr.core.query.result.FacetAndHighlightPage;
import org.springframework.data.solr.core.query.result.FacetPage;
import org.springframework.data.solr.core.query.result.HighlightPage;
import org.springframework.data.solr.repository.query.SolrParameterAccessor;
import org.springframework.data.solr.repository.query.SolrParametersParameterAccessor;
import org.springframework.data.solr.repository.query.SolrQueryMethod;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractSolrQuery
implements RepositoryQuery {
    private static final Pattern PARAMETER_PLACEHOLDER = Pattern.compile("\\?(\\d+)");
    private final SolrOperations solrOperations;
    private final SolrQueryMethod solrQueryMethod;
    private final String collection;
    public final int UNLIMITED = 1;
    private final GenericConversionService conversionService = new GenericConversionService();

    protected AbstractSolrQuery(@Nullable String collection, SolrOperations solrOperations, SolrQueryMethod solrQueryMethod) {
        if (!this.conversionService.canConvert(Date.class, String.class)) {
            this.conversionService.addConverter((Converter)DateTimeConverters.JavaDateConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(Number.class, String.class)) {
            this.conversionService.addConverter((Converter)NumberConverters.NumberConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(Point.class, String.class)) {
            this.conversionService.addConverter((Converter)GeoConverters.Point3DToStringConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(Distance.class, String.class)) {
            this.conversionService.addConverter((Converter)GeoConverters.DistanceToStringConverter.INSTANCE);
        }
        if (VersionUtil.isJodaTimeAvailable()) {
            if (!this.conversionService.canConvert(ReadableInstant.class, String.class)) {
                this.conversionService.addConverter((Converter)DateTimeConverters.JodaDateTimeConverter.INSTANCE);
            }
            if (!this.conversionService.canConvert(LocalDateTime.class, String.class)) {
                this.conversionService.addConverter((Converter)DateTimeConverters.JodaLocalDateTimeConverter.INSTANCE);
            }
        }
        Assert.notNull((Object)solrOperations, (String)"SolrOperations must not be null!");
        Assert.notNull((Object)((Object)solrQueryMethod), (String)"SolrQueryMethod must not be null!");
        this.solrOperations = solrOperations;
        this.solrQueryMethod = solrQueryMethod;
        this.collection = collection;
    }

    public Object execute(Object[] parameters) {
        SolrParametersParameterAccessor accessor = new SolrParametersParameterAccessor(this.solrQueryMethod, parameters);
        Query query = this.createQuery(accessor);
        this.decorateWithFilterQuery(query, accessor);
        this.setDefaultQueryOperatorIfDefined(query);
        this.setAllowedQueryExeutionTime(query);
        this.setDefTypeIfDefined(query);
        this.setRequestHandlerIfDefined(query);
        this.setSpellecheckOptionsWhenDefined(query);
        if (this.solrQueryMethod.hasStatsDefinition()) {
            query.setStatsOptions(this.extractStatsOptions(this.solrQueryMethod, accessor));
        }
        if (this.isCountQuery() && this.isDeleteQuery()) {
            throw new InvalidDataAccessApiUsageException("Cannot execute 'delete' and 'count' at the same time.");
        }
        if (this.isCountQuery()) {
            return new CountExecution().execute(query);
        }
        if (this.isDeleteQuery()) {
            return new DeleteExecution().execute(query);
        }
        if (this.solrQueryMethod.isPageQuery() || this.solrQueryMethod.isSliceQuery()) {
            if (this.solrQueryMethod.isFacetQuery() && this.solrQueryMethod.isHighlightQuery()) {
                FacetAndHighlightQuery facetAndHighlightQuery = SimpleFacetAndHighlightQuery.fromQuery(query, new SimpleFacetAndHighlightQuery());
                facetAndHighlightQuery.setFacetOptions(this.extractFacetOptions(this.solrQueryMethod, accessor));
                facetAndHighlightQuery.setHighlightOptions(this.extractHighlightOptions(this.solrQueryMethod, accessor));
                return new FacetAndHighlightPageExecution(accessor.getPageable()).execute(facetAndHighlightQuery);
            }
            if (this.solrQueryMethod.isFacetQuery()) {
                FacetQuery facetQuery = SimpleFacetQuery.fromQuery(query, new SimpleFacetQuery());
                facetQuery.setFacetOptions(this.extractFacetOptions(this.solrQueryMethod, accessor));
                return new FacetPageExecution(accessor.getPageable()).execute(facetQuery);
            }
            if (this.solrQueryMethod.isHighlightQuery()) {
                HighlightQuery highlightQuery = SimpleHighlightQuery.fromQuery(query, new SimpleHighlightQuery());
                highlightQuery.setHighlightOptions(this.extractHighlightOptions(this.solrQueryMethod, accessor));
                return new HighlightPageExecution(accessor.getPageable()).execute(highlightQuery);
            }
            return new PagedExecution(accessor.getPageable()).execute(query);
        }
        if (this.solrQueryMethod.isCollectionQuery()) {
            return new CollectionExecution(accessor.getPageable()).execute(query);
        }
        return new SingleEntityExecution().execute(query);
    }

    public SolrQueryMethod getQueryMethod() {
        return this.solrQueryMethod;
    }

    private void setDefaultQueryOperatorIfDefined(Query query) {
        Query.Operator defaultOperator = this.solrQueryMethod.getDefaultOperator();
        if (!Query.Operator.NONE.equals((Object)defaultOperator)) {
            query.setDefaultOperator(defaultOperator);
        }
    }

    private void setAllowedQueryExeutionTime(Query query) {
        Integer timeAllowed = this.solrQueryMethod.getTimeAllowed();
        if (timeAllowed != null) {
            query.setTimeAllowed(timeAllowed);
        }
    }

    private void setDefTypeIfDefined(Query query) {
        String defType = this.solrQueryMethod.getDefType();
        if (StringUtils.hasText((String)defType)) {
            query.setDefType(defType);
        }
    }

    private void setRequestHandlerIfDefined(Query query) {
        String requestHandler = this.solrQueryMethod.getRequestHandler();
        if (StringUtils.hasText((String)requestHandler)) {
            query.setRequestHandler(requestHandler);
        }
    }

    private void setSpellecheckOptionsWhenDefined(Query query) {
        if (this.solrQueryMethod.hasSpellcheck()) {
            query.setSpellcheckOptions(this.solrQueryMethod.getSpellcheckOptions());
        }
    }

    private void decorateWithFilterQuery(Query query, SolrParameterAccessor parameterAccessor) {
        if (this.solrQueryMethod.hasFilterQuery()) {
            for (String filterQuery : this.solrQueryMethod.getFilterQueries()) {
                query.addFilterQuery(this.createQueryFromString(filterQuery, parameterAccessor));
            }
        }
    }

    protected void appendProjection(@Nullable Query query) {
        if (query != null && this.getQueryMethod().hasProjectionFields()) {
            for (String fieldname : this.getQueryMethod().getProjectionFields()) {
                query.addProjectionOnField(new SimpleField(fieldname));
            }
        }
    }

    protected SimpleQuery createQueryFromString(String queryString, SolrParameterAccessor parameterAccessor) {
        String parsedQueryString = this.replacePlaceholders(queryString, parameterAccessor);
        return new SimpleQuery(new SimpleStringCriteria(parsedQueryString));
    }

    private String replacePlaceholders(String input, SolrParameterAccessor accessor) {
        if (!StringUtils.hasText((String)input)) {
            return input;
        }
        Matcher matcher = PARAMETER_PLACEHOLDER.matcher(input);
        String result = input;
        while (matcher.find()) {
            String group = matcher.group();
            int index = Integer.parseInt(matcher.group(1));
            result = result.replace(group, this.getParameterWithIndex(accessor, index));
        }
        return result;
    }

    @Nullable
    private String getParameterWithIndex(SolrParameterAccessor accessor, int index) {
        Object parameter = accessor.getBindableValue(index);
        if (parameter == null) {
            return "null";
        }
        if (this.conversionService.canConvert(parameter.getClass(), String.class)) {
            return (String)this.conversionService.convert(parameter, String.class);
        }
        if (parameter instanceof Collection) {
            StringBuilder sb = new StringBuilder();
            for (Object o : (Collection)parameter) {
                if (this.conversionService.canConvert(o.getClass(), String.class)) {
                    sb.append((String)this.conversionService.convert(o, String.class));
                } else {
                    sb.append(o.toString());
                }
                sb.append(" ");
            }
            return sb.toString().trim();
        }
        return parameter.toString();
    }

    @Nullable
    private StatsOptions extractStatsOptions(SolrQueryMethod queryMethod, SolrParameterAccessor accessor) {
        if (!queryMethod.hasStatsDefinition()) {
            return null;
        }
        StatsOptions options = new StatsOptions();
        for (String fieldName : queryMethod.getFieldStats()) {
            options.addField(fieldName);
        }
        for (String facetFieldName : queryMethod.getStatsFacets()) {
            options.addFacet(facetFieldName);
        }
        options.setCalcDistinct(queryMethod.isFieldStatsCountDistinctEnable());
        Collection<String> selectiveCountDistinct = queryMethod.getStatsSelectiveCountDistinctFields();
        for (Map.Entry<String, String[]> selectiveFacet : queryMethod.getStatsSelectiveFacets().entrySet()) {
            StatsOptions.FieldStatsOptions fieldStatsOptions = options.addField(selectiveFacet.getKey());
            for (String facetFieldName : selectiveFacet.getValue()) {
                fieldStatsOptions.addSelectiveFacet(facetFieldName);
            }
            fieldStatsOptions.setSelectiveCalcDistinct(selectiveCountDistinct.contains(selectiveFacet.getKey()));
        }
        return options;
    }

    private FacetOptions extractFacetOptions(SolrQueryMethod queryMethod, SolrParameterAccessor parameterAccessor) {
        FacetOptions options = new FacetOptions();
        if (queryMethod.hasFacetFields()) {
            options.addFacetOnFlieldnames(queryMethod.getFacetFields());
        }
        if (queryMethod.hasFacetQueries()) {
            for (String queryString : queryMethod.getFacetQueries()) {
                options.addFacetQuery(this.createQueryFromString(queryString, parameterAccessor));
            }
        }
        if (queryMethod.hasPivotFields()) {
            for (String[] pivot : queryMethod.getPivotFields()) {
                options.addFacetOnPivot(pivot);
            }
        }
        options.setFacetLimit(queryMethod.getFacetLimit());
        options.setFacetMinCount(queryMethod.getFacetMinCount());
        options.setFacetPrefix(this.replacePlaceholders(queryMethod.getFacetPrefix(), parameterAccessor));
        return options;
    }

    private HighlightOptions extractHighlightOptions(SolrQueryMethod queryMethod, SolrParameterAccessor accessor) {
        String queryString;
        Integer snipplets;
        Integer fragsize;
        HighlightOptions options = new HighlightOptions();
        if (queryMethod.hasHighlightFields()) {
            options.addFields(queryMethod.getHighlightFieldNames());
        }
        if ((fragsize = queryMethod.getHighlightFragsize()) != null) {
            options.setFragsize(fragsize);
        }
        if ((snipplets = queryMethod.getHighlighSnipplets()) != null) {
            options.setNrSnipplets(snipplets);
        }
        if ((queryString = queryMethod.getHighlightQuery()) != null) {
            options.setQuery(this.createQueryFromString(queryString, accessor));
        }
        this.appendHighlightFormatOptions(options, this.solrQueryMethod);
        return options;
    }

    private void appendHighlightFormatOptions(HighlightOptions options, SolrQueryMethod queryMethod) {
        String highlightPostfix;
        String highlightPrefix;
        String formatter = queryMethod.getHighlightFormatter();
        if (formatter != null) {
            options.setFormatter(formatter);
        }
        if ((highlightPrefix = queryMethod.getHighlightPrefix()) != null) {
            if (this.isSimpleHighlightingOption(formatter)) {
                options.setSimplePrefix(highlightPrefix);
            } else {
                options.addHighlightParameter(new HighlightOptions.HighlightParameter("hl.tag.pre", highlightPrefix));
            }
        }
        if ((highlightPostfix = queryMethod.getHighlightPostfix()) != null) {
            if (this.isSimpleHighlightingOption(formatter)) {
                options.setSimplePostfix(highlightPostfix);
            } else {
                options.addHighlightParameter(new HighlightOptions.HighlightParameter("hl.tag.post", highlightPostfix));
            }
        }
    }

    private boolean isSimpleHighlightingOption(@Nullable String formatter) {
        return formatter == null || "simple".equalsIgnoreCase(formatter);
    }

    protected abstract Query createQuery(SolrParameterAccessor var1);

    public boolean isCountQuery() {
        return false;
    }

    public boolean isDeleteQuery() {
        return this.solrQueryMethod.isDeleteQuery();
    }

    public boolean isLimiting() {
        return false;
    }

    public int getLimit() {
        return 1;
    }

    protected Pageable getLimitingPageable(final @Nullable Pageable source, final int limit) {
        if (source == null) {
            return new SolrPageRequest(0, limit);
        }
        return new PageRequest(source.getPageNumber(), source.getPageSize(), source.getSort()){
            private static final long serialVersionUID = 8100166028148948968L;

            public long getOffset() {
                return source.getOffset();
            }

            public int getPageSize() {
                return limit;
            }
        };
    }

    class DeleteExecution
    implements QueryExecution {
        DeleteExecution() {
        }

        @Override
        public Object execute(Query query) {
            if (TransactionSynchronizationManager.isSynchronizationActive()) {
                SolrTransactionSynchronizationAdapterBuilder.forOperations(AbstractSolrQuery.this.solrOperations).onCollection(AbstractSolrQuery.this.collection).withDefaultBehaviour().register();
            }
            Object result = this.countOrGetDocumentsForDelete(query);
            AbstractSolrQuery.this.solrOperations.delete(AbstractSolrQuery.this.collection, query);
            if (!TransactionSynchronizationManager.isSynchronizationActive()) {
                AbstractSolrQuery.this.solrOperations.commit(AbstractSolrQuery.this.collection);
            }
            return result;
        }

        @Nullable
        private Object countOrGetDocumentsForDelete(Query query) {
            Object result = null;
            if (AbstractSolrQuery.this.solrQueryMethod.isCollectionQuery()) {
                Query clone = SimpleQuery.fromQuery(query);
                result = AbstractSolrQuery.this.solrOperations.queryForPage(AbstractSolrQuery.this.collection, (Query)clone.setPageRequest(new SolrPageRequest(0, Integer.MAX_VALUE)), AbstractSolrQuery.this.solrQueryMethod.getEntityInformation().getJavaType()).getContent();
            }
            if (ClassUtils.isAssignable(Number.class, (Class)AbstractSolrQuery.this.solrQueryMethod.getReturnedObjectType())) {
                result = AbstractSolrQuery.this.solrOperations.count(AbstractSolrQuery.this.collection, query);
            }
            return result;
        }
    }

    class CountExecution
    implements QueryExecution {
        CountExecution() {
        }

        @Override
        public Object execute(Query query) {
            return AbstractSolrQuery.this.solrOperations.count(AbstractSolrQuery.this.collection, query);
        }
    }

    class SingleEntityExecution
    implements QueryExecution {
        SingleEntityExecution() {
        }

        @Override
        public Object execute(Query query) {
            EntityMetadata metadata = AbstractSolrQuery.this.solrQueryMethod.getEntityInformation();
            Optional<Object> result = AbstractSolrQuery.this.solrOperations.queryForObject(AbstractSolrQuery.this.collection, query, metadata.getJavaType());
            return AbstractSolrQuery.this.solrQueryMethod.returnsOptional() ? result : result.orElse(null);
        }
    }

    class FacetAndHighlightPageExecution
    extends PagedExecution {
        public FacetAndHighlightPageExecution(Pageable pageable) {
            super(pageable);
        }

        protected FacetAndHighlightPage<?> executeFind(Query query) {
            Assert.isInstanceOf(FacetAndHighlightQuery.class, (Object)query, (String)"Query must be instance of FacetAndHighlightQuery!");
            EntityMetadata metadata = AbstractSolrQuery.this.solrQueryMethod.getEntityInformation();
            return AbstractSolrQuery.this.solrOperations.queryForFacetAndHighlightPage(AbstractSolrQuery.this.collection, (FacetAndHighlightQuery)query, metadata.getJavaType());
        }
    }

    class HighlightPageExecution
    extends PagedExecution {
        public HighlightPageExecution(Pageable pageable) {
            super(pageable);
        }

        protected HighlightPage<?> executeFind(Query query) {
            Assert.isInstanceOf(HighlightQuery.class, (Object)query, (String)"Query must be instanceof HighlightQuery!");
            EntityMetadata metadata = AbstractSolrQuery.this.solrQueryMethod.getEntityInformation();
            return AbstractSolrQuery.this.solrOperations.queryForHighlightPage(AbstractSolrQuery.this.collection, (HighlightQuery)query, metadata.getJavaType());
        }
    }

    class FacetPageExecution
    extends PagedExecution {
        public FacetPageExecution(Pageable pageable) {
            super(pageable);
        }

        protected FacetPage<?> executeFind(Query query) {
            Assert.isInstanceOf(FacetQuery.class, (Object)query, (String)"Query must be instance of FacetQuery!");
            EntityMetadata metadata = AbstractSolrQuery.this.solrQueryMethod.getEntityInformation();
            return AbstractSolrQuery.this.solrOperations.queryForFacetPage(AbstractSolrQuery.this.collection, (FacetQuery)query, metadata.getJavaType());
        }
    }

    class PagedExecution
    extends AbstractQueryExecution {
        private final Pageable pageable;

        public PagedExecution(Pageable pageable) {
            Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
            this.pageable = pageable;
        }

        @Override
        public Object execute(Query query) {
            Pageable pageToUse = this.getPageable();
            if (AbstractSolrQuery.this.isLimiting()) {
                int limit = AbstractSolrQuery.this.getLimit();
                if (pageToUse == null) {
                    pageToUse = new SolrPageRequest(0, limit);
                }
                if (limit > 0) {
                    if (pageToUse.getOffset() > (long)limit) {
                        return new PageImpl(Collections.emptyList(), pageToUse, (long)limit);
                    }
                    if (pageToUse.getOffset() + (long)pageToUse.getPageSize() > (long)limit) {
                        pageToUse = AbstractSolrQuery.this.getLimitingPageable(pageToUse, limit - (int)pageToUse.getOffset());
                    }
                }
            }
            query.setPageRequest(pageToUse);
            return this.executeFind(query);
        }

        protected Pageable getPageable() {
            return this.pageable;
        }
    }

    class CollectionExecution
    extends AbstractQueryExecution {
        private final Pageable pageable;

        public CollectionExecution(Pageable pageable) {
            this.pageable = pageable;
        }

        @Override
        public Object execute(Query query) {
            if (!AbstractSolrQuery.this.isLimiting()) {
                query.setPageRequest((Pageable)(this.pageable.isPaged() ? this.pageable : new SolrPageRequest(0, (int)this.count(query))));
                return this.executeFind(query).getContent();
            }
            if (this.pageable.isUnpaged() && AbstractSolrQuery.this.isLimiting()) {
                return this.executeFind((Query)query.setPageRequest(new SolrPageRequest(0, AbstractSolrQuery.this.getLimit()))).getContent();
            }
            if (AbstractSolrQuery.this.getLimit() > 0) {
                if (this.pageable.getOffset() > (long)AbstractSolrQuery.this.getLimit()) {
                    return new PageImpl(Collections.emptyList(), this.pageable, (long)AbstractSolrQuery.this.getLimit());
                }
                if (this.pageable.getOffset() + (long)this.pageable.getPageSize() > (long)AbstractSolrQuery.this.getLimit()) {
                    query.setPageRequest(AbstractSolrQuery.this.getLimitingPageable(this.pageable, AbstractSolrQuery.this.getLimit() - (int)this.pageable.getOffset()));
                }
            }
            return this.executeFind(query).getContent();
        }

        private long count(Query query) {
            return AbstractSolrQuery.this.solrOperations.count(AbstractSolrQuery.this.collection, query);
        }
    }

    abstract class AbstractQueryExecution
    implements QueryExecution {
        AbstractQueryExecution() {
        }

        protected Page<?> executeFind(Query query) {
            EntityMetadata metadata = AbstractSolrQuery.this.solrQueryMethod.getEntityInformation();
            return AbstractSolrQuery.this.solrOperations.queryForPage(AbstractSolrQuery.this.collection, query, metadata.getJavaType());
        }
    }

    private static interface QueryExecution {
        public Object execute(Query var1);
    }
}

