/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.support;

import java.io.Serializable;
import org.springframework.data.repository.core.support.PersistentEntityInformation;
import org.springframework.data.solr.core.mapping.SolrPersistentEntity;
import org.springframework.data.solr.core.mapping.SolrPersistentProperty;
import org.springframework.data.solr.repository.query.SolrEntityInformation;

public class MappingSolrEntityInformation<T, ID extends Serializable>
extends PersistentEntityInformation<T, ID>
implements SolrEntityInformation<T, ID> {
    private final SolrPersistentEntity<T> entityMetadata;
    private final String solrCoreName;

    public MappingSolrEntityInformation(SolrPersistentEntity<T> entity) {
        this(entity, null);
    }

    public MappingSolrEntityInformation(SolrPersistentEntity<T> entity, String solrCoreName) {
        super(entity);
        this.entityMetadata = entity;
        this.solrCoreName = solrCoreName;
    }

    @Override
    public String getIdAttribute() {
        return ((SolrPersistentProperty)this.entityMetadata.getIdProperty()).getFieldName();
    }

    @Override
    public String getSolrCoreName() {
        return this.solrCoreName != null ? this.solrCoreName : this.entityMetadata.getSolrCoreName();
    }
}

