/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.AndCondition;
import org.springframework.data.relational.core.sql.Comparison;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.In;
import org.springframework.data.relational.core.sql.IsNull;
import org.springframework.data.relational.core.sql.Like;
import org.springframework.data.relational.core.sql.OrCondition;
import org.springframework.data.relational.core.sql.render.ComparisonVisitor;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.InVisitor;
import org.springframework.data.relational.core.sql.render.IsNullVisitor;
import org.springframework.data.relational.core.sql.render.LikeVisitor;
import org.springframework.data.relational.core.sql.render.MultiConcatConditionVisitor;
import org.springframework.data.relational.core.sql.render.PartRenderer;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.TypedSubtreeVisitor;
import org.springframework.lang.Nullable;

class ConditionVisitor
extends TypedSubtreeVisitor<Condition>
implements PartRenderer {
    private final RenderContext context;
    private StringBuilder builder = new StringBuilder();

    ConditionVisitor(RenderContext context) {
        this.context = context;
    }

    @Override
    DelegatingVisitor.Delegation enterMatched(Condition segment) {
        DelegatingVisitor visitor = this.getDelegation(segment);
        return visitor != null ? DelegatingVisitor.Delegation.delegateTo(visitor) : DelegatingVisitor.Delegation.retain();
    }

    @Nullable
    private DelegatingVisitor getDelegation(Condition segment) {
        if (segment instanceof AndCondition) {
            return new MultiConcatConditionVisitor(this.context, (AndCondition)segment, this.builder::append);
        }
        if (segment instanceof OrCondition) {
            return new MultiConcatConditionVisitor(this.context, (OrCondition)segment, this.builder::append);
        }
        if (segment instanceof IsNull) {
            return new IsNullVisitor(this.context, this.builder::append);
        }
        if (segment instanceof Comparison) {
            return new ComparisonVisitor(this.context, (Comparison)segment, this.builder::append);
        }
        if (segment instanceof Like) {
            return new LikeVisitor((Like)segment, this.context, this.builder::append);
        }
        if (segment instanceof In) {
            return new InVisitor(this.context, this.builder::append);
        }
        return null;
    }

    @Override
    public CharSequence getRenderedPart() {
        return this.builder;
    }
}

