/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.RedisStreamCommands;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.stream.ByteRecord;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.PendingMessage;
import org.springframework.data.redis.connection.stream.PendingMessages;
import org.springframework.data.redis.connection.stream.PendingMessagesSummary;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.data.redis.connection.stream.StreamRecords;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.params.XAddParams;
import redis.clients.jedis.params.XClaimParams;
import redis.clients.jedis.params.XPendingParams;
import redis.clients.jedis.params.XReadGroupParams;
import redis.clients.jedis.params.XReadParams;
import redis.clients.jedis.resps.StreamEntry;
import redis.clients.jedis.resps.StreamPendingEntry;
import redis.clients.jedis.util.SafeEncoder;

class StreamConverters {
    StreamConverters() {
    }

    static byte[][] entryIdsToBytes(List<RecordId> recordIds) {
        byte[][] target = new byte[recordIds.size()][];
        for (int i = 0; i < recordIds.size(); ++i) {
            RecordId id = recordIds.get(i);
            target[i] = JedisConverters.toBytes(id.getValue());
        }
        return target;
    }

    static String getLowerValue(Range<String> range) {
        return StreamConverters.getValue((Range.Bound<String>)range.getLowerBound(), "-");
    }

    static String getUpperValue(Range<String> range) {
        return StreamConverters.getValue((Range.Bound<String>)range.getUpperBound(), "+");
    }

    private static String getValue(Range.Bound<String> bound, String fallbackValue) {
        if (bound.equals((Object)Range.Bound.unbounded())) {
            return fallbackValue;
        }
        return bound.getValue().map(it -> bound.isInclusive() ? it : "(" + it).orElse(fallbackValue);
    }

    static List<Object> mapToList(Map<String, Object> map) {
        ArrayList<Object> sources = new ArrayList<Object>(map.size() * 2);
        map.forEach((k, v) -> {
            sources.add(k);
            if (v instanceof StreamEntryID) {
                sources.add(v.toString());
            } else if (v instanceof StreamEntry) {
                ArrayList<Object> entries = new ArrayList<Object>(2);
                StreamEntry streamEntry = (StreamEntry)v;
                entries.add(streamEntry.getID().toString());
                entries.add(streamEntry.getFields());
                sources.add(entries);
            } else {
                sources.add(v);
            }
        });
        return sources;
    }

    static Map.Entry<byte[], byte[]>[] toStreamOffsets(StreamOffset<byte[]>[] streams) {
        return Arrays.stream(streams).collect(Collectors.toMap(StreamOffset::getKey, v -> JedisConverters.toBytes(v.getOffset().getOffset()))).entrySet().toArray(new Map.Entry[0]);
    }

    static List<ByteRecord> convertToByteRecord(byte[] key, Object source) {
        List objectList = (List)source;
        ArrayList<ByteRecord> result = new ArrayList<ByteRecord>(objectList.size() / 2);
        if (objectList.isEmpty()) {
            return result;
        }
        for (List res : objectList) {
            if (res == null) {
                result.add(null);
                continue;
            }
            String entryIdString = SafeEncoder.encode((byte[])((byte[])res.get(0)));
            List hash = (List)res.get(1);
            Iterator hashIterator = hash.iterator();
            HashMap<byte[], byte[]> fields = new HashMap<byte[], byte[]>(hash.size() / 2);
            while (hashIterator.hasNext()) {
                fields.put((byte[])hashIterator.next(), (byte[])hashIterator.next());
            }
            result.add(StreamRecords.newRecord().in(key).withId(entryIdString).ofBytes(fields));
        }
        return result;
    }

    static List<ByteRecord> convertToByteRecords(List<?> sources) {
        ArrayList<ByteRecord> result = new ArrayList<ByteRecord>(sources.size() / 2);
        for (Object source : sources) {
            List stream = (List)source;
            result.addAll(StreamConverters.convertToByteRecord((byte[])stream.get(0), stream.get(1)));
        }
        return result;
    }

    static PendingMessagesSummary toPendingMessagesSummary(String groupName, Object source) {
        Map<String, Long> map;
        List objectList = (List)source;
        long total = (Long)BuilderFactory.LONG.build(objectList.get(0));
        Range.Bound lower = objectList.get(1) != null ? Range.Bound.inclusive((Object)SafeEncoder.encode((byte[])((byte[])objectList.get(1)))) : Range.Bound.unbounded();
        Range.Bound upper = objectList.get(2) != null ? Range.Bound.inclusive((Object)SafeEncoder.encode((byte[])((byte[])objectList.get(2)))) : Range.Bound.unbounded();
        List consumerObjList = (List)objectList.get(3);
        if (consumerObjList != null) {
            map = new HashMap(consumerObjList.size());
            for (List consumerObj : consumerObjList) {
                map.put(SafeEncoder.encode((byte[])((byte[])consumerObj.get(0))), Long.parseLong(SafeEncoder.encode((byte[])((byte[])consumerObj.get(1)))));
            }
        } else {
            map = Collections.emptyMap();
        }
        return new PendingMessagesSummary(groupName, total, (Range<String>)Range.of((Range.Bound)lower, (Range.Bound)upper), map);
    }

    static PendingMessages toPendingMessages(String groupName, Range<?> range, List<StreamPendingEntry> response) {
        List<PendingMessage> messages = response.stream().map(streamPendingEntry -> new PendingMessage(RecordId.of(streamPendingEntry.getID().toString()), Consumer.from(groupName, streamPendingEntry.getConsumerName()), Duration.ofMillis(streamPendingEntry.getIdleTime()), streamPendingEntry.getDeliveredTimes())).collect(Collectors.toList());
        return new PendingMessages(groupName, messages).withinRange(range);
    }

    public static XAddParams toXAddParams(RecordId recordId, RedisStreamCommands.XAddOptions options) {
        XAddParams params = new XAddParams();
        params.id(StreamConverters.toStreamEntryId(recordId.getValue()));
        if (options.hasMaxlen()) {
            params.maxLen(options.getMaxlen().longValue());
        }
        if (options.hasMinId()) {
            params.minId(options.getMinId().getValue());
        }
        if (options.isNoMkStream()) {
            params.noMkStream();
        }
        if (options.isApproximateTrimming()) {
            params.approximateTrimming();
        }
        return params;
    }

    private static StreamEntryID toStreamEntryId(String value) {
        if ("*".equals(value)) {
            return StreamEntryID.NEW_ENTRY;
        }
        if ("$".equals(value)) {
            return StreamEntryID.LAST_ENTRY;
        }
        if (">".equals(value)) {
            return StreamEntryID.UNRECEIVED_ENTRY;
        }
        return new StreamEntryID(value);
    }

    public static XClaimParams toXClaimParams(RedisStreamCommands.XClaimOptions options) {
        XClaimParams params = XClaimParams.xClaimParams();
        if (options.isForce()) {
            params.force();
        }
        if (options.getRetryCount() != null) {
            params.retryCount(options.getRetryCount().intValue());
        }
        if (options.getUnixTime() != null) {
            params.time(options.getUnixTime().toEpochMilli());
        }
        return params;
    }

    public static XReadParams toXReadParams(StreamReadOptions readOptions) {
        XReadParams params = XReadParams.xReadParams();
        if (readOptions.isBlocking()) {
            params.block(readOptions.getBlock().intValue());
        }
        if (readOptions.getCount() != null) {
            params.count(readOptions.getCount().intValue());
        }
        return params;
    }

    public static XReadGroupParams toXReadGroupParams(StreamReadOptions readOptions) {
        XReadGroupParams params = XReadGroupParams.xReadGroupParams();
        if (readOptions.isBlocking()) {
            params.block(readOptions.getBlock().intValue());
        }
        if (readOptions.getCount() != null) {
            params.count(readOptions.getCount().intValue());
        }
        if (readOptions.isNoack()) {
            params.noAck();
        }
        return params;
    }

    public static XPendingParams toXPendingParams(RedisStreamCommands.XPendingOptions options) {
        Range<?> range = options.getRange();
        XPendingParams xPendingParams = XPendingParams.xPendingParams((String)StreamConverters.getLowerValue(range), (String)StreamConverters.getUpperValue(range), (int)options.getCount().intValue());
        if (options.hasConsumer()) {
            xPendingParams.consumer(options.getConsumerName());
        }
        return xPendingParams;
    }
}

