/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.cache;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.Callable;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractValueAdaptingCache;
import org.springframework.cache.support.NullValue;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.redis.cache.CacheStatistics;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class RedisCache
extends AbstractValueAdaptingCache {
    private static final byte[] BINARY_NULL_VALUE = RedisSerializer.java().serialize(NullValue.INSTANCE);
    private final String name;
    private final RedisCacheWriter cacheWriter;
    private final RedisCacheConfiguration cacheConfig;
    private final ConversionService conversionService;

    protected RedisCache(String name, RedisCacheWriter cacheWriter, RedisCacheConfiguration cacheConfig) {
        super(cacheConfig.getAllowCacheNullValues());
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)cacheWriter, (String)"CacheWriter must not be null!");
        Assert.notNull((Object)cacheConfig, (String)"CacheConfig must not be null!");
        this.name = name;
        this.cacheWriter = cacheWriter;
        this.cacheConfig = cacheConfig;
        this.conversionService = cacheConfig.getConversionService();
    }

    protected Object lookup(Object key) {
        byte[] value = this.cacheWriter.get(this.name, this.createAndConvertCacheKey(key));
        if (value == null) {
            return null;
        }
        return this.deserializeCacheValue(value);
    }

    public String getName() {
        return this.name;
    }

    public RedisCacheWriter getNativeCache() {
        return this.cacheWriter;
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        Cache.ValueWrapper result = this.get(key);
        if (result != null) {
            return (T)result.get();
        }
        return this.getSynchronized(key, valueLoader);
    }

    @Nullable
    private synchronized <T> T getSynchronized(Object key, Callable<T> valueLoader) {
        T value;
        Cache.ValueWrapper result = this.get(key);
        if (result != null) {
            return (T)result.get();
        }
        try {
            value = valueLoader.call();
        }
        catch (Exception e) {
            throw new Cache.ValueRetrievalException(key, valueLoader, (Throwable)e);
        }
        this.put(key, value);
        return value;
    }

    public void put(Object key, @Nullable Object value) {
        Object cacheValue = this.preProcessCacheValue(value);
        if (!this.isAllowNullValues() && cacheValue == null) {
            throw new IllegalArgumentException(String.format("Cache '%s' does not allow 'null' values. Avoid storing null via '@Cacheable(unless=\"#result == null\")' or configure RedisCache to allow 'null' via RedisCacheConfiguration.", this.name));
        }
        this.cacheWriter.put(this.name, this.createAndConvertCacheKey(key), this.serializeCacheValue(cacheValue), this.cacheConfig.getTtl());
    }

    public Cache.ValueWrapper putIfAbsent(Object key, @Nullable Object value) {
        Object cacheValue = this.preProcessCacheValue(value);
        if (!this.isAllowNullValues() && cacheValue == null) {
            return this.get(key);
        }
        byte[] result = this.cacheWriter.putIfAbsent(this.name, this.createAndConvertCacheKey(key), this.serializeCacheValue(cacheValue), this.cacheConfig.getTtl());
        if (result == null) {
            return null;
        }
        return new SimpleValueWrapper(this.fromStoreValue(this.deserializeCacheValue(result)));
    }

    public void evict(Object key) {
        this.cacheWriter.remove(this.name, this.createAndConvertCacheKey(key));
    }

    public void clear() {
        byte[] pattern = (byte[])this.conversionService.convert((Object)this.createCacheKey("*"), byte[].class);
        this.cacheWriter.clean(this.name, pattern);
    }

    public CacheStatistics getStatistics() {
        return this.cacheWriter.getCacheStatistics(this.getName());
    }

    public void clearStatistics() {
        this.cacheWriter.clearStatistics(this.getName());
    }

    public RedisCacheConfiguration getCacheConfiguration() {
        return this.cacheConfig;
    }

    @Nullable
    protected Object preProcessCacheValue(@Nullable Object value) {
        if (value != null) {
            return value;
        }
        return this.isAllowNullValues() ? NullValue.INSTANCE : null;
    }

    protected byte[] serializeCacheKey(String cacheKey) {
        return ByteUtils.getBytes(this.cacheConfig.getKeySerializationPair().write(cacheKey));
    }

    protected byte[] serializeCacheValue(Object value) {
        if (this.isAllowNullValues() && value instanceof NullValue) {
            return BINARY_NULL_VALUE;
        }
        return ByteUtils.getBytes(this.cacheConfig.getValueSerializationPair().write(value));
    }

    @Nullable
    protected Object deserializeCacheValue(byte[] value) {
        if (this.isAllowNullValues() && ObjectUtils.nullSafeEquals((Object)value, (Object)BINARY_NULL_VALUE)) {
            return NullValue.INSTANCE;
        }
        return this.cacheConfig.getValueSerializationPair().read(ByteBuffer.wrap(value));
    }

    protected String createCacheKey(Object key) {
        String convertedKey = this.convertKey(key);
        if (!this.cacheConfig.usePrefix()) {
            return convertedKey;
        }
        return this.prefixCacheKey(convertedKey);
    }

    protected String convertKey(Object key) {
        if (key instanceof String) {
            return (String)key;
        }
        TypeDescriptor source = TypeDescriptor.forObject((Object)key);
        if (this.conversionService.canConvert(source, TypeDescriptor.valueOf(String.class))) {
            try {
                return (String)this.conversionService.convert(key, String.class);
            }
            catch (ConversionFailedException e) {
                if (this.isCollectionLikeOrMap(source)) {
                    return this.convertCollectionLikeOrMapKey(key, source);
                }
                throw e;
            }
        }
        Method toString = ReflectionUtils.findMethod(key.getClass(), (String)"toString");
        if (toString != null && !Object.class.equals(toString.getDeclaringClass())) {
            return key.toString();
        }
        throw new IllegalStateException(String.format("Cannot convert cache key %s to String. Please register a suitable Converter via 'RedisCacheConfiguration.configureKeyConverters(...)' or override '%s.toString()'.", source, key.getClass().getSimpleName()));
    }

    private String convertCollectionLikeOrMapKey(Object key, TypeDescriptor source) {
        if (source.isMap()) {
            StringBuilder target = new StringBuilder("{");
            for (Map.Entry entry : ((Map)key).entrySet()) {
                target.append(this.convertKey(entry.getKey())).append("=").append(this.convertKey(entry.getValue()));
            }
            target.append("}");
            return target.toString();
        }
        if (source.isCollection() || source.isArray()) {
            StringJoiner sj = new StringJoiner(",");
            List<Object> collection = source.isCollection() ? (List<Object>)key : Arrays.asList(ObjectUtils.toObjectArray((Object)key));
            for (Object e : collection) {
                sj.add(this.convertKey(e));
            }
            return "[" + sj.toString() + "]";
        }
        throw new IllegalArgumentException(String.format("Cannot convert cache key %s to String.", key));
    }

    private boolean isCollectionLikeOrMap(TypeDescriptor source) {
        return source.isArray() || source.isCollection() || source.isMap();
    }

    private byte[] createAndConvertCacheKey(Object key) {
        return this.serializeCacheKey(this.createCacheKey(key));
    }

    private String prefixCacheKey(String key) {
        return this.cacheConfig.getKeyPrefixFor(this.name) + key;
    }
}

