/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.domain.geo;

import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Shape;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class BoundingBox
implements Shape {
    private static final long serialVersionUID = 5215611530535947924L;
    private final Distance width;
    private final Distance height;

    public BoundingBox(Distance width, Distance height) {
        Assert.notNull((Object)width, (String)"Width must not be null!");
        Assert.notNull((Object)height, (String)"Height must not be null!");
        Assert.isTrue((boolean)width.getMetric().equals(height.getMetric()), (String)"Metric for width and height must be the same!");
        this.width = width;
        this.height = height;
    }

    public BoundingBox(double width, double height, Metric metric) {
        this(new Distance(width, metric), new Distance(height, metric));
    }

    public Distance getWidth() {
        return this.height;
    }

    public Distance getHeight() {
        return this.height;
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.width);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.height);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BoundingBox)) {
            return false;
        }
        BoundingBox that = (BoundingBox)o;
        if (!ObjectUtils.nullSafeEquals((Object)this.width, (Object)that.width)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.height, (Object)that.height);
    }

    public String toString() {
        return String.format("Bounding box: [width=%s, height=%s]", this.width, this.height);
    }
}

