/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.io.IOException;
import java.util.List;
import org.springframework.data.redis.connection.NamedNode;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.data.redis.connection.RedisServer;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.util.Assert;
import redis.clients.jedis.Jedis;

public class JedisSentinelConnection
implements RedisSentinelConnection {
    private Jedis jedis;

    public JedisSentinelConnection(RedisNode sentinel) {
        this(sentinel.getHost(), sentinel.getPort());
    }

    public JedisSentinelConnection(String host, int port) {
        this(new Jedis(host, port));
    }

    public JedisSentinelConnection(Jedis jedis) {
        Assert.notNull((Object)jedis, (String)"Cannot created JedisSentinelConnection using 'null' as client.");
        this.jedis = jedis;
        this.init();
    }

    @Override
    public void failover(NamedNode master) {
        Assert.notNull((Object)master, (String)"Redis node master must not be 'null' for failover.");
        Assert.hasText((String)master.getName(), (String)"Redis master name must not be 'null' or empty for failover.");
        this.jedis.sentinelFailover(master.getName());
    }

    public List<RedisServer> masters() {
        return JedisConverters.toListOfRedisServer(this.jedis.sentinelMasters());
    }

    public List<RedisServer> slaves(NamedNode master) {
        Assert.notNull((Object)master, (String)"Master node cannot be 'null' when loading slaves.");
        return this.slaves(master.getName());
    }

    public List<RedisServer> slaves(String masterName) {
        Assert.hasText((String)masterName, (String)"Name of redis master cannot be 'null' or empty when loading slaves.");
        return JedisConverters.toListOfRedisServer(this.jedis.sentinelSlaves(masterName));
    }

    @Override
    public void remove(NamedNode master) {
        Assert.notNull((Object)master, (String)"Master node cannot be 'null' when trying to remove.");
        this.remove(master.getName());
    }

    public void remove(String masterName) {
        Assert.hasText((String)masterName, (String)"Name of redis master cannot be 'null' or empty when trying to remove.");
        this.jedis.sentinelRemove(masterName);
    }

    @Override
    public void monitor(RedisServer server) {
        Assert.notNull((Object)server, (String)"Cannot monitor 'null' server.");
        Assert.hasText((String)server.getName(), (String)"Name of server to monitor must not be 'null' or empty.");
        Assert.hasText((String)server.getHost(), (String)"Host must not be 'null' for server to monitor.");
        Assert.notNull((Object)server.getPort(), (String)"Port must not be 'null' for server to monitor.");
        Assert.notNull((Object)server.getQuorum(), (String)"Quorum must not be 'null' for server to monitor.");
        this.jedis.sentinelMonitor(server.getName(), server.getHost(), server.getPort().intValue(), server.getQuorum().intValue());
    }

    @Override
    public void close() throws IOException {
        this.jedis.close();
    }

    private void init() {
        if (!this.jedis.isConnected()) {
            this.doInit(this.jedis);
        }
    }

    protected void doInit(Jedis jedis) {
        jedis.connect();
    }

    @Override
    public boolean isOpen() {
        return this.jedis.isConnected();
    }
}

