/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import org.springframework.data.redis.connection.RedisHyperLogLogCommands;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.util.Assert;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.MultiKeyPipelineBase;
import redis.clients.jedis.PipelineBase;

class JedisHyperLogLogCommands
implements RedisHyperLogLogCommands {
    private final JedisConnection connection;

    JedisHyperLogLogCommands(JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long pfAdd(byte[] key, byte[] ... values) {
        Assert.notEmpty((Object[])values, (String)"PFADD requires at least one non 'null' value.");
        Assert.noNullElements((Object[])values, (String)"Values for PFADD must not contain 'null'.");
        return this.connection.invoke().just(BinaryJedis::pfadd, PipelineBase::pfadd, key, values);
    }

    @Override
    public Long pfCount(byte[] ... keys) {
        Assert.notEmpty((Object[])keys, (String)"PFCOUNT requires at least one non 'null' key.");
        Assert.noNullElements((Object[])keys, (String)"Keys for PFCOUNT must not contain 'null'.");
        return this.connection.invoke().just(BinaryJedis::pfcount, MultiKeyPipelineBase::pfcount, keys);
    }

    @Override
    public void pfMerge(byte[] destinationKey, byte[] ... sourceKeys) {
        Assert.notNull((Object)destinationKey, (String)"Destination key must not be null");
        Assert.notNull((Object)sourceKeys, (String)"Source keys must not be null");
        Assert.noNullElements((Object[])sourceKeys, (String)"Keys for PFMERGE must not contain 'null'.");
        this.connection.invoke().just(BinaryJedis::pfmerge, MultiKeyPipelineBase::pfmerge, destinationKey, sourceKeys);
    }
}

