/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Range;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.DecoratedRedisConnection;
import org.springframework.data.redis.connection.DefaultStringTuple;
import org.springframework.data.redis.connection.DefaultTuple;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.RedisStreamCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.StringRedisConnection;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.connection.ValueEncoding;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.convert.ListConverter;
import org.springframework.data.redis.connection.convert.MapConverter;
import org.springframework.data.redis.connection.convert.SetConverter;
import org.springframework.data.redis.connection.stream.ByteRecord;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.PendingMessages;
import org.springframework.data.redis.connection.stream.PendingMessagesSummary;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamInfo;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.data.redis.connection.stream.StringRecord;
import org.springframework.data.redis.core.ConvertingCursor;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class DefaultStringRedisConnection
implements StringRedisConnection,
DecoratedRedisConnection {
    private static final byte[][] EMPTY_2D_BYTE_ARRAY = new byte[0][];
    private final Log log = LogFactory.getLog(DefaultStringRedisConnection.class);
    private final RedisConnection delegate;
    private final RedisSerializer<String> serializer;
    private Converter<byte[], String> bytesToString = new DeserializingConverter();
    private Converter<String, byte[]> stringToBytes = new SerializingConverter();
    private SetConverter<RedisZSetCommands.Tuple, StringRedisConnection.StringTuple> tupleToStringTuple = new SetConverter<RedisZSetCommands.Tuple, StringRedisConnection.StringTuple>(new TupleConverter());
    private SetConverter<StringRedisConnection.StringTuple, RedisZSetCommands.Tuple> stringTupleToTuple = new SetConverter<StringRedisConnection.StringTuple, RedisZSetCommands.Tuple>(new StringTupleConverter());
    private ListConverter<byte[], String> byteListToStringList = new ListConverter<byte[], String>(this.bytesToString);
    private MapConverter<byte[], String> byteMapToStringMap = new MapConverter<byte[], String>(this.bytesToString);
    private MapConverter<String, byte[]> stringMapToByteMap = new MapConverter<String, byte[]>(this.stringToBytes);
    private SetConverter<byte[], String> byteSetToStringSet = new SetConverter<byte[], String>(this.bytesToString);
    private Converter<GeoResults<RedisGeoCommands.GeoLocation<byte[]>>, GeoResults<RedisGeoCommands.GeoLocation<String>>> byteGeoResultsToStringGeoResults;
    private Converter<ByteRecord, StringRecord> byteMapRecordToStringMapRecordConverter = new Converter<ByteRecord, StringRecord>(){

        @Nullable
        public StringRecord convert(ByteRecord source) {
            return StringRecord.of(source.deserialize(DefaultStringRedisConnection.this.serializer));
        }
    };
    private ListConverter<ByteRecord, StringRecord> listByteMapRecordToStringMapRecordConverter = new ListConverter<ByteRecord, StringRecord>(this.byteMapRecordToStringMapRecordConverter);
    private Queue<Converter> pipelineConverters = new LinkedList<Converter>();
    private Queue<Converter> txConverters = new LinkedList<Converter>();
    private boolean deserializePipelineAndTxResults = false;
    private IdentityConverter<Object, ?> identityConverter = new IdentityConverter();

    public DefaultStringRedisConnection(RedisConnection connection) {
        this(connection, RedisSerializer.string());
    }

    public DefaultStringRedisConnection(RedisConnection connection, RedisSerializer<String> serializer) {
        Assert.notNull((Object)connection, (String)"connection is required");
        Assert.notNull(serializer, (String)"serializer is required");
        this.delegate = connection;
        this.serializer = serializer;
        this.byteGeoResultsToStringGeoResults = Converters.deserializingGeoResultsConverter(serializer);
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        return (Long)this.convertAndReturn(this.delegate.append(key, value), this.identityConverter);
    }

    @Override
    public void bgSave() {
        this.delegate.bgSave();
    }

    @Override
    public void bgReWriteAof() {
        this.delegate.bgReWriteAof();
    }

    @Override
    @Deprecated
    public void bgWriteAof() {
        this.bgReWriteAof();
    }

    @Override
    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        return (List)this.convertAndReturn(this.delegate.bLPop(timeout, keys), this.identityConverter);
    }

    @Override
    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        return (List)this.convertAndReturn(this.delegate.bRPop(timeout, keys), this.identityConverter);
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        return (byte[])this.convertAndReturn(this.delegate.bRPopLPush(timeout, srcKey, dstKey), this.identityConverter);
    }

    @Override
    public void close() throws RedisSystemException {
        this.delegate.close();
    }

    @Override
    public Long dbSize() {
        return (Long)this.convertAndReturn(this.delegate.dbSize(), this.identityConverter);
    }

    @Override
    public Long decr(byte[] key) {
        return (Long)this.convertAndReturn(this.delegate.decr(key), this.identityConverter);
    }

    @Override
    public Long decrBy(byte[] key, long value) {
        return (Long)this.convertAndReturn(this.delegate.decrBy(key, value), this.identityConverter);
    }

    @Override
    public Long del(byte[] ... keys) {
        return (Long)this.convertAndReturn(this.delegate.del(keys), this.identityConverter);
    }

    @Override
    public Long unlink(byte[] ... keys) {
        return (Long)this.convertAndReturn(this.delegate.unlink(keys), this.identityConverter);
    }

    @Override
    public void discard() {
        try {
            this.delegate.discard();
        }
        finally {
            this.txConverters.clear();
        }
    }

    @Override
    public byte[] echo(byte[] message) {
        return (byte[])this.convertAndReturn(this.delegate.echo(message), this.identityConverter);
    }

    @Override
    public List<Object> exec() {
        try {
            List<Object> results = this.delegate.exec();
            if (this.isPipelined()) {
                this.pipelineConverters.add(new TransactionResultConverter(new LinkedList<Converter>(this.txConverters)));
                List<Object> list = results;
                return list;
            }
            List<Object> list = this.convertResults(results, this.txConverters);
            return list;
        }
        finally {
            this.txConverters.clear();
        }
    }

    @Override
    public Boolean exists(byte[] key) {
        return (Boolean)this.convertAndReturn(this.delegate.exists(key), this.identityConverter);
    }

    @Override
    public Long exists(String ... keys) {
        return (Long)this.convertAndReturn(this.delegate.exists(this.serializeMulti(keys)), this.identityConverter);
    }

    @Override
    public Long exists(byte[] ... keys) {
        return (Long)this.convertAndReturn(this.delegate.exists(keys), this.identityConverter);
    }

    @Override
    public Boolean expire(byte[] key, long seconds) {
        return (Boolean)this.convertAndReturn(this.delegate.expire(key, seconds), this.identityConverter);
    }

    @Override
    public Boolean expireAt(byte[] key, long unixTime) {
        return (Boolean)this.convertAndReturn(this.delegate.expireAt(key, unixTime), this.identityConverter);
    }

    @Override
    public void flushAll() {
        this.delegate.flushAll();
    }

    @Override
    public void flushDb() {
        this.delegate.flushDb();
    }

    @Override
    public byte[] get(byte[] key) {
        return (byte[])this.convertAndReturn(this.delegate.get(key), this.identityConverter);
    }

    @Override
    public Boolean getBit(byte[] key, long offset) {
        return (Boolean)this.convertAndReturn(this.delegate.getBit(key, offset), this.identityConverter);
    }

    @Override
    public Properties getConfig(String pattern) {
        return (Properties)this.convertAndReturn(this.delegate.getConfig(pattern), this.identityConverter);
    }

    @Override
    public Object getNativeConnection() {
        return this.convertAndReturn(this.delegate.getNativeConnection(), this.identityConverter);
    }

    @Override
    public byte[] getRange(byte[] key, long start, long end) {
        return (byte[])this.convertAndReturn(this.delegate.getRange(key, start, end), this.identityConverter);
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        return (byte[])this.convertAndReturn(this.delegate.getSet(key, value), this.identityConverter);
    }

    @Override
    public Subscription getSubscription() {
        return this.delegate.getSubscription();
    }

    @Override
    public Long hDel(byte[] key, byte[] ... fields) {
        return (Long)this.convertAndReturn(this.delegate.hDel(key, fields), this.identityConverter);
    }

    @Override
    public Boolean hExists(byte[] key, byte[] field) {
        return (Boolean)this.convertAndReturn(this.delegate.hExists(key, field), this.identityConverter);
    }

    @Override
    public byte[] hGet(byte[] key, byte[] field) {
        return (byte[])this.convertAndReturn(this.delegate.hGet(key, field), this.identityConverter);
    }

    @Override
    public Map<byte[], byte[]> hGetAll(byte[] key) {
        return (Map)this.convertAndReturn(this.delegate.hGetAll(key), this.identityConverter);
    }

    @Override
    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        return (Long)this.convertAndReturn(this.delegate.hIncrBy(key, field, delta), this.identityConverter);
    }

    @Override
    public Double hIncrBy(byte[] key, byte[] field, double delta) {
        return (Double)this.convertAndReturn(this.delegate.hIncrBy(key, field, delta), this.identityConverter);
    }

    @Override
    public Set<byte[]> hKeys(byte[] key) {
        return (Set)this.convertAndReturn(this.delegate.hKeys(key), this.identityConverter);
    }

    @Override
    public Long hLen(byte[] key) {
        return (Long)this.convertAndReturn(this.delegate.hLen(key), this.identityConverter);
    }

    @Override
    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        return (List)this.convertAndReturn(this.delegate.hMGet(key, fields), this.identityConverter);
    }

    @Override
    public void hMSet(byte[] key, Map<byte[], byte[]> hashes) {
        this.delegate.hMSet(key, hashes);
    }

    @Override
    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        return (Boolean)this.convertAndReturn(this.delegate.hSet(key, field, value), this.identityConverter);
    }

    @Override
    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        return (Boolean)this.convertAndReturn(this.delegate.hSetNX(key, field, value), this.identityConverter);
    }

    @Override
    public List<byte[]> hVals(byte[] key) {
        return (List)this.convertAndReturn(this.delegate.hVals(key), this.identityConverter);
    }

    @Override
    public Long incr(byte[] key) {
        return (Long)this.convertAndReturn(this.delegate.incr(key), this.identityConverter);
    }

    @Override
    public Long incrBy(byte[] key, long value) {
        return (Long)this.convertAndReturn(this.delegate.incrBy(key, value), this.identityConverter);
    }

    @Override
    public Double incrBy(byte[] key, double value) {
        return (Double)this.convertAndReturn(this.delegate.incrBy(key, value), this.identityConverter);
    }

    @Override
    public Properties info() {
        return (Properties)this.convertAndReturn(this.delegate.info(), this.identityConverter);
    }

    @Override
    public Properties info(String section) {
        return (Properties)this.convertAndReturn(this.delegate.info(section), this.identityConverter);
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public boolean isQueueing() {
        return this.delegate.isQueueing();
    }

    @Override
    public boolean isSubscribed() {
        return this.delegate.isSubscribed();
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        return (Set)this.convertAndReturn(this.delegate.keys(pattern), this.identityConverter);
    }

    @Override
    public Long lastSave() {
        return (Long)this.convertAndReturn(this.delegate.lastSave(), this.identityConverter);
    }

    @Override
    public byte[] lIndex(byte[] key, long index) {
        return (byte[])this.convertAndReturn(this.delegate.lIndex(key, index), this.identityConverter);
    }

    @Override
    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        return (Long)this.convertAndReturn(this.delegate.lInsert(key, where, pivot, value), this.identityConverter);
    }

    @Override
    public Long lLen(byte[] key) {
        return (Long)this.convertAndReturn(this.delegate.lLen(key), this.identityConverter);
    }

    @Override
    public byte[] lPop(byte[] key) {
        return (byte[])this.convertAndReturn(this.delegate.lPop(key), this.identityConverter);
    }

    @Override
    public List<Long> lPos(byte[] key, byte[] element, @Nullable Integer rank, @Nullable Integer count) {
        return (List)this.convertAndReturn(this.delegate.lPos(key, element, rank, count), this.identityConverter);
    }

    @Override
    public Long lPush(byte[] key, byte[] ... values) {
        return (Long)this.convertAndReturn(this.delegate.lPush(key, values), this.identityConverter);
    }

    @Override
    public Long lPushX(byte[] key, byte[] value) {
        return (Long)this.convertAndReturn(this.delegate.lPushX(key, value), this.identityConverter);
    }

    @Override
    public List<byte[]> lRange(byte[] key, long start, long end) {
        return (List)this.convertAndReturn(this.delegate.lRange(key, start, end), this.identityConverter);
    }

    @Override
    public Long lRem(byte[] key, long count, byte[] value) {
        return (Long)this.convertAndReturn(this.delegate.lRem(key, count, value), this.identityConverter);
    }

    @Override
    public void lSet(byte[] key, long index, byte[] value) {
        this.delegate.lSet(key, index, value);
    }

    @Override
    public void lTrim(byte[] key, long start, long end) {
        this.delegate.lTrim(key, start, end);
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        return (List)this.convertAndReturn(this.delegate.mGet(keys), this.identityConverter);
    }

    @Override
    public Boolean mSet(Map<byte[], byte[]> tuple) {
        return (Boolean)this.convertAndReturn(this.delegate.mSet(tuple), this.identityConverter);
    }

    @Override
    public Boolean mSetNX(Map<byte[], byte[]> tuple) {
        return (Boolean)this.convertAndReturn(this.delegate.mSetNX(tuple), this.identityConverter);
    }

    @Override
    public void multi() {
        this.delegate.multi();
    }

    @Override
    public Boolean persist(byte[] key) {
        return (Boolean)this.convertAndReturn(this.delegate.persist(key), this.identityConverter);
    }

    @Override
    public Boolean move(byte[] key, int dbIndex) {
        return (Boolean)this.convertAndReturn(this.delegate.move(key, dbIndex), this.identityConverter);
    }

    @Override
    public String ping() {
        return (String)this.convertAndReturn(this.delegate.ping(), this.identityConverter);
    }

    @Override
    public void pSubscribe(MessageListener listener, byte[] ... patterns) {
        this.delegate.pSubscribe(listener, patterns);
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        return (Long)this.convertAndReturn(this.delegate.publish(channel, message), this.identityConverter);
    }

    @Override
    public byte[] randomKey() {
        return (byte[])this.convertAndReturn(this.delegate.randomKey(), this.identityConverter);
    }

    @Override
    public void rename(byte[] sourceKey, byte[] targetKey) {
        this.delegate.rename(sourceKey, targetKey);
    }

    @Override
    public Boolean renameNX(byte[] sourceKey, byte[] targetKey) {
        return (Boolean)this.convertAndReturn(this.delegate.renameNX(sourceKey, targetKey), this.identityConverter);
    }

    @Override
    public void resetConfigStats() {
        this.delegate.resetConfigStats();
    }

    @Override
    public byte[] rPop(byte[] key) {
        return (byte[])this.convertAndReturn(this.delegate.rPop(key), this.identityConverter);
    }

    @Override
    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        return (byte[])this.convertAndReturn(this.delegate.rPopLPush(srcKey, dstKey), this.identityConverter);
    }

    @Override
    public Long rPush(byte[] key, byte[] ... values) {
        return (Long)this.convertAndReturn(this.delegate.rPush(key, values), this.identityConverter);
    }

    @Override
    public Long rPushX(byte[] key, byte[] value) {
        return (Long)this.convertAndReturn(this.delegate.rPushX(key, value), this.identityConverter);
    }

    @Override
    public Long sAdd(byte[] key, byte[] ... values) {
        return (Long)this.convertAndReturn(this.delegate.sAdd(key, values), this.identityConverter);
    }

    @Override
    public void save() {
        this.delegate.save();
    }

    @Override
    public Long sCard(byte[] key) {
        return (Long)this.convertAndReturn(this.delegate.sCard(key), this.identityConverter);
    }

    @Override
    public Set<byte[]> sDiff(byte[] ... keys) {
        return (Set)this.convertAndReturn(this.delegate.sDiff(keys), this.identityConverter);
    }

    @Override
    public Long sDiffStore(byte[] destKey, byte[] ... keys) {
        return (Long)this.convertAndReturn(this.delegate.sDiffStore(destKey, keys), this.identityConverter);
    }

    @Override
    public void select(int dbIndex) {
        this.delegate.select(dbIndex);
    }

    @Override
    public Boolean set(byte[] key, byte[] value) {
        return (Boolean)this.convertAndReturn(this.delegate.set(key, value), this.identityConverter);
    }

    @Override
    public Boolean set(byte[] key, byte[] value, Expiration expiration, RedisStringCommands.SetOption option) {
        return (Boolean)this.convertAndReturn(this.delegate.set(key, value, expiration, option), this.identityConverter);
    }

    @Override
    public Boolean setBit(byte[] key, long offset, boolean value) {
        return (Boolean)this.convertAndReturn(this.delegate.setBit(key, offset, value), this.identityConverter);
    }

    @Override
    public void setConfig(String param, String value) {
        this.delegate.setConfig(param, value);
    }

    @Override
    public Boolean setEx(byte[] key, long seconds, byte[] value) {
        return (Boolean)this.convertAndReturn(this.delegate.setEx(key, seconds, value), this.identityConverter);
    }

    @Override
    public Boolean pSetEx(byte[] key, long milliseconds, byte[] value) {
        return (Boolean)this.convertAndReturn(this.delegate.pSetEx(key, milliseconds, value), this.identityConverter);
    }

    @Override
    public Boolean setNX(byte[] key, byte[] value) {
        return (Boolean)this.convertAndReturn(this.delegate.setNX(key, value), this.identityConverter);
    }

    @Override
    public void setRange(byte[] key, byte[] value, long start) {
        this.delegate.setRange(key, value, start);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public void shutdown(RedisServerCommands.ShutdownOption option) {
        this.delegate.shutdown(option);
    }

    @Override
    public Set<byte[]> sInter(byte[] ... keys) {
        return (Set)this.convertAndReturn(this.delegate.sInter(keys), this.identityConverter);
    }

    @Override
    public Long sInterStore(byte[] destKey, byte[] ... keys) {
        return (Long)this.convertAndReturn(this.delegate.sInterStore(destKey, keys), this.identityConverter);
    }

    @Override
    public Boolean sIsMember(byte[] key, byte[] value) {
        return (Boolean)this.convertAndReturn(this.delegate.sIsMember(key, value), this.identityConverter);
    }

    @Override
    public Set<byte[]> sMembers(byte[] key) {
        return (Set)this.convertAndReturn(this.delegate.sMembers(key), this.identityConverter);
    }

    @Override
    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        return (Boolean)this.convertAndReturn(this.delegate.sMove(srcKey, destKey, value), this.identityConverter);
    }

    @Override
    public Long sort(byte[] key, SortParameters params, byte[] storeKey) {
        return (Long)this.convertAndReturn(this.delegate.sort(key, params, storeKey), this.identityConverter);
    }

    @Override
    public List<byte[]> sort(byte[] key, SortParameters params) {
        return (List)this.convertAndReturn(this.delegate.sort(key, params), this.identityConverter);
    }

    @Override
    public ValueEncoding encodingOf(byte[] key) {
        return (ValueEncoding)this.convertAndReturn(this.delegate.encodingOf(key), this.identityConverter);
    }

    @Override
    public Duration idletime(byte[] key) {
        return (Duration)this.convertAndReturn(this.delegate.idletime(key), this.identityConverter);
    }

    @Override
    public Long refcount(byte[] key) {
        return (Long)this.convertAndReturn(this.delegate.refcount(key), this.identityConverter);
    }

    @Override
    public byte[] sPop(byte[] key) {
        return (byte[])this.convertAndReturn(this.delegate.sPop(key), this.identityConverter);
    }

    @Override
    public List<byte[]> sPop(byte[] key, long count) {
        return (List)this.convertAndReturn(this.delegate.sPop(key, count), this.identityConverter);
    }

    @Override
    public byte[] sRandMember(byte[] key) {
        return (byte[])this.convertAndReturn(this.delegate.sRandMember(key), this.identityConverter);
    }

    @Override
    public List<byte[]> sRandMember(byte[] key, long count) {
        return (List)this.convertAndReturn(this.delegate.sRandMember(key, count), this.identityConverter);
    }

    @Override
    public Long sRem(byte[] key, byte[] ... values) {
        return (Long)this.convertAndReturn(this.delegate.sRem(key, values), this.identityConverter);
    }

    @Override
    public Long strLen(byte[] key) {
        return (Long)this.convertAndReturn(this.delegate.strLen(key), this.identityConverter);
    }

    @Override
    public Long bitCount(byte[] key) {
        return (Long)this.convertAndReturn(this.delegate.bitCount(key), this.identityConverter);
    }

    @Override
    public Long bitCount(byte[] key, long start, long end) {
        return (Long)this.convertAndReturn(this.delegate.bitCount(key, start, end), this.identityConverter);
    }

    @Override
    public Long bitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        return (Long)this.convertAndReturn(this.delegate.bitOp(op, destination, keys), this.identityConverter);
    }

    @Override
    @Nullable
    public Long bitPos(byte[] key, boolean bit, Range<Long> range) {
        return (Long)this.convertAndReturn(this.delegate.bitPos(key, bit, range), this.identityConverter);
    }

    @Override
    public void subscribe(MessageListener listener, byte[] ... channels) {
        this.delegate.subscribe(listener, channels);
    }

    @Override
    public Set<byte[]> sUnion(byte[] ... keys) {
        return (Set)this.convertAndReturn(this.delegate.sUnion(keys), this.identityConverter);
    }

    @Override
    public Long sUnionStore(byte[] destKey, byte[] ... keys) {
        return (Long)this.convertAndReturn(this.delegate.sUnionStore(destKey, keys), this.identityConverter);
    }

    @Override
    public Long ttl(byte[] key) {
        return (Long)this.convertAndReturn(this.delegate.ttl(key), this.identityConverter);
    }

    @Override
    public Long ttl(byte[] key, TimeUnit timeUnit) {
        return (Long)this.convertAndReturn(this.delegate.ttl(key, timeUnit), this.identityConverter);
    }

    @Override
    public DataType type(byte[] key) {
        return (DataType)((Object)this.convertAndReturn((Object)this.delegate.type(key), this.identityConverter));
    }

    @Override
    public Long touch(byte[] ... keys) {
        return (Long)this.convertAndReturn(this.delegate.touch(keys), this.identityConverter);
    }

    @Override
    public void unwatch() {
        this.delegate.unwatch();
    }

    @Override
    public void watch(byte[] ... keys) {
        this.delegate.watch(keys);
    }

    @Override
    public Boolean zAdd(byte[] key, double score, byte[] value) {
        return (Boolean)this.convertAndReturn(this.delegate.zAdd(key, score, value), this.identityConverter);
    }

    @Override
    public Long zAdd(byte[] key, Set<RedisZSetCommands.Tuple> tuples) {
        return (Long)this.convertAndReturn(this.delegate.zAdd(key, tuples), this.identityConverter);
    }

    @Override
    public Long zCard(byte[] key) {
        return (Long)this.convertAndReturn(this.delegate.zCard(key), this.identityConverter);
    }

    @Override
    public Long zCount(byte[] key, double min, double max) {
        return (Long)this.convertAndReturn(this.delegate.zCount(key, min, max), this.identityConverter);
    }

    @Override
    public Long zCount(byte[] key, RedisZSetCommands.Range range) {
        return (Long)this.convertAndReturn(this.delegate.zCount(key, range), this.identityConverter);
    }

    @Override
    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        return (Double)this.convertAndReturn(this.delegate.zIncrBy(key, increment, value), this.identityConverter);
    }

    @Override
    public Long zInterStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights, byte[] ... sets) {
        return (Long)this.convertAndReturn(this.delegate.zInterStore(destKey, aggregate, weights, sets), this.identityConverter);
    }

    @Override
    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        return (Long)this.convertAndReturn(this.delegate.zInterStore(destKey, sets), this.identityConverter);
    }

    @Override
    public Set<byte[]> zRange(byte[] key, long start, long end) {
        return (Set)this.convertAndReturn(this.delegate.zRange(key, start, end), this.identityConverter);
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max, long offset, long count) {
        return (Set)this.convertAndReturn(this.delegate.zRangeByScore(key, min, max, offset, count), this.identityConverter);
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        return (Set)this.convertAndReturn(this.delegate.zRangeByScore(key, range), this.identityConverter);
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        return (Set)this.convertAndReturn(this.delegate.zRangeByScore(key, range, limit), this.identityConverter);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range) {
        return (Set)this.convertAndReturn(this.delegate.zRangeByScoreWithScores(key, range), this.identityConverter);
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max) {
        return (Set)this.convertAndReturn(this.delegate.zRangeByScore(key, min, max), this.identityConverter);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        return (Set)this.convertAndReturn(this.delegate.zRangeByScoreWithScores(key, min, max, offset, count), this.identityConverter);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        return (Set)this.convertAndReturn(this.delegate.zRangeByScoreWithScores(key, range, limit), this.identityConverter);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max) {
        return (Set)this.convertAndReturn(this.delegate.zRangeByScoreWithScores(key, min, max), this.identityConverter);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeWithScores(byte[] key, long start, long end) {
        return (Set)this.convertAndReturn(this.delegate.zRangeWithScores(key, start, end), this.identityConverter);
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max, long offset, long count) {
        return (Set)this.convertAndReturn(this.delegate.zRevRangeByScore(key, min, max, offset, count), this.identityConverter);
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        return (Set)this.convertAndReturn(this.delegate.zRevRangeByScore(key, range), this.identityConverter);
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max) {
        return (Set)this.convertAndReturn(this.delegate.zRevRangeByScore(key, min, max), this.identityConverter);
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        return (Set)this.convertAndReturn(this.delegate.zRevRangeByScore(key, range, limit), this.identityConverter);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        return (Set)this.convertAndReturn(this.delegate.zRevRangeByScoreWithScores(key, min, max, offset, count), this.identityConverter);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range) {
        return (Set)this.convertAndReturn(this.delegate.zRevRangeByScoreWithScores(key, range), this.identityConverter);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        return (Set)this.convertAndReturn(this.delegate.zRevRangeByScoreWithScores(key, range, limit), this.identityConverter);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max) {
        return (Set)this.convertAndReturn(this.delegate.zRevRangeByScoreWithScores(key, min, max), this.identityConverter);
    }

    @Override
    public Long zRank(byte[] key, byte[] value) {
        return (Long)this.convertAndReturn(this.delegate.zRank(key, value), this.identityConverter);
    }

    @Override
    public Long zRem(byte[] key, byte[] ... values) {
        return (Long)this.convertAndReturn(this.delegate.zRem(key, values), this.identityConverter);
    }

    @Override
    public Long zRemRange(byte[] key, long start, long end) {
        return (Long)this.convertAndReturn(this.delegate.zRemRange(key, start, end), this.identityConverter);
    }

    @Override
    public Long zRemRangeByScore(byte[] key, double min, double max) {
        return (Long)this.convertAndReturn(this.delegate.zRemRangeByScore(key, min, max), this.identityConverter);
    }

    @Override
    public Long zRemRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        return (Long)this.convertAndReturn(this.delegate.zRemRangeByScore(key, range), this.identityConverter);
    }

    @Override
    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        return (Set)this.convertAndReturn(this.delegate.zRevRange(key, start, end), this.identityConverter);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        return (Set)this.convertAndReturn(this.delegate.zRevRangeWithScores(key, start, end), this.identityConverter);
    }

    @Override
    public Long zRevRank(byte[] key, byte[] value) {
        return (Long)this.convertAndReturn(this.delegate.zRevRank(key, value), this.identityConverter);
    }

    @Override
    public Double zScore(byte[] key, byte[] value) {
        return (Double)this.convertAndReturn(this.delegate.zScore(key, value), this.identityConverter);
    }

    @Override
    public Long zUnionStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights, byte[] ... sets) {
        return (Long)this.convertAndReturn(this.delegate.zUnionStore(destKey, aggregate, weights, sets), this.identityConverter);
    }

    @Override
    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        return (Long)this.convertAndReturn(this.delegate.zUnionStore(destKey, sets), this.identityConverter);
    }

    @Override
    public Long zLexCount(String key, RedisZSetCommands.Range range) {
        return this.delegate.zLexCount(this.serialize(key), range);
    }

    @Override
    public Boolean pExpire(byte[] key, long millis) {
        return (Boolean)this.convertAndReturn(this.delegate.pExpire(key, millis), this.identityConverter);
    }

    @Override
    public Boolean pExpireAt(byte[] key, long unixTimeInMillis) {
        return (Boolean)this.convertAndReturn(this.delegate.pExpireAt(key, unixTimeInMillis), this.identityConverter);
    }

    @Override
    public Long pTtl(byte[] key) {
        return (Long)this.convertAndReturn(this.delegate.pTtl(key), this.identityConverter);
    }

    @Override
    public Long pTtl(byte[] key, TimeUnit timeUnit) {
        return (Long)this.convertAndReturn(this.delegate.pTtl(key, timeUnit), this.identityConverter);
    }

    @Override
    public byte[] dump(byte[] key) {
        return (byte[])this.convertAndReturn(this.delegate.dump(key), this.identityConverter);
    }

    @Override
    public void restore(byte[] key, long ttlInMillis, byte[] serializedValue, boolean replace) {
        this.delegate.restore(key, ttlInMillis, serializedValue, replace);
    }

    @Override
    public void scriptFlush() {
        this.delegate.scriptFlush();
    }

    @Override
    public void scriptKill() {
        this.delegate.scriptKill();
    }

    @Override
    public String scriptLoad(byte[] script) {
        return (String)this.convertAndReturn(this.delegate.scriptLoad(script), this.identityConverter);
    }

    @Override
    public List<Boolean> scriptExists(String ... scriptSha1) {
        return (List)this.convertAndReturn(this.delegate.scriptExists(scriptSha1), this.identityConverter);
    }

    @Override
    public <T> T eval(byte[] script, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        return this.convertAndReturn(this.delegate.eval(script, returnType, numKeys, keysAndArgs), this.identityConverter);
    }

    @Override
    public <T> T evalSha(String scriptSha1, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        return this.convertAndReturn(this.delegate.evalSha(scriptSha1, returnType, numKeys, keysAndArgs), this.identityConverter);
    }

    @Override
    public <T> T evalSha(byte[] scriptSha1, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        return this.convertAndReturn(this.delegate.evalSha(scriptSha1, returnType, numKeys, keysAndArgs), this.identityConverter);
    }

    private byte[] serialize(String data) {
        return this.serializer.serialize(data);
    }

    private StreamOffset<byte[]>[] serialize(StreamOffset<String>[] offsets) {
        return (StreamOffset[])Arrays.stream(offsets).map(it -> StreamOffset.create(this.serialize((String)it.getKey()), it.getOffset())).toArray(StreamOffset[]::new);
    }

    private byte[][] serializeMulti(String ... keys) {
        if (keys == null) {
            return EMPTY_2D_BYTE_ARRAY;
        }
        byte[][] ret = new byte[keys.length][];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.serializer.serialize(keys[i]);
        }
        return ret;
    }

    private Map<byte[], byte[]> serialize(Map<String, String> hashes) {
        LinkedHashMap<byte[], byte[]> ret = new LinkedHashMap<byte[], byte[]>(hashes.size());
        for (Map.Entry<String, String> entry : hashes.entrySet()) {
            ret.put(this.serializer.serialize(entry.getKey()), this.serializer.serialize(entry.getValue()));
        }
        return ret;
    }

    @Override
    public Long append(String key, String value) {
        return this.append(this.serialize(key), this.serialize(value));
    }

    @Override
    public List<String> bLPop(int timeout, String ... keys) {
        return (List)this.convertAndReturn(this.delegate.bLPop(timeout, this.serializeMulti(keys)), this.byteListToStringList);
    }

    @Override
    public List<String> bRPop(int timeout, String ... keys) {
        return (List)this.convertAndReturn(this.delegate.bRPop(timeout, this.serializeMulti(keys)), this.byteListToStringList);
    }

    @Override
    public String bRPopLPush(int timeout, String srcKey, String dstKey) {
        return (String)this.convertAndReturn(this.delegate.bRPopLPush(timeout, this.serialize(srcKey), this.serialize(dstKey)), this.bytesToString);
    }

    @Override
    public Long decr(String key) {
        return this.decr(this.serialize(key));
    }

    @Override
    public Long decrBy(String key, long value) {
        return this.decrBy(this.serialize(key), value);
    }

    @Override
    public Long del(String ... keys) {
        return this.del(this.serializeMulti(keys));
    }

    @Override
    public Long unlink(String ... keys) {
        return this.unlink(this.serializeMulti(keys));
    }

    @Override
    public String echo(String message) {
        return (String)this.convertAndReturn(this.delegate.echo(this.serialize(message)), this.bytesToString);
    }

    @Override
    public Boolean exists(String key) {
        return this.exists(this.serialize(key));
    }

    @Override
    public Boolean expire(String key, long seconds) {
        return this.expire(this.serialize(key), seconds);
    }

    @Override
    public Boolean expireAt(String key, long unixTime) {
        return this.expireAt(this.serialize(key), unixTime);
    }

    @Override
    public String get(String key) {
        return (String)this.convertAndReturn(this.delegate.get(this.serialize(key)), this.bytesToString);
    }

    @Override
    public Boolean getBit(String key, long offset) {
        return this.getBit(this.serialize(key), offset);
    }

    @Override
    public String getRange(String key, long start, long end) {
        return (String)this.convertAndReturn(this.delegate.getRange(this.serialize(key), start, end), this.bytesToString);
    }

    @Override
    public String getSet(String key, String value) {
        return (String)this.convertAndReturn(this.delegate.getSet(this.serialize(key), this.serialize(value)), this.bytesToString);
    }

    @Override
    public Long hDel(String key, String ... fields) {
        return this.hDel(this.serialize(key), this.serializeMulti(fields));
    }

    @Override
    public Boolean hExists(String key, String field) {
        return this.hExists(this.serialize(key), this.serialize(field));
    }

    @Override
    public String hGet(String key, String field) {
        return (String)this.convertAndReturn(this.delegate.hGet(this.serialize(key), this.serialize(field)), this.bytesToString);
    }

    @Override
    public Map<String, String> hGetAll(String key) {
        return (Map)this.convertAndReturn(this.delegate.hGetAll(this.serialize(key)), this.byteMapToStringMap);
    }

    @Override
    public Long hIncrBy(String key, String field, long delta) {
        return this.hIncrBy(this.serialize(key), this.serialize(field), delta);
    }

    @Override
    public Double hIncrBy(String key, String field, double delta) {
        return this.hIncrBy(this.serialize(key), this.serialize(field), delta);
    }

    @Override
    public Set<String> hKeys(String key) {
        return (Set)this.convertAndReturn(this.delegate.hKeys(this.serialize(key)), this.byteSetToStringSet);
    }

    @Override
    public Long hLen(String key) {
        return this.hLen(this.serialize(key));
    }

    @Override
    public List<String> hMGet(String key, String ... fields) {
        return (List)this.convertAndReturn(this.delegate.hMGet(this.serialize(key), this.serializeMulti(fields)), this.byteListToStringList);
    }

    @Override
    public void hMSet(String key, Map<String, String> hashes) {
        this.delegate.hMSet(this.serialize(key), this.serialize(hashes));
    }

    @Override
    public Boolean hSet(String key, String field, String value) {
        return this.hSet(this.serialize(key), this.serialize(field), this.serialize(value));
    }

    @Override
    public Boolean hSetNX(String key, String field, String value) {
        return this.hSetNX(this.serialize(key), this.serialize(field), this.serialize(value));
    }

    @Override
    public List<String> hVals(String key) {
        return (List)this.convertAndReturn(this.delegate.hVals(this.serialize(key)), this.byteListToStringList);
    }

    @Override
    public Long incr(String key) {
        return this.incr(this.serialize(key));
    }

    @Override
    public Long incrBy(String key, long value) {
        return this.incrBy(this.serialize(key), value);
    }

    @Override
    public Double incrBy(String key, double value) {
        return this.incrBy(this.serialize(key), value);
    }

    @Override
    public Collection<String> keys(String pattern) {
        return (Collection)this.convertAndReturn(this.delegate.keys(this.serialize(pattern)), this.byteSetToStringSet);
    }

    @Override
    public String lIndex(String key, long index) {
        return (String)this.convertAndReturn(this.delegate.lIndex(this.serialize(key), index), this.bytesToString);
    }

    @Override
    public Long lInsert(String key, RedisListCommands.Position where, String pivot, String value) {
        return this.lInsert(this.serialize(key), where, this.serialize(pivot), this.serialize(value));
    }

    @Override
    public Long lLen(String key) {
        return this.lLen(this.serialize(key));
    }

    @Override
    public String lPop(String key) {
        return (String)this.convertAndReturn(this.delegate.lPop(this.serialize(key)), this.bytesToString);
    }

    @Override
    public List<Long> lPos(String key, String element, @Nullable Integer rank, @Nullable Integer count) {
        return this.lPos(this.serialize(key), this.serialize(element), rank, count);
    }

    @Override
    public Long lPush(String key, String ... values) {
        return this.lPush(this.serialize(key), this.serializeMulti(values));
    }

    @Override
    public Long lPushX(String key, String value) {
        return this.lPushX(this.serialize(key), this.serialize(value));
    }

    @Override
    public List<String> lRange(String key, long start, long end) {
        return (List)this.convertAndReturn(this.delegate.lRange(this.serialize(key), start, end), this.byteListToStringList);
    }

    @Override
    public Long lRem(String key, long count, String value) {
        return this.lRem(this.serialize(key), count, this.serialize(value));
    }

    @Override
    public void lSet(String key, long index, String value) {
        this.delegate.lSet(this.serialize(key), index, this.serialize(value));
    }

    @Override
    public void lTrim(String key, long start, long end) {
        this.delegate.lTrim(this.serialize(key), start, end);
    }

    @Override
    public List<String> mGet(String ... keys) {
        return (List)this.convertAndReturn(this.delegate.mGet(this.serializeMulti(keys)), this.byteListToStringList);
    }

    @Override
    public Boolean mSetNXString(Map<String, String> tuple) {
        return this.mSetNX(this.serialize(tuple));
    }

    @Override
    public Boolean mSetString(Map<String, String> tuple) {
        return this.mSet(this.serialize(tuple));
    }

    @Override
    public Boolean persist(String key) {
        return this.persist(this.serialize(key));
    }

    @Override
    public Boolean move(String key, int dbIndex) {
        return this.move(this.serialize(key), dbIndex);
    }

    @Override
    public void pSubscribe(MessageListener listener, String ... patterns) {
        this.delegate.pSubscribe(listener, this.serializeMulti(patterns));
    }

    @Override
    public Long publish(String channel, String message) {
        return this.publish(this.serialize(channel), this.serialize(message));
    }

    @Override
    public void rename(String oldName, String newName) {
        this.delegate.rename(this.serialize(oldName), this.serialize(newName));
    }

    @Override
    public Boolean renameNX(String oldName, String newName) {
        return this.renameNX(this.serialize(oldName), this.serialize(newName));
    }

    @Override
    public String rPop(String key) {
        return (String)this.convertAndReturn(this.delegate.rPop(this.serialize(key)), this.bytesToString);
    }

    @Override
    public String rPopLPush(String srcKey, String dstKey) {
        return (String)this.convertAndReturn(this.delegate.rPopLPush(this.serialize(srcKey), this.serialize(dstKey)), this.bytesToString);
    }

    @Override
    public Long rPush(String key, String ... values) {
        return this.rPush(this.serialize(key), this.serializeMulti(values));
    }

    @Override
    public Long rPushX(String key, String value) {
        return this.rPushX(this.serialize(key), this.serialize(value));
    }

    @Override
    public Long sAdd(String key, String ... values) {
        return this.sAdd(this.serialize(key), this.serializeMulti(values));
    }

    @Override
    public Long sCard(String key) {
        return this.sCard(this.serialize(key));
    }

    @Override
    public Set<String> sDiff(String ... keys) {
        return (Set)this.convertAndReturn(this.delegate.sDiff(this.serializeMulti(keys)), this.byteSetToStringSet);
    }

    @Override
    public Long sDiffStore(String destKey, String ... keys) {
        return this.sDiffStore(this.serialize(destKey), this.serializeMulti(keys));
    }

    @Override
    public Boolean set(String key, String value) {
        return this.set(this.serialize(key), this.serialize(value));
    }

    @Override
    public Boolean set(String key, String value, Expiration expiration, RedisStringCommands.SetOption option) {
        return this.set(this.serialize(key), this.serialize(value), expiration, option);
    }

    @Override
    public Boolean setBit(String key, long offset, boolean value) {
        return this.setBit(this.serialize(key), offset, value);
    }

    @Override
    public Boolean setEx(String key, long seconds, String value) {
        return this.setEx(this.serialize(key), seconds, this.serialize(value));
    }

    @Override
    public Boolean pSetEx(String key, long seconds, String value) {
        return this.pSetEx(this.serialize(key), seconds, this.serialize(value));
    }

    @Override
    public Boolean setNX(String key, String value) {
        return this.setNX(this.serialize(key), this.serialize(value));
    }

    @Override
    public void setRange(String key, String value, long start) {
        this.delegate.setRange(this.serialize(key), this.serialize(value), start);
    }

    @Override
    public Set<String> sInter(String ... keys) {
        return (Set)this.convertAndReturn(this.delegate.sInter(this.serializeMulti(keys)), this.byteSetToStringSet);
    }

    @Override
    public Long sInterStore(String destKey, String ... keys) {
        return this.sInterStore(this.serialize(destKey), this.serializeMulti(keys));
    }

    @Override
    public Boolean sIsMember(String key, String value) {
        return this.sIsMember(this.serialize(key), this.serialize(value));
    }

    @Override
    public Set<String> sMembers(String key) {
        return (Set)this.convertAndReturn(this.delegate.sMembers(this.serialize(key)), this.byteSetToStringSet);
    }

    @Override
    public Boolean sMove(String srcKey, String destKey, String value) {
        return this.sMove(this.serialize(srcKey), this.serialize(destKey), this.serialize(value));
    }

    @Override
    public Long sort(String key, SortParameters params, String storeKey) {
        return this.sort(this.serialize(key), params, this.serialize(storeKey));
    }

    @Override
    public List<String> sort(String key, SortParameters params) {
        return (List)this.convertAndReturn(this.delegate.sort(this.serialize(key), params), this.byteListToStringList);
    }

    @Override
    public ValueEncoding encodingOf(String key) {
        return this.encodingOf(this.serialize(key));
    }

    @Override
    public Duration idletime(String key) {
        return this.idletime(this.serialize(key));
    }

    @Override
    public Long refcount(String key) {
        return this.refcount(this.serialize(key));
    }

    @Override
    public String sPop(String key) {
        return (String)this.convertAndReturn(this.delegate.sPop(this.serialize(key)), this.bytesToString);
    }

    @Override
    public List<String> sPop(String key, long count) {
        return (List)this.convertAndReturn(this.delegate.sPop(this.serialize(key), count), this.byteListToStringList);
    }

    @Override
    public String sRandMember(String key) {
        return (String)this.convertAndReturn(this.delegate.sRandMember(this.serialize(key)), this.bytesToString);
    }

    @Override
    public List<String> sRandMember(String key, long count) {
        return (List)this.convertAndReturn(this.delegate.sRandMember(this.serialize(key), count), this.byteListToStringList);
    }

    @Override
    public Long sRem(String key, String ... values) {
        return this.sRem(this.serialize(key), this.serializeMulti(values));
    }

    @Override
    public Long strLen(String key) {
        return this.strLen(this.serialize(key));
    }

    @Override
    public Long bitCount(String key) {
        return this.bitCount(this.serialize(key));
    }

    @Override
    public Long bitCount(String key, long start, long end) {
        return this.bitCount(this.serialize(key), start, end);
    }

    @Override
    public Long bitOp(RedisStringCommands.BitOperation op, String destination, String ... keys) {
        return this.bitOp(op, this.serialize(destination), this.serializeMulti(keys));
    }

    @Override
    @Nullable
    public Long bitPos(String key, boolean bit, Range<Long> range) {
        return this.bitPos(this.serialize(key), bit, range);
    }

    @Override
    public void subscribe(MessageListener listener, String ... channels) {
        this.delegate.subscribe(listener, this.serializeMulti(channels));
    }

    @Override
    public Set<String> sUnion(String ... keys) {
        return (Set)this.convertAndReturn(this.delegate.sUnion(this.serializeMulti(keys)), this.byteSetToStringSet);
    }

    @Override
    public Long sUnionStore(String destKey, String ... keys) {
        return this.sUnionStore(this.serialize(destKey), this.serializeMulti(keys));
    }

    @Override
    public Long ttl(String key) {
        return this.ttl(this.serialize(key));
    }

    @Override
    public Long ttl(String key, TimeUnit timeUnit) {
        return this.ttl(this.serialize(key), timeUnit);
    }

    @Override
    public DataType type(String key) {
        return this.type(this.serialize(key));
    }

    @Override
    @Nullable
    public Long touch(String ... keys) {
        return this.touch(this.serializeMulti(keys));
    }

    @Override
    public Boolean zAdd(String key, double score, String value) {
        return this.zAdd(this.serialize(key), score, this.serialize(value));
    }

    @Override
    public Long zAdd(String key, Set<StringRedisConnection.StringTuple> tuples) {
        return this.zAdd(this.serialize(key), this.stringTupleToTuple.convert(tuples));
    }

    @Override
    public Long zCard(String key) {
        return this.zCard(this.serialize(key));
    }

    @Override
    public Long zCount(String key, double min, double max) {
        return this.zCount(this.serialize(key), min, max);
    }

    @Override
    public Long zLexCount(byte[] key, RedisZSetCommands.Range range) {
        return this.delegate.zLexCount(key, range);
    }

    @Override
    public Double zIncrBy(String key, double increment, String value) {
        return this.zIncrBy(this.serialize(key), increment, this.serialize(value));
    }

    @Override
    public Long zInterStore(String destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, String ... sets) {
        return this.zInterStore(this.serialize(destKey), aggregate, weights, this.serializeMulti(sets));
    }

    @Override
    public Long zInterStore(String destKey, String ... sets) {
        return this.zInterStore(this.serialize(destKey), this.serializeMulti(sets));
    }

    @Override
    public Set<String> zRange(String key, long start, long end) {
        return (Set)this.convertAndReturn(this.delegate.zRange(this.serialize(key), start, end), this.byteSetToStringSet);
    }

    @Override
    public Set<String> zRangeByScore(String key, double min, double max, long offset, long count) {
        return (Set)this.convertAndReturn(this.delegate.zRangeByScore(this.serialize(key), min, max, offset, count), this.byteSetToStringSet);
    }

    @Override
    public Set<String> zRangeByScore(String key, double min, double max) {
        return (Set)this.convertAndReturn(this.delegate.zRangeByScore(this.serialize(key), min, max), this.byteSetToStringSet);
    }

    @Override
    public Set<StringRedisConnection.StringTuple> zRangeByScoreWithScores(String key, double min, double max, long offset, long count) {
        return (Set)this.convertAndReturn(this.delegate.zRangeByScoreWithScores(this.serialize(key), min, max, offset, count), this.tupleToStringTuple);
    }

    @Override
    public Set<StringRedisConnection.StringTuple> zRangeByScoreWithScores(String key, double min, double max) {
        return (Set)this.convertAndReturn(this.delegate.zRangeByScoreWithScores(this.serialize(key), min, max), this.tupleToStringTuple);
    }

    @Override
    public Set<StringRedisConnection.StringTuple> zRangeWithScores(String key, long start, long end) {
        return (Set)this.convertAndReturn(this.delegate.zRangeWithScores(this.serialize(key), start, end), this.tupleToStringTuple);
    }

    @Override
    public Long zRank(String key, String value) {
        return this.zRank(this.serialize(key), this.serialize(value));
    }

    @Override
    public Long zRem(String key, String ... values) {
        return this.zRem(this.serialize(key), this.serializeMulti(values));
    }

    @Override
    public Long zRemRange(String key, long start, long end) {
        return this.zRemRange(this.serialize(key), start, end);
    }

    @Override
    public Long zRemRangeByScore(String key, double min, double max) {
        return this.zRemRangeByScore(this.serialize(key), min, max);
    }

    @Override
    public Set<String> zRevRange(String key, long start, long end) {
        return (Set)this.convertAndReturn(this.delegate.zRevRange(this.serialize(key), start, end), this.byteSetToStringSet);
    }

    @Override
    public Set<StringRedisConnection.StringTuple> zRevRangeWithScores(String key, long start, long end) {
        return (Set)this.convertAndReturn(this.delegate.zRevRangeWithScores(this.serialize(key), start, end), this.tupleToStringTuple);
    }

    @Override
    public Set<String> zRevRangeByScore(String key, double min, double max) {
        return (Set)this.convertAndReturn(this.delegate.zRevRangeByScore(this.serialize(key), min, max), this.byteSetToStringSet);
    }

    @Override
    public Set<StringRedisConnection.StringTuple> zRevRangeByScoreWithScores(String key, double min, double max) {
        return (Set)this.convertAndReturn(this.delegate.zRevRangeByScoreWithScores(this.serialize(key), min, max), this.tupleToStringTuple);
    }

    @Override
    public Set<String> zRevRangeByScore(String key, double min, double max, long offset, long count) {
        return (Set)this.convertAndReturn(this.delegate.zRevRangeByScore(this.serialize(key), min, max, offset, count), this.byteSetToStringSet);
    }

    @Override
    public Set<StringRedisConnection.StringTuple> zRevRangeByScoreWithScores(String key, double min, double max, long offset, long count) {
        return (Set)this.convertAndReturn(this.delegate.zRevRangeByScoreWithScores(this.serialize(key), min, max, offset, count), this.tupleToStringTuple);
    }

    @Override
    public Long zRevRank(String key, String value) {
        return this.zRevRank(this.serialize(key), this.serialize(value));
    }

    @Override
    public Double zScore(String key, String value) {
        return this.zScore(this.serialize(key), this.serialize(value));
    }

    @Override
    public Long zUnionStore(String destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, String ... sets) {
        return this.zUnionStore(this.serialize(destKey), aggregate, weights, this.serializeMulti(sets));
    }

    @Override
    public Long zUnionStore(String destKey, String ... sets) {
        return this.zUnionStore(this.serialize(destKey), this.serializeMulti(sets));
    }

    @Override
    public Long geoAdd(byte[] key, Point point, byte[] member) {
        return (Long)this.convertAndReturn(this.delegate.geoAdd(key, point, member), this.identityConverter);
    }

    @Override
    public Long geoAdd(byte[] key, RedisGeoCommands.GeoLocation<byte[]> location) {
        return (Long)this.convertAndReturn(this.delegate.geoAdd(key, location), this.identityConverter);
    }

    @Override
    public Long geoAdd(String key, Point point, String member) {
        return this.geoAdd(this.serialize(key), point, this.serialize(member));
    }

    @Override
    public Long geoAdd(String key, RedisGeoCommands.GeoLocation<String> location) {
        Assert.notNull(location, (String)"Location must not be null!");
        return this.geoAdd(key, location.getPoint(), location.getName());
    }

    @Override
    public Long geoAdd(byte[] key, Map<byte[], Point> memberCoordinateMap) {
        return (Long)this.convertAndReturn(this.delegate.geoAdd(key, memberCoordinateMap), this.identityConverter);
    }

    @Override
    public Long geoAdd(byte[] key, Iterable<RedisGeoCommands.GeoLocation<byte[]>> locations) {
        return (Long)this.convertAndReturn(this.delegate.geoAdd(key, locations), this.identityConverter);
    }

    @Override
    public Long geoAdd(String key, Map<String, Point> memberCoordinateMap) {
        Assert.notNull(memberCoordinateMap, (String)"MemberCoordinateMap must not be null!");
        HashMap<byte[], Point> byteMap = new HashMap<byte[], Point>();
        for (Map.Entry<String, Point> entry : memberCoordinateMap.entrySet()) {
            byteMap.put(this.serialize(entry.getKey()), entry.getValue());
        }
        return this.geoAdd(this.serialize(key), byteMap);
    }

    @Override
    public Long geoAdd(String key, Iterable<RedisGeoCommands.GeoLocation<String>> locations) {
        Assert.notNull(locations, (String)"Locations must not be null!");
        HashMap<byte[], Point> byteMap = new HashMap<byte[], Point>();
        for (RedisGeoCommands.GeoLocation<String> location : locations) {
            byteMap.put(this.serialize(location.getName()), location.getPoint());
        }
        return this.geoAdd(this.serialize(key), byteMap);
    }

    @Override
    public Distance geoDist(byte[] key, byte[] member1, byte[] member2) {
        return (Distance)this.convertAndReturn(this.delegate.geoDist(key, member1, member2), this.identityConverter);
    }

    @Override
    public Distance geoDist(String key, String member1, String member2) {
        return this.geoDist(this.serialize(key), this.serialize(member1), this.serialize(member2));
    }

    @Override
    public Distance geoDist(byte[] key, byte[] member1, byte[] member2, Metric metric) {
        return (Distance)this.convertAndReturn(this.delegate.geoDist(key, member1, member2, metric), this.identityConverter);
    }

    @Override
    public Distance geoDist(String key, String member1, String member2, Metric metric) {
        return this.geoDist(this.serialize(key), this.serialize(member1), this.serialize(member2), metric);
    }

    @Override
    public List<String> geoHash(byte[] key, byte[] ... members) {
        return (List)this.convertAndReturn(this.delegate.geoHash(key, members), this.identityConverter);
    }

    @Override
    public List<String> geoHash(String key, String ... members) {
        return (List)this.convertAndReturn(this.delegate.geoHash(this.serialize(key), this.serializeMulti(members)), this.identityConverter);
    }

    @Override
    public List<Point> geoPos(byte[] key, byte[] ... members) {
        return (List)this.convertAndReturn(this.delegate.geoPos(key, members), this.identityConverter);
    }

    @Override
    public List<Point> geoPos(String key, String ... members) {
        return this.geoPos(this.serialize(key), this.serializeMulti(members));
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<String>> geoRadius(String key, Circle within) {
        return (GeoResults)this.convertAndReturn(this.delegate.geoRadius(this.serialize(key), within), this.byteGeoResultsToStringGeoResults);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<String>> geoRadius(String key, Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return (GeoResults)this.convertAndReturn(this.delegate.geoRadius(this.serialize(key), within, args), this.byteGeoResultsToStringGeoResults);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<String>> geoRadiusByMember(String key, String member, double radius) {
        return this.geoRadiusByMember(key, member, new Distance(radius, (Metric)RedisGeoCommands.DistanceUnit.METERS));
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<String>> geoRadiusByMember(String key, String member, Distance radius) {
        return (GeoResults)this.convertAndReturn(this.delegate.geoRadiusByMember(this.serialize(key), this.serialize(member), radius), this.byteGeoResultsToStringGeoResults);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<String>> geoRadiusByMember(String key, String member, Distance radius, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return (GeoResults)this.convertAndReturn(this.delegate.geoRadiusByMember(this.serialize(key), this.serialize(member), radius, args), this.byteGeoResultsToStringGeoResults);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte[] key, Circle within) {
        return (GeoResults)this.convertAndReturn(this.delegate.geoRadius(key, within), this.identityConverter);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte[] key, Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return (GeoResults)this.convertAndReturn(this.delegate.geoRadius(key, within, args), this.identityConverter);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, double radius) {
        return this.geoRadiusByMember(key, member, new Distance(radius, (Metric)RedisGeoCommands.DistanceUnit.METERS));
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, Distance radius) {
        return (GeoResults)this.convertAndReturn(this.delegate.geoRadiusByMember(key, member, radius), this.identityConverter);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, Distance radius, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return (GeoResults)this.convertAndReturn(this.delegate.geoRadiusByMember(key, member, radius, args), this.identityConverter);
    }

    @Override
    public Long geoRemove(byte[] key, byte[] ... members) {
        return this.zRem(key, members);
    }

    @Override
    public Long geoRemove(String key, String ... members) {
        return this.geoRemove(this.serialize(key), this.serializeMulti(members));
    }

    @Override
    public List<Object> closePipeline() {
        try {
            List<Object> list = this.convertResults(this.delegate.closePipeline(), this.pipelineConverters);
            return list;
        }
        finally {
            this.pipelineConverters.clear();
        }
    }

    @Override
    public boolean isPipelined() {
        return this.delegate.isPipelined();
    }

    @Override
    public void openPipeline() {
        this.delegate.openPipeline();
    }

    @Override
    public Object execute(String command) {
        return this.execute(command, EMPTY_2D_BYTE_ARRAY);
    }

    @Override
    public Object execute(String command, byte[] ... args) {
        return this.convertAndReturn(this.delegate.execute(command, args), this.identityConverter);
    }

    @Override
    public Object execute(String command, String ... args) {
        return this.execute(command, this.serializeMulti(args));
    }

    @Override
    public Boolean pExpire(String key, long millis) {
        return this.pExpire(this.serialize(key), millis);
    }

    @Override
    public Boolean pExpireAt(String key, long unixTimeInMillis) {
        return this.pExpireAt(this.serialize(key), unixTimeInMillis);
    }

    @Override
    public Long pTtl(String key) {
        return this.pTtl(this.serialize(key));
    }

    @Override
    public Long pTtl(String key, TimeUnit timeUnit) {
        return this.pTtl(this.serialize(key), timeUnit);
    }

    @Override
    public String scriptLoad(String script) {
        return this.scriptLoad(this.serialize(script));
    }

    @Override
    public <T> T eval(String script, ReturnType returnType, int numKeys, String ... keysAndArgs) {
        return this.eval(this.serialize(script), returnType, numKeys, this.serializeMulti(keysAndArgs));
    }

    @Override
    public <T> T evalSha(String scriptSha1, ReturnType returnType, int numKeys, String ... keysAndArgs) {
        return this.evalSha(scriptSha1, returnType, numKeys, this.serializeMulti(keysAndArgs));
    }

    @Override
    public Long time() {
        return (Long)this.convertAndReturn(this.delegate.time(), this.identityConverter);
    }

    @Override
    public List<RedisClientInfo> getClientList() {
        return (List)this.convertAndReturn(this.delegate.getClientList(), this.identityConverter);
    }

    @Override
    public void slaveOf(String host, int port) {
        this.delegate.slaveOf(host, port);
    }

    @Override
    public void slaveOfNoOne() {
        this.delegate.slaveOfNoOne();
    }

    @Override
    public Cursor<byte[]> scan(ScanOptions options) {
        return this.delegate.scan(options);
    }

    @Override
    public Cursor<RedisZSetCommands.Tuple> zScan(byte[] key, ScanOptions options) {
        return this.delegate.zScan(key, options);
    }

    @Override
    public Cursor<byte[]> sScan(byte[] key, ScanOptions options) {
        return this.delegate.sScan(key, options);
    }

    @Override
    public Cursor<Map.Entry<byte[], byte[]>> hScan(byte[] key, ScanOptions options) {
        return this.delegate.hScan(key, options);
    }

    @Override
    @Nullable
    public Long hStrLen(byte[] key, byte[] field) {
        return (Long)this.convertAndReturn(this.delegate.hStrLen(key, field), this.identityConverter);
    }

    @Override
    public void setClientName(byte[] name) {
        this.delegate.setClientName(name);
    }

    @Override
    public void setClientName(String name) {
        this.setClientName(this.serializer.serialize(name));
    }

    @Override
    public void killClient(String host, int port) {
        this.delegate.killClient(host, port);
    }

    @Override
    public String getClientName() {
        return (String)this.convertAndReturn(this.delegate.getClientName(), this.identityConverter);
    }

    @Override
    public Cursor<Map.Entry<String, String>> hScan(String key, ScanOptions options) {
        return new ConvertingCursor(this.delegate.hScan(this.serialize(key), options), source -> new Map.Entry<String, String>(){

            @Override
            public String getKey() {
                return (String)DefaultStringRedisConnection.this.bytesToString.convert(source.getKey());
            }

            @Override
            public String getValue() {
                return (String)DefaultStringRedisConnection.this.bytesToString.convert(source.getValue());
            }

            @Override
            public String setValue(String value) {
                throw new UnsupportedOperationException("Cannot set value for entry in cursor");
            }
        });
    }

    @Override
    public Long hStrLen(String key, String field) {
        return this.hStrLen(this.serialize(key), this.serialize(field));
    }

    @Override
    public Cursor<String> sScan(String key, ScanOptions options) {
        return new ConvertingCursor<byte[], String>(this.delegate.sScan(this.serialize(key), options), this.bytesToString);
    }

    @Override
    public Cursor<StringRedisConnection.StringTuple> zScan(String key, ScanOptions options) {
        return new ConvertingCursor<RedisZSetCommands.Tuple, StringRedisConnection.StringTuple>(this.delegate.zScan(this.serialize(key), options), new TupleConverter());
    }

    @Override
    public RedisSentinelConnection getSentinelConnection() {
        return this.delegate.getSentinelConnection();
    }

    @Override
    public Set<String> zRangeByScore(String key, String min, String max) {
        return (Set)this.convertAndReturn(this.delegate.zRangeByScore(this.serialize(key), min, max), this.byteSetToStringSet);
    }

    @Override
    public Set<String> zRangeByScore(String key, String min, String max, long offset, long count) {
        return (Set)this.convertAndReturn(this.delegate.zRangeByScore(this.serialize(key), min, max, offset, count), this.byteSetToStringSet);
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max) {
        return (Set)this.convertAndReturn(this.delegate.zRangeByScore(key, min, max), this.identityConverter);
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max, long offset, long count) {
        return (Set)this.convertAndReturn(this.delegate.zRangeByScore(key, min, max, offset, count), this.identityConverter);
    }

    @Override
    public Long pfAdd(byte[] key, byte[] ... values) {
        return (Long)this.convertAndReturn(this.delegate.pfAdd(key, values), this.identityConverter);
    }

    @Override
    public Long pfAdd(String key, String ... values) {
        return this.pfAdd(this.serialize(key), this.serializeMulti(values));
    }

    @Override
    public Long pfCount(byte[] ... keys) {
        return (Long)this.convertAndReturn(this.delegate.pfCount(keys), this.identityConverter);
    }

    @Override
    public Long pfCount(String ... keys) {
        return this.pfCount(this.serializeMulti(keys));
    }

    @Override
    public void pfMerge(byte[] destinationKey, byte[] ... sourceKeys) {
        this.delegate.pfMerge(destinationKey, sourceKeys);
    }

    @Override
    public void pfMerge(String destinationKey, String ... sourceKeys) {
        this.pfMerge(this.serialize(destinationKey), this.serializeMulti(sourceKeys));
    }

    @Override
    public Set<byte[]> zRangeByLex(byte[] key) {
        return (Set)this.convertAndReturn(this.delegate.zRangeByLex(key), this.identityConverter);
    }

    @Override
    public Set<byte[]> zRangeByLex(byte[] key, RedisZSetCommands.Range range) {
        return (Set)this.convertAndReturn(this.delegate.zRangeByLex(key, range), this.identityConverter);
    }

    @Override
    public Set<byte[]> zRangeByLex(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        return (Set)this.convertAndReturn(this.delegate.zRangeByLex(key, range, limit), this.identityConverter);
    }

    @Override
    public Set<String> zRangeByLex(String key) {
        return this.zRangeByLex(key, RedisZSetCommands.Range.unbounded());
    }

    @Override
    public Set<String> zRangeByLex(String key, RedisZSetCommands.Range range) {
        return this.zRangeByLex(key, range, RedisZSetCommands.Limit.unlimited());
    }

    @Override
    public Set<String> zRangeByLex(String key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        return (Set)this.convertAndReturn(this.delegate.zRangeByLex(this.serialize(key), range, limit), this.byteSetToStringSet);
    }

    @Override
    public Set<byte[]> zRevRangeByLex(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        return (Set)this.convertAndReturn(this.delegate.zRevRangeByLex(key, range, limit), this.identityConverter);
    }

    @Override
    public Set<String> zRevRangeByLex(String key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        return (Set)this.convertAndReturn(this.delegate.zRevRangeByLex(this.serialize(key), range, limit), this.byteSetToStringSet);
    }

    @Override
    public void migrate(byte[] key, RedisNode target, int dbIndex, @Nullable RedisServerCommands.MigrateOption option) {
        this.delegate.migrate(key, target, dbIndex, option);
    }

    @Override
    public void migrate(byte[] key, RedisNode target, int dbIndex, @Nullable RedisServerCommands.MigrateOption option, long timeout) {
        this.delegate.migrate(key, target, dbIndex, option, timeout);
    }

    @Override
    public Long xAck(String key, String group, RecordId ... recordIds) {
        return (Long)this.convertAndReturn(this.delegate.xAck(this.serialize(key), group, recordIds), this.identityConverter);
    }

    @Override
    public RecordId xAdd(StringRecord record, RedisStreamCommands.XAddOptions options) {
        return (RecordId)this.convertAndReturn(this.delegate.xAdd(record.serialize(this.serializer), options), this.identityConverter);
    }

    @Override
    public List<RecordId> xClaimJustId(String key, String group, String consumer, RedisStreamCommands.XClaimOptions options) {
        return (List)this.convertAndReturn(this.delegate.xClaimJustId(this.serialize(key), group, consumer, options), this.identityConverter);
    }

    @Override
    public List<StringRecord> xClaim(String key, String group, String consumer, RedisStreamCommands.XClaimOptions options) {
        return (List)this.convertAndReturn(this.delegate.xClaim(this.serialize(key), group, consumer, options), this.listByteMapRecordToStringMapRecordConverter);
    }

    @Override
    public Long xDel(String key, RecordId ... recordIds) {
        return (Long)this.convertAndReturn(this.delegate.xDel(this.serialize(key), recordIds), this.identityConverter);
    }

    @Override
    public String xGroupCreate(String key, ReadOffset readOffset, String group) {
        return (String)this.convertAndReturn(this.delegate.xGroupCreate(this.serialize(key), group, readOffset), this.identityConverter);
    }

    @Override
    public String xGroupCreate(String key, ReadOffset readOffset, String group, boolean mkStream) {
        return (String)this.convertAndReturn(this.delegate.xGroupCreate(this.serialize(key), group, readOffset, mkStream), this.identityConverter);
    }

    @Override
    public Boolean xGroupDelConsumer(String key, Consumer consumer) {
        return (Boolean)this.convertAndReturn(this.delegate.xGroupDelConsumer(this.serialize(key), consumer), this.identityConverter);
    }

    @Override
    public Boolean xGroupDestroy(String key, String group) {
        return (Boolean)this.convertAndReturn(this.delegate.xGroupDestroy(this.serialize(key), group), this.identityConverter);
    }

    @Override
    public StreamInfo.XInfoStream xInfo(String key) {
        return (StreamInfo.XInfoStream)this.convertAndReturn(this.delegate.xInfo(this.serialize(key)), this.identityConverter);
    }

    @Override
    public StreamInfo.XInfoGroups xInfoGroups(String key) {
        return (StreamInfo.XInfoGroups)this.convertAndReturn(this.delegate.xInfoGroups(this.serialize(key)), this.identityConverter);
    }

    @Override
    public StreamInfo.XInfoConsumers xInfoConsumers(String key, String groupName) {
        return (StreamInfo.XInfoConsumers)this.convertAndReturn(this.delegate.xInfoConsumers(this.serialize(key), groupName), this.identityConverter);
    }

    @Override
    public Long xLen(String key) {
        return (Long)this.convertAndReturn(this.delegate.xLen(this.serialize(key)), this.identityConverter);
    }

    @Override
    public PendingMessagesSummary xPending(String key, String groupName) {
        return (PendingMessagesSummary)this.convertAndReturn(this.delegate.xPending(this.serialize(key), groupName), this.identityConverter);
    }

    @Override
    public PendingMessages xPending(String key, String groupName, String consumer, Range<String> range, Long count) {
        return (PendingMessages)this.convertAndReturn(this.delegate.xPending(this.serialize(key), groupName, consumer, range, count), this.identityConverter);
    }

    @Override
    public PendingMessages xPending(String key, String groupName, Range<String> range, Long count) {
        return (PendingMessages)this.convertAndReturn(this.delegate.xPending(this.serialize(key), groupName, range, count), this.identityConverter);
    }

    @Override
    public PendingMessages xPending(String key, String groupName, RedisStreamCommands.XPendingOptions options) {
        return (PendingMessages)this.convertAndReturn(this.delegate.xPending(this.serialize(key), groupName, options), this.identityConverter);
    }

    @Override
    public List<StringRecord> xRange(String key, Range<String> range, RedisZSetCommands.Limit limit) {
        return (List)this.convertAndReturn(this.delegate.xRange(this.serialize(key), range, limit), this.listByteMapRecordToStringMapRecordConverter);
    }

    @Override
    public List<StringRecord> xReadAsString(StreamReadOptions readOptions, StreamOffset<String> ... streams) {
        return (List)this.convertAndReturn(this.delegate.xRead(readOptions, this.serialize(streams)), this.listByteMapRecordToStringMapRecordConverter);
    }

    @Override
    public List<StringRecord> xReadGroupAsString(Consumer consumer, StreamReadOptions readOptions, StreamOffset<String> ... streams) {
        return (List)this.convertAndReturn(this.delegate.xReadGroup(consumer, readOptions, this.serialize(streams)), this.listByteMapRecordToStringMapRecordConverter);
    }

    @Override
    public List<StringRecord> xRevRange(String key, Range<String> range, RedisZSetCommands.Limit limit) {
        return (List)this.convertAndReturn(this.delegate.xRevRange(this.serialize(key), range, limit), this.listByteMapRecordToStringMapRecordConverter);
    }

    @Override
    public Long xTrim(String key, long count) {
        return this.xTrim(key, count, false);
    }

    @Override
    public Long xTrim(String key, long count, boolean approximateTrimming) {
        return (Long)this.convertAndReturn(this.delegate.xTrim(this.serialize(key), count, approximateTrimming), this.identityConverter);
    }

    @Override
    public Long xAck(byte[] key, String group, RecordId ... recordIds) {
        return this.delegate.xAck(key, group, recordIds);
    }

    @Override
    public RecordId xAdd(MapRecord<byte[], byte[], byte[]> record, RedisStreamCommands.XAddOptions options) {
        return this.delegate.xAdd(record, options);
    }

    @Override
    public List<RecordId> xClaimJustId(byte[] key, String group, String newOwner, RedisStreamCommands.XClaimOptions options) {
        return this.delegate.xClaimJustId(key, group, newOwner, options);
    }

    @Override
    public List<ByteRecord> xClaim(byte[] key, String group, String newOwner, RedisStreamCommands.XClaimOptions options) {
        return this.delegate.xClaim(key, group, newOwner, options);
    }

    @Override
    public Long xDel(byte[] key, RecordId ... recordIds) {
        return this.delegate.xDel(key, recordIds);
    }

    @Override
    public String xGroupCreate(byte[] key, String groupName, ReadOffset readOffset) {
        return this.delegate.xGroupCreate(key, groupName, readOffset);
    }

    @Override
    public String xGroupCreate(byte[] key, String groupName, ReadOffset readOffset, boolean mkStream) {
        return this.delegate.xGroupCreate(key, groupName, readOffset, mkStream);
    }

    @Override
    public Boolean xGroupDelConsumer(byte[] key, Consumer consumer) {
        return this.delegate.xGroupDelConsumer(key, consumer);
    }

    @Override
    public Boolean xGroupDestroy(byte[] key, String groupName) {
        return this.delegate.xGroupDestroy(key, groupName);
    }

    @Override
    public StreamInfo.XInfoStream xInfo(byte[] key) {
        return this.delegate.xInfo(key);
    }

    @Override
    public StreamInfo.XInfoGroups xInfoGroups(byte[] key) {
        return this.delegate.xInfoGroups(key);
    }

    @Override
    public StreamInfo.XInfoConsumers xInfoConsumers(byte[] key, String groupName) {
        return this.delegate.xInfoConsumers(key, groupName);
    }

    @Override
    public Long xLen(byte[] key) {
        return this.delegate.xLen(key);
    }

    @Override
    public PendingMessagesSummary xPending(byte[] key, String groupName) {
        return this.delegate.xPending(key, groupName);
    }

    @Override
    public PendingMessages xPending(byte[] key, String groupName, RedisStreamCommands.XPendingOptions options) {
        return this.delegate.xPending(key, groupName, options);
    }

    @Override
    public List<ByteRecord> xRange(byte[] key, Range<String> range, RedisZSetCommands.Limit limit) {
        return this.delegate.xRange(key, range, limit);
    }

    @Override
    public List<ByteRecord> xRead(StreamReadOptions readOptions, StreamOffset<byte[]> ... streams) {
        return this.delegate.xRead(readOptions, streams);
    }

    @Override
    public List<ByteRecord> xReadGroup(Consumer consumer, StreamReadOptions readOptions, StreamOffset<byte[]> ... streams) {
        return this.delegate.xReadGroup(consumer, readOptions, streams);
    }

    @Override
    public List<ByteRecord> xRevRange(byte[] key, Range<String> range, RedisZSetCommands.Limit limit) {
        return this.delegate.xRevRange(key, range, limit);
    }

    @Override
    public Long xTrim(byte[] key, long count) {
        return this.xTrim(key, count, false);
    }

    @Override
    public Long xTrim(byte[] key, long count, boolean approximateTrimming) {
        return this.delegate.xTrim(key, count, approximateTrimming);
    }

    public void setDeserializePipelineAndTxResults(boolean deserializePipelineAndTxResults) {
        this.deserializePipelineAndTxResults = deserializePipelineAndTxResults;
    }

    @Nullable
    private <T> T convertAndReturn(@Nullable Object value, Converter converter) {
        if (this.isFutureConversion()) {
            this.addResultConverter(converter);
            return null;
        }
        if (!(converter instanceof ListConverter) && value instanceof List) {
            return (T)new ListConverter(converter).convert((List)value);
        }
        return (T)(value == null ? null : (ObjectUtils.nullSafeEquals((Object)converter, this.identityConverter) ? value : converter.convert(value)));
    }

    private void addResultConverter(Converter<?, ?> converter) {
        if (this.isQueueing()) {
            this.txConverters.add(converter);
        } else {
            this.pipelineConverters.add(converter);
        }
    }

    private boolean isFutureConversion() {
        return this.isPipelined() || this.isQueueing();
    }

    private List<Object> convertResults(@Nullable List<Object> results, Queue<Converter> converters) {
        if (!this.deserializePipelineAndTxResults || results == null) {
            return results;
        }
        if (results.size() != converters.size()) {
            this.log.warn((Object)"Delegate returned an unexpected number of results. Abandoning type conversion.");
            return results;
        }
        ArrayList<Object> convertedResults = new ArrayList<Object>(results.size());
        for (Object result : results) {
            Converter converter = converters.remove();
            convertedResults.add(result == null ? null : converter.convert(result));
        }
        return convertedResults;
    }

    @Override
    public List<Long> bitField(byte[] key, BitFieldSubCommands subCommands) {
        return this.delegate.bitField(key, subCommands);
    }

    @Override
    public List<Long> bitfield(String key, BitFieldSubCommands operation) {
        List<Long> results = this.delegate.bitField(this.serialize(key), operation);
        if (this.isFutureConversion()) {
            this.addResultConverter(this.identityConverter);
        }
        return results;
    }

    @Override
    public RedisConnection getDelegate() {
        return this.delegate;
    }

    private class TransactionResultConverter
    implements Converter<List<Object>, List<Object>> {
        private Queue<Converter> txConverters;

        public TransactionResultConverter(Queue<Converter> txConverters) {
            this.txConverters = txConverters;
        }

        public List<Object> convert(List<Object> execResults) {
            return DefaultStringRedisConnection.this.convertResults(execResults, this.txConverters);
        }
    }

    private class IdentityConverter<S, T>
    implements Converter<S, T> {
        private IdentityConverter() {
        }

        public Object convert(Object source) {
            return source;
        }
    }

    private class StringTupleConverter
    implements Converter<StringRedisConnection.StringTuple, RedisZSetCommands.Tuple> {
        private StringTupleConverter() {
        }

        public RedisZSetCommands.Tuple convert(StringRedisConnection.StringTuple source) {
            return new DefaultTuple(source.getValue(), source.getScore());
        }
    }

    private class TupleConverter
    implements Converter<RedisZSetCommands.Tuple, StringRedisConnection.StringTuple> {
        private TupleConverter() {
        }

        public StringRedisConnection.StringTuple convert(RedisZSetCommands.Tuple source) {
            return new DefaultStringTuple(source, (String)DefaultStringRedisConnection.this.serializer.deserialize(source.getValue()));
        }
    }

    private class SerializingConverter
    implements Converter<String, byte[]> {
        private SerializingConverter() {
        }

        @Nullable
        public byte[] convert(String source) {
            return DefaultStringRedisConnection.this.serializer.serialize(source);
        }
    }

    private class DeserializingConverter
    implements Converter<byte[], String> {
        private DeserializingConverter() {
        }

        public String convert(byte[] source) {
            return (String)DefaultStringRedisConnection.this.serializer.deserialize(source);
        }
    }
}

