/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.util.Assert;

public class RedisStandaloneConfiguration {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 6379;
    private String hostName = "localhost";
    private int port = 6379;
    private int database;
    private RedisPassword password = RedisPassword.none();

    public RedisStandaloneConfiguration() {
    }

    public RedisStandaloneConfiguration(String hostName) {
        this(hostName, 6379);
    }

    public RedisStandaloneConfiguration(String hostName, int port) {
        Assert.hasText((String)hostName, (String)"Host name must not be null or empty!");
        Assert.isTrue((port >= 1 && port <= 65535 ? 1 : 0) != 0, () -> String.format("Port %d must be a valid TCP port in the range between 1-65535!", port));
        this.hostName = hostName;
        this.port = port;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, () -> String.format("Invalid DB index '%s' (a positive index required)", index));
        this.database = index;
    }

    public RedisPassword getPassword() {
        return this.password;
    }

    public void setPassword(RedisPassword password) {
        Assert.notNull((Object)password, (String)"RedisPassword must not be null!");
        this.password = password;
    }
}

