/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.DefaultBoundKeyOperations;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultBoundHashOperations<H, HK, HV>
extends DefaultBoundKeyOperations<H>
implements BoundHashOperations<H, HK, HV> {
    private final HashOperations<H, HK, HV> ops;

    public DefaultBoundHashOperations(H key, RedisOperations<H, ?> operations) {
        super(key, operations);
        this.ops = operations.opsForHash();
    }

    @Override
    public void delete(Object key) {
        this.ops.delete(this.getKey(), key);
    }

    @Override
    public HV get(Object key) {
        return this.ops.get(this.getKey(), key);
    }

    @Override
    public List<HV> multiGet(Collection<HK> hashKeys) {
        return this.ops.multiGet(this.getKey(), hashKeys);
    }

    @Override
    public RedisOperations<H, ?> getOperations() {
        return this.ops.getOperations();
    }

    @Override
    public Boolean hasKey(Object key) {
        return this.ops.hasKey(this.getKey(), key);
    }

    @Override
    public Long increment(HK key, long delta) {
        return this.ops.increment(this.getKey(), key, delta);
    }

    @Override
    public Set<HK> keys() {
        return this.ops.keys(this.getKey());
    }

    @Override
    public Long size() {
        return this.ops.size(this.getKey());
    }

    @Override
    public void putAll(Map<? extends HK, ? extends HV> m) {
        this.ops.putAll(this.getKey(), m);
    }

    @Override
    public void put(HK key, HV value) {
        this.ops.put(this.getKey(), key, value);
    }

    @Override
    public Boolean putIfAbsent(HK key, HV value) {
        return this.ops.putIfAbsent(this.getKey(), key, value);
    }

    @Override
    public List<HV> values() {
        return this.ops.values(this.getKey());
    }

    @Override
    public Map<HK, HV> entries() {
        return this.ops.entries(this.getKey());
    }

    @Override
    public DataType getType() {
        return DataType.HASH;
    }
}

