/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RedisListenerContainerParser
extends AbstractSimpleBeanDefinitionParser {
    RedisListenerContainerParser() {
    }

    protected Class<RedisMessageListenerContainer> getBeanClass(Element element) {
        return RedisMessageListenerContainer.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        NamedNodeMap attributes = element.getAttributes();
        for (int x = 0; x < attributes.getLength(); ++x) {
            Attr attribute = (Attr)attributes.item(x);
            if (!this.isEligibleAttribute(attribute, parserContext)) continue;
            String propertyName = this.extractPropertyName(attribute.getLocalName());
            Assert.state((boolean)StringUtils.hasText((String)propertyName), (String)"Illegal property name returned from 'extractPropertyName(String)': cannot be null or empty.");
            builder.addPropertyReference(propertyName, attribute.getValue());
        }
        String phase = element.getAttribute("phase");
        if (StringUtils.hasText((String)phase)) {
            builder.addPropertyValue("phase", (Object)phase);
        }
        this.postProcess(builder, element);
        List listDefs = DomUtils.getChildElementsByTagName((Element)element, (String)"listener");
        if (!listDefs.isEmpty()) {
            ManagedMap listeners = new ManagedMap(listDefs.size());
            for (Element listElement : listDefs) {
                Object[] listenerDefinition = this.parseListener(listElement);
                listeners.put((Object)((BeanDefinition)listenerDefinition[0]), (Object)((Collection)listenerDefinition[1]));
            }
            builder.addPropertyValue("messageListeners", (Object)listeners);
        }
    }

    protected boolean isEligibleAttribute(String attributeName) {
        return !"phase".equals(attributeName);
    }

    private Object[] parseListener(Element element) {
        String serializer;
        Object[] ret = new Object[2];
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MessageListenerAdapter.class);
        builder.addConstructorArgReference(element.getAttribute("ref"));
        String method = element.getAttribute("method");
        if (StringUtils.hasText((String)method)) {
            builder.addPropertyValue("defaultListenerMethod", (Object)method);
        }
        if (StringUtils.hasText((String)(serializer = element.getAttribute("serializer")))) {
            builder.addPropertyReference("serializer", serializer);
        }
        ArrayList<PatternTopic> topics = new ArrayList<PatternTopic>();
        String xTopics = element.getAttribute("topic");
        if (StringUtils.hasText((String)xTopics)) {
            String[] array;
            for (String string : array = StringUtils.delimitedListToStringArray((String)xTopics, (String)" ")) {
                topics.add((PatternTopic)(string.contains("*") ? new PatternTopic(string) : new ChannelTopic(string)));
            }
        }
        ret[0] = builder.getBeanDefinition();
        ret[1] = topics;
        return ret;
    }

    protected boolean shouldGenerateId() {
        return true;
    }
}

