/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.core.AbstractOperations;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultZSetOperations<K, V>
extends AbstractOperations<K, V>
implements ZSetOperations<K, V> {
    DefaultZSetOperations(RedisTemplate<K, V> template) {
        super(template);
    }

    @Override
    public Boolean add(K key, V value, final double score) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawValue = this.rawValue(value);
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doInRedis(RedisConnection connection) {
                return connection.zAdd(rawKey, score, rawValue);
            }
        }, true);
    }

    @Override
    public Double incrementScore(K key, V value, final double delta) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawValue = this.rawValue(value);
        return this.execute(new RedisCallback<Double>(){

            @Override
            public Double doInRedis(RedisConnection connection) {
                return connection.zIncrBy(rawKey, delta, rawValue);
            }
        }, true);
    }

    @Override
    public Long intersectAndStore(K key, K otherKey, K destKey) {
        return this.intersectAndStore(key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    @Override
    public Long intersectAndStore(K key, Collection<K> otherKeys, K destKey) {
        final byte[][] rawKeys = this.rawKeys(key, otherKeys);
        final byte[] rawDestKey = this.rawKey(destKey);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.zInterStore(rawDestKey, rawKeys);
            }
        }, true);
    }

    @Override
    public Set<V> range(K key, final long start, final long end) {
        final byte[] rawKey = this.rawKey(key);
        Set<byte[]> rawValues = this.execute(new RedisCallback<Set<byte[]>>(){

            @Override
            public Set<byte[]> doInRedis(RedisConnection connection) {
                return connection.zRange(rawKey, start, end);
            }
        }, true);
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<V> reverseRange(K key, final long start, final long end) {
        final byte[] rawKey = this.rawKey(key);
        Set<byte[]> rawValues = this.execute(new RedisCallback<Set<byte[]>>(){

            @Override
            public Set<byte[]> doInRedis(RedisConnection connection) {
                return connection.zRevRange(rawKey, start, end);
            }
        }, true);
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> rangeWithScores(K key, final long start, final long end) {
        final byte[] rawKey = this.rawKey(key);
        Set<RedisZSetCommands.Tuple> rawValues = this.execute(new RedisCallback<Set<RedisZSetCommands.Tuple>>(){

            @Override
            public Set<RedisZSetCommands.Tuple> doInRedis(RedisConnection connection) {
                return connection.zRangeWithScores(rawKey, start, end);
            }
        }, true);
        return this.deserializeTupleValues(rawValues);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> reverseRangeWithScores(K key, final long start, final long end) {
        final byte[] rawKey = this.rawKey(key);
        Set<RedisZSetCommands.Tuple> rawValues = this.execute(new RedisCallback<Set<RedisZSetCommands.Tuple>>(){

            @Override
            public Set<RedisZSetCommands.Tuple> doInRedis(RedisConnection connection) {
                return connection.zRevRangeWithScores(rawKey, start, end);
            }
        }, true);
        return this.deserializeTupleValues(rawValues);
    }

    @Override
    public Set<V> rangeByScore(K key, final double min, final double max) {
        final byte[] rawKey = this.rawKey(key);
        Set<byte[]> rawValues = this.execute(new RedisCallback<Set<byte[]>>(){

            @Override
            public Set<byte[]> doInRedis(RedisConnection connection) {
                return connection.zRangeByScore(rawKey, min, max);
            }
        }, true);
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<V> rangeByScore(K key, final double min, final double max, final long offset, final long count) {
        final byte[] rawKey = this.rawKey(key);
        Set<byte[]> rawValues = this.execute(new RedisCallback<Set<byte[]>>(){

            @Override
            public Set<byte[]> doInRedis(RedisConnection connection) {
                return connection.zRangeByScore(rawKey, min, max, offset, count);
            }
        }, true);
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<V> reverseRangeByScore(K key, final double min, final double max) {
        final byte[] rawKey = this.rawKey(key);
        Set<byte[]> rawValues = this.execute(new RedisCallback<Set<byte[]>>(){

            @Override
            public Set<byte[]> doInRedis(RedisConnection connection) {
                return connection.zRevRangeByScore(rawKey, min, max);
            }
        }, true);
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<V> reverseRangeByScore(K key, final double min, final double max, final long offset, final long count) {
        final byte[] rawKey = this.rawKey(key);
        Set<byte[]> rawValues = this.execute(new RedisCallback<Set<byte[]>>(){

            @Override
            public Set<byte[]> doInRedis(RedisConnection connection) {
                return connection.zRevRangeByScore(rawKey, min, max, offset, count);
            }
        }, true);
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> rangeByScoreWithScores(K key, final double min, final double max) {
        final byte[] rawKey = this.rawKey(key);
        Set<RedisZSetCommands.Tuple> rawValues = this.execute(new RedisCallback<Set<RedisZSetCommands.Tuple>>(){

            @Override
            public Set<RedisZSetCommands.Tuple> doInRedis(RedisConnection connection) {
                return connection.zRangeByScoreWithScores(rawKey, min, max);
            }
        }, true);
        return this.deserializeTupleValues(rawValues);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> rangeByScoreWithScores(K key, final double min, final double max, final long offset, final long count) {
        final byte[] rawKey = this.rawKey(key);
        Set<RedisZSetCommands.Tuple> rawValues = this.execute(new RedisCallback<Set<RedisZSetCommands.Tuple>>(){

            @Override
            public Set<RedisZSetCommands.Tuple> doInRedis(RedisConnection connection) {
                return connection.zRangeByScoreWithScores(rawKey, min, max, offset, count);
            }
        }, true);
        return this.deserializeTupleValues(rawValues);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> reverseRangeByScoreWithScores(K key, final double min, final double max) {
        final byte[] rawKey = this.rawKey(key);
        Set<RedisZSetCommands.Tuple> rawValues = this.execute(new RedisCallback<Set<RedisZSetCommands.Tuple>>(){

            @Override
            public Set<RedisZSetCommands.Tuple> doInRedis(RedisConnection connection) {
                return connection.zRevRangeByScoreWithScores(rawKey, min, max);
            }
        }, true);
        return this.deserializeTupleValues(rawValues);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> reverseRangeByScoreWithScores(K key, final double min, final double max, final long offset, final long count) {
        final byte[] rawKey = this.rawKey(key);
        Set<RedisZSetCommands.Tuple> rawValues = this.execute(new RedisCallback<Set<RedisZSetCommands.Tuple>>(){

            @Override
            public Set<RedisZSetCommands.Tuple> doInRedis(RedisConnection connection) {
                return connection.zRevRangeByScoreWithScores(rawKey, min, max, offset, count);
            }
        }, true);
        return this.deserializeTupleValues(rawValues);
    }

    @Override
    public Long rank(K key, Object o) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawValue = this.rawValue(o);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                Long zRank = connection.zRank(rawKey, rawValue);
                return zRank != null && zRank >= 0L ? zRank : null;
            }
        }, true);
    }

    @Override
    public Long reverseRank(K key, Object o) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawValue = this.rawValue(o);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                Long zRank = connection.zRevRank(rawKey, rawValue);
                return zRank != null && zRank >= 0L ? zRank : null;
            }
        }, true);
    }

    @Override
    public Boolean remove(K key, Object o) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawValue = this.rawValue(o);
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doInRedis(RedisConnection connection) {
                return connection.zRem(rawKey, rawValue);
            }
        }, true);
    }

    @Override
    public Long removeRange(K key, final long start, final long end) {
        final byte[] rawKey = this.rawKey(key);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.zRemRange(rawKey, start, end);
            }
        }, true);
    }

    @Override
    public Long removeRangeByScore(K key, final double min, final double max) {
        final byte[] rawKey = this.rawKey(key);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.zRemRangeByScore(rawKey, min, max);
            }
        }, true);
    }

    @Override
    public Double score(K key, Object o) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawValue = this.rawValue(o);
        return this.execute(new RedisCallback<Double>(){

            @Override
            public Double doInRedis(RedisConnection connection) {
                return connection.zScore(rawKey, rawValue);
            }
        }, true);
    }

    @Override
    public Long count(K key, final double min, final double max) {
        final byte[] rawKey = this.rawKey(key);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.zCount(rawKey, min, max);
            }
        }, true);
    }

    @Override
    public Long size(K key) {
        final byte[] rawKey = this.rawKey(key);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.zCard(rawKey);
            }
        }, true);
    }

    @Override
    public Long unionAndStore(K key, K otherKey, K destKey) {
        return this.unionAndStore(key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    @Override
    public Long unionAndStore(K key, Collection<K> otherKeys, K destKey) {
        final byte[][] rawKeys = this.rawKeys(key, otherKeys);
        final byte[] rawDestKey = this.rawKey(destKey);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.zUnionStore(rawDestKey, rawKeys);
            }
        }, true);
    }
}

