/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.dialect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.springframework.data.r2dbc.dialect.BindMarker;
import org.springframework.data.r2dbc.dialect.BindTarget;
import org.springframework.data.util.Streamable;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class Bindings
implements Streamable<Binding> {
    private static final Bindings EMPTY = new Bindings();
    private final Map<BindMarker, Binding> bindings;

    public Bindings() {
        this.bindings = Collections.emptyMap();
    }

    public Bindings(Collection<Binding> bindings) {
        Assert.notNull(bindings, (String)"Bindings must not be null");
        LinkedHashMap<BindMarker, Binding> mapping = new LinkedHashMap<BindMarker, Binding>(bindings.size());
        bindings.forEach((? super T it) -> mapping.put(it.getBindMarker(), (Binding)it));
        this.bindings = mapping;
    }

    Bindings(Map<BindMarker, Binding> bindings) {
        this.bindings = bindings;
    }

    public static Bindings empty() {
        return EMPTY;
    }

    protected Map<BindMarker, Binding> getBindings() {
        return this.bindings;
    }

    public static Bindings merge(Bindings left, Bindings right) {
        Assert.notNull((Object)left, (String)"Left side Bindings must not be null");
        Assert.notNull((Object)right, (String)"Right side Bindings must not be null");
        ArrayList<Binding> result = new ArrayList<Binding>(left.getBindings().size() + right.getBindings().size());
        result.addAll(left.getBindings().values());
        result.addAll(right.getBindings().values());
        return new Bindings(result);
    }

    public Bindings and(Bindings other) {
        return Bindings.merge(this, other);
    }

    public void apply(BindTarget bindTarget) {
        Assert.notNull((Object)bindTarget, (String)"BindTarget must not be null");
        this.bindings.forEach((? super K marker, ? super V binding) -> binding.apply(bindTarget));
    }

    public void forEach(Consumer<? super Binding> action) {
        this.bindings.forEach((? super K marker, ? super V binding) -> action.accept((Binding)binding));
    }

    public Iterator<Binding> iterator() {
        return this.bindings.values().iterator();
    }

    public Spliterator<Binding> spliterator() {
        return this.bindings.values().spliterator();
    }

    public static class NullBinding
    extends Binding {
        private final Class<?> valueType;

        public NullBinding(BindMarker marker, Class<?> valueType) {
            super(marker);
            this.valueType = valueType;
        }

        @Override
        public boolean hasValue() {
            return false;
        }

        @Override
        @Nullable
        public Object getValue() {
            return null;
        }

        public Class<?> getValueType() {
            return this.valueType;
        }

        @Override
        public void apply(BindTarget bindTarget) {
            this.getBindMarker().bindNull(bindTarget, this.getValueType());
        }
    }

    public static class ValueBinding
    extends Binding {
        private final Object value;

        public ValueBinding(BindMarker marker, Object value) {
            super(marker);
            this.value = value;
        }

        @Override
        public boolean hasValue() {
            return true;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public void apply(BindTarget bindTarget) {
            this.getBindMarker().bind(bindTarget, this.getValue());
        }
    }

    public static abstract class Binding {
        private final BindMarker marker;

        protected Binding(BindMarker marker) {
            this.marker = marker;
        }

        public BindMarker getBindMarker() {
            return this.marker;
        }

        public abstract boolean hasValue();

        public boolean isNull() {
            return !this.hasValue();
        }

        @Nullable
        public abstract Object getValue();

        public abstract void apply(BindTarget var1);
    }
}

