/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.repository.query.Query;
import org.springframework.data.neo4j.repository.query.filter.FilterBuilder;
import org.springframework.lang.Nullable;

class TemplatedQuery {
    private final List<FilterBuilder> filterBuilders;

    static TemplatedQuery unfiltered() {
        return new TemplatedQuery(Collections.emptyList());
    }

    TemplatedQuery(List<FilterBuilder> filterBuilders) {
        this.filterBuilders = filterBuilders;
    }

    Query createExecutableQuery(Map<Integer, Object> resolvedParameters, @Nullable Integer optionalLimit, @Nullable Sort optionalSort) {
        Stack<Object> parametersStack = new Stack<Object>();
        if (!resolvedParameters.isEmpty()) {
            Integer maxParameterIndex = Collections.max(resolvedParameters.keySet());
            for (int i = 0; i <= maxParameterIndex; ++i) {
                parametersStack.add(0, resolvedParameters.get(i));
            }
        }
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (FilterBuilder filterBuilder : this.filterBuilders) {
            filters.addAll(filterBuilder.build(parametersStack));
        }
        return new Query(new Filters(filters), optionalLimit, optionalSort);
    }
}

