/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Optional;
import org.neo4j.ogm.context.SingleUseEntityMapper;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.metadata.reflect.EntityFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.neo4j.annotation.QueryResult;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.config.Neo4jRepositoryConfigurationExtension;
import org.springframework.data.neo4j.repository.query.QueryResultInstantiator;
import org.springframework.data.neo4j.repository.query.QueryResultProxy;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.lang.Nullable;

class CustomResultConverter
implements Converter<Object, Object> {
    private final MetaData metaData;
    private final Class returnedType;
    private final MappingContext<Neo4jPersistentEntity<?>, Neo4jPersistentProperty> mappingContext;

    CustomResultConverter(MetaData metaData, Class<?> returnedType, @Nullable MappingContext<Neo4jPersistentEntity<?>, Neo4jPersistentProperty> mappingContext) {
        this.metaData = metaData;
        this.returnedType = returnedType;
        this.mappingContext = mappingContext;
    }

    public Object convert(Object source) {
        SingleUseEntityMapper mapper;
        if (this.returnedType.getAnnotation(QueryResult.class) == null) {
            return source;
        }
        if (this.returnedType.isInterface()) {
            Class[] interfaces = new Class[]{this.returnedType};
            return Proxy.newProxyInstance(this.returnedType.getClassLoader(), interfaces, (InvocationHandler)new QueryResultProxy((Map)source));
        }
        if (Neo4jRepositoryConfigurationExtension.HAS_ENTITY_INSTANTIATOR_FEATURE) {
            QueryResultInstantiator entityInstantiator = new QueryResultInstantiator(this.metaData, this.mappingContext);
            Optional optionalConstructor = ReflectionUtils.findConstructor(SingleUseEntityMapper.class, (Object[])new Object[]{this.metaData, entityInstantiator});
            Constructor constructor = (Constructor)optionalConstructor.get();
            mapper = (SingleUseEntityMapper)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{this.metaData, entityInstantiator});
        } else {
            mapper = new SingleUseEntityMapper(this.metaData, new EntityFactory(this.metaData));
        }
        return mapper.map(this.returnedType, (Map)source);
    }
}

