/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.traversal;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.rest.graphdb.RequestResult;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.converter.RestResultConverter;
import org.neo4j.rest.graphdb.converter.TypeInformation;
import org.neo4j.rest.graphdb.entity.RestNode;
import org.neo4j.rest.graphdb.entity.RestRelationship;
import org.neo4j.rest.graphdb.traversal.SimplePath;

public class RestPathParser
implements RestResultConverter {
    private RestAPI restAPI;

    public RestPathParser(RestAPI restAPI) {
        this.restAPI = restAPI;
    }

    public static Path parse(Map path, RestAPI restApi) {
        RestPathParser restPathParser = new RestPathParser(restApi);
        TypeInformation typeInfo = new TypeInformation(path.get("nodes"));
        if (restPathParser.isFullPath(typeInfo)) {
            return restPathParser.parseFullPath(path, restApi);
        }
        if (restPathParser.isPath(typeInfo)) {
            return restPathParser.parsePath(path, restApi);
        }
        throw new IllegalArgumentException("params map contained illegal type " + typeInfo.getGenericArguments()[0]);
    }

    private boolean isPath(TypeInformation typeInfo) {
        return typeInfo.getGenericArguments()[0].equals(String.class);
    }

    private boolean isFullPath(TypeInformation typeInfo) {
        return Map.class.isAssignableFrom(typeInfo.getGenericArguments()[0]);
    }

    private Path parseFullPath(Map path, final RestAPI restApi) {
        Collection nodesData = (Collection)path.get("nodes");
        Collection relationshipsData = (Collection)path.get("relationships");
        Map<?, ?> lastRelationshipData = this.lastElementMap(relationshipsData);
        Map startData = (Map)path.get("start");
        Map endData = (Map)path.get("end");
        Integer length = (Integer)path.get("length");
        RestRelationship lastRelationship = lastRelationshipData == null ? null : new RestRelationship(lastRelationshipData, restApi);
        return new SimplePath(new RestNode(startData, restApi), new RestNode(endData, restApi), lastRelationship, length, (Iterable<Node>)new IterableWrapper<Node, Map<?, ?>>(nodesData){

            protected Node underlyingObjectToObject(Map<?, ?> data) {
                return new RestNode(data, restApi);
            }
        }, (Iterable<Relationship>)new IterableWrapper<Relationship, Map<?, ?>>(relationshipsData){

            protected Relationship underlyingObjectToObject(Map<?, ?> data) {
                return new RestRelationship(data, restApi);
            }
        });
    }

    private Path parsePath(Map path, final RestAPI restApi) {
        Collection nodesData = (Collection)path.get("nodes");
        Collection relationshipsData = (Collection)path.get("relationships");
        String lastRelationshipData = this.lastElement(relationshipsData);
        String startData = (String)path.get("start");
        String endData = (String)path.get("end");
        Integer length = (Integer)path.get("length");
        RestRelationship lastRelationship = lastRelationshipData == null ? null : new RestRelationship(lastRelationshipData, restApi);
        return new SimplePath(new RestNode(startData, restApi), new RestNode(endData, restApi), lastRelationship, length, (Iterable<Node>)new IterableWrapper<Node, String>((Iterable)nodesData){

            protected Node underlyingObjectToObject(String data) {
                return new RestNode(data, restApi);
            }
        }, (Iterable<Relationship>)new IterableWrapper<Relationship, String>((Iterable)relationshipsData){

            protected Relationship underlyingObjectToObject(String data) {
                return new RestRelationship(data, restApi);
            }
        });
    }

    private String lastElement(Collection<String> collection) {
        return (String)IteratorUtil.lastOrNull(collection);
    }

    private Map<?, ?> lastElementMap(Collection<Map<?, ?>> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return (Map)list.get(list.size() - 1);
        }
        Map<?, ?> result = null;
        Iterator<Map<?, ?>> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Map<?, ?> value;
            result = value = iterator.next();
        }
        return result;
    }

    @Override
    public Object convertFromRepresentation(RequestResult value) {
        return RestPathParser.parse(value.toMap(), this.restAPI);
    }
}

