/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.query;

import com.sun.jersey.api.client.ClientResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.IteratorWrapper;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.rest.graphdb.ExecutingRestRequest;
import org.neo4j.rest.graphdb.RequestResult;
import org.neo4j.rest.graphdb.RestAPICypherImpl;
import org.neo4j.rest.graphdb.RestRequest;
import org.neo4j.rest.graphdb.query.CypherTransactionExecutionException;

public class CypherTransaction {
    private final ResultType type;
    private String transactionUrl = null;
    private String commitUrl = null;
    private final RestRequest request;
    private final List<Statement> statements = new ArrayList<Statement>(10);

    public CypherTransaction(String baseUri, ResultType type) {
        this.type = type;
        this.request = new ExecutingRestRequest(baseUri);
    }

    public CypherTransaction(RestAPICypherImpl restAPI, ResultType type) {
        this.type = type;
        this.request = restAPI.getRestRequest();
    }

    public void addAll(Statement ... statements) {
        this.statements.addAll(Arrays.asList(statements));
    }

    public void addAll(Collection<Statement> statements) {
        this.statements.addAll(statements);
    }

    public void add(String statement, Map<String, Object> params) {
        this.add(statement, params, false);
    }

    public void add(String statement, Map<String, Object> params, boolean replace) {
        this.statements.add(new Statement(statement, params, this.type, replace));
    }

    public Result send(String statement, Map<String, Object> params) {
        return this.send(statement, params, false);
    }

    public Result send(String statement, Map<String, Object> params, boolean replace) {
        this.add(statement, params, replace);
        List<Result> results = this.send(this.transactionUrl());
        if (results.size() > 0) {
            return results.get(results.size() - 1);
        }
        throw new CypherTransactionExecutionException("Error Sending", Arrays.asList(new Statement(statement, params, this.type, replace)), this.errors("No.Results", "No Results after single send"));
    }

    public Result commit(String statement, Map<String, Object> params) {
        return this.commit(statement, params, false);
    }

    public Result commit(String statement, Map<String, Object> params, boolean replace) {
        this.add(statement, params, replace);
        List<Result> results = this.commit();
        if (results.size() > 0) {
            return results.get(results.size() - 1);
        }
        throw new CypherTransactionExecutionException("Error Sending", Arrays.asList(new Statement(statement, params, this.type, replace)), this.errors("No.Results", "No Results after single commit"));
    }

    public List<Result> send() {
        return this.send(this.transactionUrl());
    }

    public List<Result> commit() {
        try {
            if (this.statements.isEmpty()) {
                this.add("return 1", null, false);
            }
            List<Result> list = this.send(this.commitUrl());
            return list;
        }
        finally {
            this.commitUrl = null;
        }
    }

    private List<Result> send(String url) {
        try {
            RequestResult result = this.request.post(url, MapUtil.map((Object[])new Object[]{"statements", this.statements}));
            if (result.statusIs((Response.StatusType)Response.Status.OK) || result.statusIs((Response.StatusType)Response.Status.CREATED)) {
                ArrayList<Statement> statementsCopy = new ArrayList<Statement>(this.statements);
                List list = Result.toResults(this.handleResult(result, statementsCopy), statementsCopy, this.type);
                return list;
            }
            List<Map<String, String>> errors = this.errors("Http." + result.getStatus(), result.getText());
            throw new CypherTransactionExecutionException("Error executing statements: " + result.getStatus() + " " + result.getText(), this.statements, errors);
        }
        finally {
            this.statements.clear();
        }
    }

    private List<Map<String, String>> errors(String code, String message) {
        return Arrays.asList(MapUtil.stringMap((String[])new String[]{"code", code, "message", message}));
    }

    public void rollback() {
        if (this.transactionUrl != null) {
            this.request.delete(this.transactionUrl);
        }
        this.transactionUrl = null;
        this.commitUrl = null;
    }

    private String commitUrl() {
        return this.commitUrl == null ? "transaction/commit" : this.commitUrl;
    }

    private String transactionUrl() {
        return this.transactionUrl == null ? "transaction" : this.transactionUrl;
    }

    private List<Map> handleResult(RequestResult result, ArrayList<Statement> statements) {
        Map<?, ?> resultData = result.toMap();
        List errors = (List)resultData.get("errors");
        if (result.statusIs((Response.StatusType)ClientResponse.Status.CREATED)) {
            this.transactionUrl = result.getLocation();
        }
        if (errors != null && !errors.isEmpty()) {
            throw new CypherTransactionExecutionException("Error executing cypher statements ", statements, errors);
        }
        this.commitUrl = (String)resultData.get("commit");
        return (List)resultData.get("results");
    }

    public String toString() {
        return "Transaction: " + this.transactionUrl;
    }

    public static class Statement {
        private final String statement;
        private final ResultType type;
        private final Map<String, Object> parameters;
        private final boolean replace;

        public Statement(String query, Map<String, Object> parameters, ResultType type, boolean replace) {
            this.statement = query;
            this.type = type;
            this.replace = replace;
            this.parameters = parameters == null ? Collections.emptyMap() : parameters;
        }

        public String getStatement() {
            return this.statement;
        }

        public Map<String, Object> getParameters() {
            return new LinkedHashMap<String, Object>(this.parameters);
        }

        public List<String> getResultDataContents() {
            return Arrays.asList(this.type.name(), ResultType.graph.name());
        }

        public ResultType getType() {
            return this.type;
        }

        private boolean doReplace() {
            return this.replace;
        }
    }

    public static class Result
    implements Iterable<Map<String, Object>> {
        private final List<String> columns;
        private final Iterable<List<Object>> rows;
        private final Statement statement;

        Result(List<String> columns, Iterable<List<Object>> rows, Statement statement) {
            this.columns = columns;
            this.rows = rows;
            this.statement = statement;
        }

        private static List<Result> toResults(List<Map> resultsData, List<Statement> statements, ResultType type) {
            ArrayList<Result> results = new ArrayList<Result>();
            for (int i = 0; i < resultsData.size(); ++i) {
                results.add(Result.toResult(resultsData.get(i), statements.get(i), type));
            }
            return results;
        }

        private static Result toResult(Map resultData, Statement statement, final ResultType type) {
            List columns = (List)resultData.get("columns");
            List rowsData = (List)resultData.get("data");
            final boolean replace = statement.doReplace();
            IterableWrapper<List<Object>, Map> rows = new IterableWrapper<List<Object>, Map>((Iterable)rowsData){

                protected List<Object> underlyingObjectToObject(Map map) {
                    List<Object> row = type.get(map);
                    List<Object> graph = ResultType.graph.get(map);
                    if (replace) {
                        Result.replaceGraphElements(row, graph);
                    }
                    return row;
                }
            };
            return new Result(columns, (Iterable<List<Object>>)rows, statement);
        }

        private static void replaceGraphElements(List<Object> row, List<Map> graph) {
            for (Map pc : graph) {
                Object props = pc.get("properties");
                int pos = -1;
                for (int i = 0; i < row.size(); ++i) {
                    Object o = row.get(i);
                    if (!props.equals(o)) continue;
                    pos = pos == -1 ? i : -2;
                }
                if (pos < 0) continue;
                row.set(pos, pc);
            }
        }

        public List<String> getColumns() {
            return this.columns;
        }

        public Iterable<List<Object>> getRows() {
            return this.rows;
        }

        public Statement getStatement() {
            return this.statement;
        }

        @Override
        public Iterator<Map<String, Object>> iterator() {
            return new IteratorWrapper<Map<String, Object>, List<Object>>(this.rows.iterator()){

                protected Map<String, Object> underlyingObjectToObject(List<Object> objects) {
                    LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>(Result.this.columns.size());
                    for (int i = 0; i < Result.this.columns.size(); ++i) {
                        row.put((String)Result.this.columns.get(i), objects.get(i));
                    }
                    return row;
                }
            };
        }

        public boolean hasData() {
            return this.rows.iterator().hasNext();
        }
    }

    public static enum ResultType {
        graph{

            @Override
            public List<Object> get(Map data) {
                Map graph = (Map)data.get(this.name());
                ArrayList<Object> result = new ArrayList<Object>((List)graph.get("nodes"));
                result.addAll((List)graph.get("relationships"));
                return result;
            }

            public List<Map> getNodes(Map data) {
                Map graph = (Map)data.get(this.name());
                return (List)graph.get("nodes");
            }

            public List<Map> getRelationships(Map data) {
                Map graph = (Map)data.get(this.name());
                return (List)graph.get("relationships");
            }
        }
        ,
        row,
        rest;


        public List<Object> get(Map data) {
            return (List)data.get(this.name());
        }
    }
}

