/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.index;

import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.index.lucene.QueryContext;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.RestGraphDatabase;

public abstract class RestIndex<T extends PropertyContainer>
implements Index<T> {
    private final String indexName;
    protected final RestAPI restApi;

    public String getIndexName() {
        return this.indexName;
    }

    RestIndex(String indexName, RestAPI restApi) {
        this.indexName = indexName;
        this.restApi = restApi;
    }

    public GraphDatabaseService getGraphDatabase() {
        return new RestGraphDatabase(this.restApi);
    }

    public String getTypeName() {
        return this.getEntityType().getSimpleName().toLowerCase();
    }

    public void add(T entity, String key, Object value) {
        this.restApi.addToIndex(entity, this, key, value);
    }

    public T putIfAbsent(T entity, String key, Object value) {
        return this.restApi.putIfAbsent(entity, this, key, value);
    }

    public void remove(T entity, String key, Object value) {
        this.restApi.removeFromIndex(this, entity, key, value);
    }

    public void remove(T entity, String key) {
        this.restApi.removeFromIndex(this, entity, key);
    }

    public void remove(T entity) {
        this.restApi.removeFromIndex(this, entity);
    }

    public void delete() {
        this.restApi.delete(this);
    }

    public IndexHits<T> get(String key, Object value) {
        return this.restApi.getIndex(this.getEntityType(), this.indexName, key, value);
    }

    public IndexHits<T> query(String key, Object value) {
        return this.restApi.queryIndex(this.getEntityType(), this.indexName, key, value);
    }

    public IndexHits<T> query(Object value) {
        if (value instanceof QueryContext) {
            value = ((QueryContext)value).getQueryOrQueryObject();
        }
        return this.query("null", value);
    }

    public String getName() {
        return this.indexName;
    }
}

