/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.batch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.rest.graphdb.RequestResult;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.RestResultException;
import org.neo4j.rest.graphdb.batch.RecordingRestRequest;
import org.neo4j.rest.graphdb.batch.RestOperations;
import org.neo4j.rest.graphdb.converter.RestEntityExtractor;
import org.neo4j.rest.graphdb.entity.RestNode;

public class BatchRestAPI {
    private final RecordingRestRequest restRequest;
    private final String baseUri;
    private final RestAPI restApi;

    public BatchRestAPI(RestAPI restApi) {
        this.baseUri = restApi.getBaseUri();
        this.restApi = restApi;
        RestEntityExtractor converter = new RestEntityExtractor(restApi);
        this.restRequest = new RecordingRestRequest(new RestOperations(converter), restApi.getBaseUri());
    }

    public void stop() {
        this.restRequest.stop();
    }

    public RestNode getNodeById(long id) {
        RestOperations.RestOperation nodeRequest = this.restRequest.get("node/" + id);
        RestOperations.RestOperation labelsRequest = this.restRequest.get("node/" + id + "/labels");
        try {
            Map<Long, Object> results = this.executeBatchRequest();
            RestNode node = (RestNode)results.get(nodeRequest.getBatchId());
            List labels = (List)results.get(labelsRequest.getBatchId());
            node.setLabels(labels);
            return node;
        }
        catch (RestResultException rre) {
            if (rre.getMessage().contains("NodeNotFoundException")) {
                throw new NotFoundException("Node not found: " + id);
            }
            throw rre;
        }
    }

    public Map<Long, Object> executeBatchRequest() {
        this.stop();
        RestOperations operations = this.restRequest.getOperations();
        RequestResult response = this.restApi.batch(this.createBatchRequestData(operations));
        return this.convertRequestResultToEntities(operations, response);
    }

    protected Map<Long, Object> convertRequestResultToEntities(RestOperations operations, RequestResult response) {
        Object result = response.toEntity();
        if (RestResultException.isExceptionResult(result)) {
            throw new RestResultException(result, new String[0]);
        }
        Collection responseCollection = (Collection)result;
        HashMap<Long, Object> mappedObjects = new HashMap<Long, Object>(responseCollection.size());
        for (Map entry : responseCollection) {
            if (RestResultException.isExceptionResult(entry)) {
                throw new RestResultException(entry, new String[0]);
            }
            Long batchId = this.getBatchId(entry);
            RequestResult subResult = RequestResult.extractFrom(entry);
            RestOperations.RestOperation restOperation = operations.getOperation(batchId);
            Object entity = restOperation.getResultConverter().convertFromRepresentation(subResult);
            mappedObjects.put(batchId, entity);
        }
        return mappedObjects;
    }

    private Long getBatchId(Map<String, Object> entry) {
        return ((Number)entry.get("id")).longValue();
    }

    protected Collection<Map<String, Object>> createBatchRequestData(RestOperations operations) {
        ArrayList<Map<String, Object>> batch = new ArrayList<Map<String, Object>>();
        for (RestOperations.RestOperation operation : operations.getRecordedRequests().values()) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("method", (Object)operation.getMethod());
            if (operation.isSameUri(this.baseUri)) {
                params.put("to", operation.getUri());
            } else {
                params.put("to", this.createOperationUri(operation));
            }
            if (operation.getData() != null) {
                params.put("body", operation.getData());
            }
            params.put("id", operation.getBatchId());
            batch.add(params);
        }
        return batch;
    }

    private String createOperationUri(RestOperations.RestOperation operation) {
        String uri = operation.getBaseUri();
        String suffix = operation.getUri();
        if (suffix.startsWith("/")) {
            return uri + suffix;
        }
        return uri + "/" + suffix;
    }
}

