/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.lucene.ValueContext;
import org.neo4j.rest.graphdb.ExecutingRestRequest;
import org.neo4j.rest.graphdb.RequestResult;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.RestAPIInternal;
import org.neo4j.rest.graphdb.RestRequest;
import org.neo4j.rest.graphdb.RestResultException;
import org.neo4j.rest.graphdb.converter.RelationshipIterableConverter;
import org.neo4j.rest.graphdb.converter.RestEntityExtractor;
import org.neo4j.rest.graphdb.converter.RestIndexHitsConverter;
import org.neo4j.rest.graphdb.entity.RestEntity;
import org.neo4j.rest.graphdb.entity.RestEntityCache;
import org.neo4j.rest.graphdb.entity.RestNode;
import org.neo4j.rest.graphdb.entity.RestRelationship;
import org.neo4j.rest.graphdb.index.IndexInfo;
import org.neo4j.rest.graphdb.index.RestIndex;
import org.neo4j.rest.graphdb.index.RestIndexManager;
import org.neo4j.rest.graphdb.index.RetrievedIndexInfo;
import org.neo4j.rest.graphdb.index.SimpleIndexHits;
import org.neo4j.rest.graphdb.query.CypherRestResult;
import org.neo4j.rest.graphdb.query.CypherResult;
import org.neo4j.rest.graphdb.query.RestQueryResult;
import org.neo4j.rest.graphdb.transaction.NullTransaction;
import org.neo4j.rest.graphdb.traversal.RestDirection;
import org.neo4j.rest.graphdb.traversal.RestTraversal;
import org.neo4j.rest.graphdb.traversal.RestTraversalDescription;
import org.neo4j.rest.graphdb.traversal.RestTraverser;
import org.neo4j.rest.graphdb.util.JsonHelper;
import org.neo4j.rest.graphdb.util.QueryResult;
import org.neo4j.rest.graphdb.util.ResultConverter;

public class RestAPIImpl
implements RestAPI {
    public static final String _QUERY_RETURN_NODE = " RETURN id(n) as id, labels(n) as labels, n as data";
    public static final String GET_REL_TYPES_QUERY = "MATCH (n)-[r]-() WHERE id(n) = {id} RETURN distinct type(r) as relType";
    private static final String[] NO_LABELS = new String[0];
    protected RestRequest restRequest;
    private long entityRefetchTimeInMillis = TimeUnit.SECONDS.toMillis(1000L);
    private final RestEntityCache entityCache = new RestEntityCache(this);
    private RestEntityExtractor restEntityExtractor = new RestEntityExtractor(this);
    private RestIndexManager restIndexManager = new RestIndexManager(this);
    private Map<String, IndexInfo> indexInfos = new HashMap<String, IndexInfo>();
    private static final String FULLPATH = "fullpath";

    public RestAPIImpl(String uri) {
        this.restRequest = this.createRestRequest(uri, null, null);
    }

    public RestAPIImpl(String uri, String user, String password) {
        this.restRequest = this.createRestRequest(uri, user, password);
    }

    protected RestRequest createRestRequest(String uri, String user, String password) {
        return new ExecutingRestRequest(uri, user, password);
    }

    @Override
    public RestIndexManager index() {
        return this.restIndexManager;
    }

    @Override
    public RestNode getNodeById(long id, RestAPIInternal.Load force) {
        RestNode node;
        RestNode restNode;
        if (force != RestAPIInternal.Load.ForceFromServer && (restNode = this.entityCache.getNode(id)) != null) {
            return restNode;
        }
        if (force == RestAPIInternal.Load.FromCache) {
            return new RestNode(RestNode.nodeUri(this, id), (RestAPI)this);
        }
        RequestResult response = this.restRequest.get("node/" + id);
        if (response.statusIs((Response.StatusType)Response.Status.NOT_FOUND)) {
            throw new NotFoundException("" + id);
        }
        Map<String, Object> data = response.toMap();
        if (response.isMap() && data.containsKey("metadata")) {
            node = new RestNode(data, (RestAPI)this);
        } else {
            Collection<String> labels = this.getNodeLabels(id);
            node = new RestNode(id, labels, data, this);
        }
        return this.entityCache.addToCache(node);
    }

    @Override
    public RestRelationship getRelationshipById(long id, RestAPIInternal.Load force) {
        RestRelationship restRel;
        if (force != RestAPIInternal.Load.ForceFromServer && (restRel = this.entityCache.getRelationship(id)) != null) {
            return restRel;
        }
        if (force == RestAPIInternal.Load.FromCache) {
            return new RestRelationship(RestRelationship.relUri(this, id), (RestAPI)this);
        }
        RequestResult response = this.restRequest.get("relationship/" + id);
        if (response.statusIs((Response.StatusType)Response.Status.NOT_FOUND)) {
            throw new NotFoundException("" + id);
        }
        Map<?, ?> data = response.toMap();
        RestRelationship rel = new RestRelationship(data, (RestAPI)this);
        return this.entityCache.addToCache(rel);
    }

    @Override
    public RestNode addToCache(RestNode restNode) {
        return this.entityCache.addToCache(restNode);
    }

    @Override
    public RestRelationship addToCache(RestRelationship rel) {
        return this.entityCache.addToCache(rel);
    }

    @Override
    public RestNode getNodeFromCache(long id) {
        return this.entityCache.getNode(id);
    }

    @Override
    public RestRelationship getRelFromCache(long id) {
        return this.entityCache.getRelationship(id);
    }

    @Override
    public void removeNodeFromCache(long id) {
        this.entityCache.removeNode(id);
    }

    @Override
    public void removeRelFromCache(long id) {
        this.entityCache.removeRelationship(id);
    }

    @Override
    public RestNode getNodeById(long id) {
        return this.getNodeById(id, RestAPIInternal.Load.FromServer);
    }

    @Override
    public RestRelationship getRelationshipById(long id) {
        return this.getRelationshipById(id, RestAPIInternal.Load.FromServer);
    }

    @Override
    public RestNode createNode(Map<String, Object> props) {
        return this.createNode(props, Collections.emptyList());
    }

    @Override
    public RestNode createNode(Map<String, Object> props, Collection<String> labels) {
        RequestResult result = this.restRequest.post("node", props);
        RestNode node = this.createRestNode(result);
        if (node == null) {
            throw RestResultException.create(result, new String[0]);
        }
        this.addLabels(node, labels);
        node.setLabels(labels);
        return this.entityCache.addToCache(node);
    }

    @Override
    public RestNode getOrCreateNode(RestIndex<Node> index, String key, Object value, Map<String, Object> properties, Collection<String> labels) {
        if (index == null || key == null || value == null) {
            throw new IllegalArgumentException("Unique index " + index + " key " + key + " value must not be null");
        }
        Map data = MapUtil.map((Object[])new Object[]{"key", key, "value", value, "properties", properties});
        RequestResult result = this.getRestRequest().post(this.uniqueIndexPath(index), data);
        if (result.statusIs((Response.StatusType)Response.Status.CREATED) || result.statusIs((Response.StatusType)Response.Status.OK)) {
            RestNode node = (RestNode)this.getEntityExtractor().convertFromRepresentation(result);
            this.addLabels(node, labels);
            node.setLabels(labels);
            return this.entityCache.addToCache(node);
        }
        throw new RuntimeException(String.format("Error retrieving or creating node for key %s and value %s with index %s", key, value, index.getIndexName()));
    }

    private String toLabelString(String[] labels) {
        if (labels == null || labels.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String label : labels) {
            sb.append(":").append(label);
        }
        return sb.toString();
    }

    private RestNode createRestNode(RequestResult result) {
        if (result.statusIs((Response.StatusType)Response.Status.NOT_FOUND)) {
            throw new NotFoundException("Node not found");
        }
        RestNode node = null;
        if (result.statusIs((Response.StatusType)Response.Status.CREATED)) {
            RestNode restNode = node = result.isMap() ? new RestNode(result.toMap(), (RestAPI)this) : new RestNode(result.getLocation(), (RestAPI)this);
        }
        if (node == null && result.statusIs((Response.StatusType)Response.Status.OK)) {
            node = new RestNode(result.toMap(), (RestAPI)this);
        }
        return this.entityCache.addToCache(node);
    }

    @Override
    public RestRelationship createRelationship(Node startNode, Node endNode, RelationshipType type, Map<String, Object> props) {
        RestNode end = (RestNode)endNode;
        Map data = MapUtil.map((Object[])new Object[]{"to", end.getUri(), "type", type.name()});
        if (props != null && props.size() > 0) {
            data.put("data", props);
        }
        RestNode start = (RestNode)startNode;
        RequestResult requestResult = this.getRestRequest().with(start.getUri()).post("relationships", data);
        return this.createRestRelationship(requestResult, (PropertyContainer)startNode);
    }

    private RestRelationship createRestRelationship(RequestResult requestResult, PropertyContainer element) {
        if (requestResult.statusOtherThan((Response.StatusType)Response.Status.CREATED)) {
            int status = requestResult.getStatus();
            throw new RuntimeException("Error creating relationship " + status + " " + requestResult.getText());
        }
        String location = requestResult.getLocation();
        if (requestResult.isMap()) {
            return new RestRelationship(requestResult.toMap(), (RestAPI)this);
        }
        return new RestRelationship(location, (RestAPI)this);
    }

    @Override
    public <T extends PropertyContainer> RestIndex<T> getIndex(String indexName) {
        RestIndexManager index = this.index();
        if (index.existsForNodes(indexName)) {
            return index.forNodes(indexName);
        }
        if (index.existsForRelationships(indexName)) {
            return (RestIndex)index.forRelationships(indexName);
        }
        throw new IllegalArgumentException("Index " + indexName + " does not yet exist");
    }

    @Override
    public void createIndex(String type, String indexName, Map<String, String> config) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("name", indexName);
        data.put("config", config);
        this.restRequest.post("index/" + type, data);
        IndexInfo indexInfo = this.indexInfos.get(type);
        if (indexInfo != null) {
            indexInfo.setExpired();
        }
    }

    @Override
    public void resetIndex(Class type) {
        if (Node.class.isAssignableFrom(type)) {
            this.indexInfo("node").setExpired();
        }
        if (Relationship.class.isAssignableFrom(type)) {
            this.indexInfo("relationship").setExpired();
        }
    }

    @Override
    public <T extends PropertyContainer> RestIndex<T> createIndex(Class<T> type, String indexName, Map<String, String> config) {
        this.resetIndex(type);
        if (Node.class.isAssignableFrom(type)) {
            return this.index().forNodes(indexName, (Map)config);
        }
        if (Relationship.class.isAssignableFrom(type)) {
            return (RestIndex)this.index().forRelationships(indexName, config);
        }
        throw new IllegalArgumentException("Required Node or Relationship types to create index, got " + type);
    }

    @Override
    public void close() {
        ExecutingRestRequest.shutdown();
    }

    @Override
    public Relationship getOrCreateRelationship(Node start, Node end, RelationshipType type, Direction direction, Map<String, Object> props) {
        Iterable existingRelationships = start.getRelationships(type, direction);
        for (Relationship existingRelationship : existingRelationships) {
            if (existingRelationship == null || !existingRelationship.getOtherNode(start).equals(end)) continue;
            return existingRelationship;
        }
        if (direction == Direction.INCOMING) {
            return this.createRelationship(end, start, type, props);
        }
        return this.createRelationship(start, end, type, props);
    }

    protected Collection<Node> removeMissingRelationships(Node node, Collection<Node> targetNodes, RelationshipType type, Direction direction, Label targetLabel) {
        targetNodes = new ArrayList<Node>(targetNodes);
        for (Relationship relationship : node.getRelationships(type, direction)) {
            Node otherNode = relationship.getOtherNode(node);
            if (targetNodes.remove(otherNode) || targetLabel != null && !relationship.getOtherNode(node).hasLabel(targetLabel)) continue;
            relationship.delete();
        }
        return targetNodes;
    }

    @Override
    public Iterable<Relationship> updateRelationships(Node start, Collection<Node> endNodes, RelationshipType type, Direction direction, String targetLabelName) {
        Label targetLabel = targetLabelName == null ? null : DynamicLabel.label((String)targetLabelName);
        Collection<Node> remainingEndNodes = this.removeMissingRelationships(start, endNodes, type, direction, targetLabel);
        ArrayList<Relationship> result = new ArrayList<Relationship>(remainingEndNodes.size());
        for (Node endNode : remainingEndNodes) {
            result.add(this.getOrCreateRelationship(start, endNode, type, direction, null));
        }
        return result;
    }

    @Override
    public RestNode merge(String labelName, String key, Object value, Map<String, Object> nodeProperties, Collection<String> labels) {
        if (labelName == null || key == null || value == null) {
            throw new IllegalArgumentException("Label " + labelName + " key " + key + " and value must not be null");
        }
        Map props = nodeProperties.containsKey(key) ? nodeProperties : MapUtil.copyAndPut(nodeProperties, (Object)key, (Object)value);
        Map params = MapUtil.map((Object[])new Object[]{"props", props, "value", value});
        Iterator<List<Object>> result = this.query(this.mergeQuery(labelName, key, labels), params).getData().iterator();
        if (!result.hasNext()) {
            throw new RuntimeException("Error merging node with labels: " + labelName + " key " + key + " value " + value + " labels " + labels + " and props: " + props + " no data returned");
        }
        return this.entityCache.addToCache(this.toNode(result.next()));
    }

    private String mergeQuery(String labelName, String key, Collection<String> labels) {
        StringBuilder setLabels = new StringBuilder();
        if (labels != null) {
            for (String label : labels) {
                if (label.equals(labelName)) continue;
                setLabels.append("SET n:").append(label).append(" ");
            }
        }
        return "MERGE (n:`" + labelName + "` {`" + key + "`: {value}}) ON CREATE SET n={props} " + setLabels + _QUERY_RETURN_NODE;
    }

    @Override
    public boolean isAutoIndexingEnabled(Class<? extends PropertyContainer> clazz) {
        RequestResult response = this.getRestRequest().get(this.buildPathAutoIndexerStatus(clazz));
        if (response.statusIs((Response.StatusType)Response.Status.OK)) {
            return Boolean.parseBoolean(response.getText());
        }
        throw new IllegalStateException("received " + response);
    }

    @Override
    public void setAutoIndexingEnabled(Class<? extends PropertyContainer> clazz, boolean enabled) {
        RequestResult response = this.getRestRequest().put(this.buildPathAutoIndexerStatus(clazz), enabled);
        if (response.statusOtherThan((Response.StatusType)Response.Status.NO_CONTENT)) {
            throw new IllegalStateException("received " + response);
        }
    }

    @Override
    public Set<String> getAutoIndexedProperties(Class forClass) {
        RequestResult response = this.getRestRequest().get(this.buildPathAutoIndexerProperties(forClass).toString());
        Collection autoIndexedProperties = (Collection)JsonHelper.readJson(response.getText());
        return new HashSet<String>(autoIndexedProperties);
    }

    @Override
    public void startAutoIndexingProperty(Class forClass, String s) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(s.getBytes("UTF-8"));
            RequestResult response = this.getRestRequest().post(this.buildPathAutoIndexerProperties(forClass).toString(), stream);
            if (response.statusOtherThan((Response.StatusType)Response.Status.NO_CONTENT)) {
                throw new IllegalStateException("received " + response);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void stopAutoIndexingProperty(Class forClass, String s) {
        RequestResult response = this.getRestRequest().delete(this.buildPathAutoIndexerProperties(forClass).append("/").append(s).toString());
        if (response.statusOtherThan((Response.StatusType)Response.Status.NO_CONTENT)) {
            throw new IllegalStateException("received " + response);
        }
    }

    @Override
    public void removeLabel(RestNode node, String label) {
        RequestResult response = this.getRestRequest().with(node.getUri()).delete("labels/" + ExecutingRestRequest.encode(label));
        if (response.statusOtherThan((Response.StatusType)Response.Status.NO_CONTENT)) {
            throw new IllegalStateException("received " + response);
        }
    }

    public Collection<String> getNodeLabels(long id) {
        RequestResult response = this.restRequest.get(RestNode.nodeUri(this, id) + "/labels");
        if (response.statusOtherThan((Response.StatusType)Response.Status.OK)) {
            throw new IllegalStateException("received " + response);
        }
        return (Collection)response.toEntity();
    }

    @Override
    public Collection<String> getAllLabelNames() {
        RequestResult response = this.restRequest.get("labels");
        if (response.statusOtherThan((Response.StatusType)Response.Status.OK)) {
            throw new IllegalStateException("received " + response);
        }
        return (Collection)response.toEntity();
    }

    @Override
    public Iterable<RestNode> getNodesByLabel(String label) {
        RequestResult response = this.getRestRequest().get("label/" + ExecutingRestRequest.encode(label) + "/nodes");
        if (response.statusOtherThan((Response.StatusType)Response.Status.OK)) {
            throw new IllegalStateException("received " + response);
        }
        return (Iterable)this.getEntityExtractor().convertFromRepresentation(response);
    }

    private RestNode toNode(List<Object> row) {
        long id = ((Number)row.get(0)).longValue();
        List labels = (List)row.get(1);
        Map restData = (Map)row.get(2);
        return new RestNode(id, labels, restData, this);
    }

    private Iterable<RestNode> queryForNodes(String statement, Map<String, Object> params) {
        Iterable<List<Object>> result = this.query(statement, params).getData();
        return new IterableWrapper<RestNode, List<Object>>(result){

            protected RestNode underlyingObjectToObject(List<Object> row) {
                return RestAPIImpl.this.entityCache.addToCache(RestAPIImpl.this.toNode(row));
            }
        };
    }

    @Override
    public Iterable<RestNode> getNodesByLabelAndProperty(String label, String property, Object value) {
        String statement = "MATCH (n:`" + label + "`) WHERE n.`" + property + "` = {value} " + _QUERY_RETURN_NODE;
        return this.queryForNodes(statement, MapUtil.map((Object[])new Object[]{"value", value}));
    }

    @Override
    public Iterable<RelationshipType> getRelationshipTypes(RestNode node) {
        Iterable<List<Object>> result = this.query(GET_REL_TYPES_QUERY, MapUtil.map((Object[])new Object[]{"id", node.getId()})).getData();
        return new IterableWrapper<RelationshipType, List<Object>>(result){

            protected RelationshipType underlyingObjectToObject(List<Object> row) {
                return DynamicRelationshipType.withName((String)row.get(0).toString());
            }
        };
    }

    @Override
    public int getDegree(RestNode restNode, RelationshipType type, Direction direction) {
        String relPattern = "--";
        if (type != null) {
            relPattern = "-[:`" + type + "`]-";
        }
        if (direction == Direction.OUTGOING) {
            relPattern = relPattern + ">";
        } else if (direction == Direction.INCOMING) {
            relPattern = "<" + relPattern;
        }
        String nodeDegreeQuery = "MATCH (n)" + relPattern + "() WHERE id(n) = {id} RETURN count(*) as degree";
        Iterator<List<Object>> degree = this.query(nodeDegreeQuery, MapUtil.map((Object[])new Object[]{"id", restNode.getId()})).getData().iterator();
        if (!degree.hasNext()) {
            return 0;
        }
        return ((Number)degree.next().get(0)).intValue();
    }

    @Override
    public Iterable<RelationshipType> getRelationshipTypes() {
        Object result = this.restRequest.get("relationship/types").toEntity();
        if (!(result instanceof Iterable)) {
            throw new RuntimeException("Error loading relationship types");
        }
        return new IterableWrapper<RelationshipType, Object>((Iterable)result){

            protected RelationshipType underlyingObjectToObject(Object type) {
                return DynamicRelationshipType.withName((String)type.toString());
            }
        };
    }

    @Override
    public void addLabels(RestNode node, Collection<String> labels) {
        if (labels == null || labels.isEmpty()) {
            return;
        }
        RequestResult response = this.getRestRequest().with(node.getUri()).post("labels", labels);
        if (response.statusOtherThan((Response.StatusType)Response.Status.NO_CONTENT)) {
            throw new IllegalStateException("error adding labels, received " + response);
        }
    }

    private String buildPathAutoIndexerStatus(Class<? extends PropertyContainer> clazz) {
        return this.buildPathAutoIndexerBase(clazz).append("/status").toString();
    }

    private StringBuilder buildPathAutoIndexerProperties(Class<? extends PropertyContainer> clazz) {
        return this.buildPathAutoIndexerBase(clazz).append("/properties");
    }

    private StringBuilder buildPathAutoIndexerBase(Class<? extends PropertyContainer> clazz) {
        return new StringBuilder().append("index/auto/").append(this.indexTypeName(clazz));
    }

    @Override
    public RestRequest getRestRequest() {
        return this.restRequest;
    }

    @Override
    public RestTraversalDescription createTraversalDescription() {
        return RestTraversal.description();
    }

    @Override
    public Transaction beginTx() {
        return new NullTransaction();
    }

    public long getEntityRefetchTimeInMillis() {
        return this.entityRefetchTimeInMillis;
    }

    @Override
    public String getBaseUri() {
        return this.restRequest.getUri();
    }

    public void setEntityRefetchTimeInMillis(long entityRefetchTimeInMillis) {
        this.entityRefetchTimeInMillis = entityRefetchTimeInMillis;
    }

    public Iterable<Relationship> wrapRelationships(RequestResult requestResult) {
        return (Iterable)new RelationshipIterableConverter(this).convertFromRepresentation(requestResult);
    }

    @Override
    public RestEntityExtractor getEntityExtractor() {
        return this.restEntityExtractor;
    }

    public String indexPath(Class entityType, String indexName, String key, Object value) {
        String typeName = this.indexTypeName(entityType);
        return "index/" + typeName + "/" + ExecutingRestRequest.encode(indexName) + (key != null ? "/" + ExecutingRestRequest.encode(key) : "") + (value != null ? "/" + ExecutingRestRequest.encode(value) : "");
    }

    private String indexTypeName(Class entityType) {
        return entityType.getSimpleName().toLowerCase();
    }

    public String indexPath(Class entityType, String indexName) {
        return "index/" + this.indexTypeName(entityType) + "/" + ExecutingRestRequest.encode(indexName);
    }

    private String queryPath(Class entityType, String indexName, String key, Object value) {
        return this.indexPath(entityType, indexName, key, null) + "?query=" + ExecutingRestRequest.encode(value);
    }

    @Override
    public <S extends PropertyContainer> IndexHits<S> getIndex(Class<S> entityType, String indexName, String key, Object value) {
        String indexPath = this.indexPath(entityType, indexName, key, value);
        RequestResult response = this.restRequest.get(indexPath);
        if (response.statusIs((Response.StatusType)Response.Status.OK)) {
            return new RestIndexHitsConverter<S>(this, entityType).convertFromRepresentation(response);
        }
        return new SimpleIndexHits<S>(Collections.emptyList(), 0, entityType, this);
    }

    @Override
    public <S extends PropertyContainer> IndexHits<S> queryIndex(Class<S> entityType, String indexName, String key, Object value) {
        String indexPath = this.queryPath(entityType, indexName, key, value);
        RequestResult response = this.restRequest.get(indexPath);
        if (response.statusIs((Response.StatusType)Response.Status.OK)) {
            return new RestIndexHitsConverter<S>(this, entityType).convertFromRepresentation(response);
        }
        return new SimpleIndexHits<S>(Collections.emptyList(), 0, entityType, this);
    }

    @Override
    public void deleteEntity(RestEntity entity) {
        this.getRestRequest().with(entity.getUri()).delete("");
        this.entityCache.removeNode(entity.getId());
    }

    @Override
    public IndexInfo indexInfo(String indexType) {
        IndexInfo indexInfo = this.indexInfos.get(indexType);
        if (indexInfo != null && !indexInfo.isExpired()) {
            return indexInfo;
        }
        RequestResult response = this.restRequest.get("index/" + ExecutingRestRequest.encode(indexType));
        indexInfo = new RetrievedIndexInfo(response);
        this.indexInfos.put(indexType, indexInfo);
        return indexInfo;
    }

    @Override
    public void setPropertyOnEntity(RestEntity entity, String key, Object value) {
        RequestResult result = this.getRestRequest().with(entity.getUri()).put("properties/" + ExecutingRestRequest.encode(key), value);
        if (result.statusOtherThan((Response.StatusType)Response.Status.NO_CONTENT)) {
            throw new RuntimeException("Error setting properties on entity " + entity + " properties " + key + " : " + value);
        }
    }

    @Override
    public void setPropertiesOnEntity(RestEntity entity, Map<String, Object> properties) {
        RequestResult result = this.getRestRequest().with(entity.getUri()).put("properties", properties);
        if (result.statusOtherThan((Response.StatusType)Response.Status.NO_CONTENT)) {
            throw new RuntimeException("Error setting properties on entity " + entity + " properties " + properties);
        }
    }

    private Map<String, Object> getPropertiesFromEntity(RestEntity entity) {
        RequestResult response = this.getRestRequest().with(entity.getUri()).get("properties");
        boolean ok = response.statusIs((Response.StatusType)Response.Status.OK);
        Map<Object, Object> properties = ok ? response.toMap() : Collections.emptyMap();
        return properties;
    }

    private void deleteIndex(String indexPath) {
        this.getRestRequest().delete(indexPath);
    }

    @Override
    public void delete(RestIndex index) {
        this.deleteIndex(this.indexPath(index, null, null));
        this.resetIndex(index.getEntityType());
    }

    @Override
    public <T extends PropertyContainer> void removeFromIndex(RestIndex index, T entity, String key, Object value) {
        String indexPath = this.indexPath(index, key, value);
        this.deleteIndex(this.indexPath(indexPath, entity));
        this.resetIndex(index.getEntityType());
    }

    protected <T extends PropertyContainer> String indexPath(String indexPath, T restEntity) {
        return indexPath + "/" + ((RestEntity)restEntity).getId();
    }

    @Override
    public <T extends PropertyContainer> void removeFromIndex(RestIndex index, T entity, String key) {
        String indexPath = this.indexPath(index, key, null);
        this.deleteIndex(this.indexPath(indexPath, entity));
        this.resetIndex(index.getEntityType());
    }

    private String indexPath(RestIndex index, String key, Object value) {
        return this.indexPath(index.getEntityType(), index.getIndexName(), key, value);
    }

    @Override
    public <T extends PropertyContainer> void removeFromIndex(RestIndex index, T entity) {
        this.deleteIndex(this.indexPath(this.indexPath(index, null, null), entity));
        this.resetIndex(index.getEntityType());
    }

    public String uniqueIndexPath(RestIndex index) {
        return this.indexPath(index, null, null) + "?uniqueness=get_or_create";
    }

    @Override
    public <T extends PropertyContainer> void addToIndex(T entity, RestIndex index, String key, Object value) {
        RestEntity restEntity = (RestEntity)entity;
        String uri = restEntity.getUri();
        if (value instanceof ValueContext) {
            value = ((ValueContext)value).getCorrectValue();
        }
        Map data = MapUtil.map((Object[])new Object[]{"key", key, "value", value, "uri", uri});
        RequestResult result = this.getRestRequest().post(this.indexPath(index, null, null), data);
        if (result.statusOtherThan((Response.StatusType)Response.Status.CREATED)) {
            throw new RuntimeException(String.format("Error adding element %d %s %s to index %s", restEntity.getId(), key, value, index.getIndexName()));
        }
    }

    @Override
    public <T extends PropertyContainer> T putIfAbsent(T entity, RestIndex index, String key, Object value) {
        RestEntity restEntity = (RestEntity)entity;
        restEntity.flush();
        String uri = restEntity.getUri();
        if (value instanceof ValueContext) {
            value = ((ValueContext)value).getCorrectValue();
        }
        Map data = MapUtil.map((Object[])new Object[]{"key", key, "value", value, "uri", uri});
        RequestResult result = this.getRestRequest().post(this.uniqueIndexPath(index), data);
        if (result.statusIs((Response.StatusType)Response.Status.CREATED)) {
            if (index.getEntityType().equals(Node.class)) {
                return (T)this.createRestNode(result);
            }
            if (index.getEntityType().equals(Relationship.class)) {
                return (T)this.createRestRelationship(result, restEntity);
            }
        }
        if (result.statusIs((Response.StatusType)Response.Status.OK)) {
            return (T)((PropertyContainer)this.getEntityExtractor().convertFromRepresentation(result));
        }
        throw new RuntimeException(String.format("Error adding element %d %s %s to index %s", restEntity.getId(), key, value, index.getIndexName()));
    }

    @Override
    public boolean hasToUpdate(long lastUpdate) {
        return this.timeElapsed(lastUpdate, this.getEntityRefetchTimeInMillis());
    }

    @Override
    public void removeProperty(RestEntity entity, String key) {
        this.restRequest.with(entity.getUri()).delete("properties/" + ExecutingRestRequest.encode(key));
    }

    private boolean timeElapsed(long since, long isItGreaterThanThis) {
        return System.currentTimeMillis() - since > isItGreaterThanThis;
    }

    @Override
    public RestRelationship getOrCreateRelationship(RestIndex<Relationship> index, String key, Object value, RestNode start, RestNode end, String type, Map<String, Object> properties) {
        if (index == null || key == null || value == null) {
            throw new IllegalArgumentException("Unique index " + index + " key " + key + " value must not be null");
        }
        if (start == null || end == null || type == null) {
            throw new IllegalArgumentException("Neither start, end nore type must be null");
        }
        Map data = MapUtil.map((Object[])new Object[]{"key", key, "value", value, "properties", properties, "start", start.getUri(), "end", end.getUri(), "type", type});
        RequestResult result = this.getRestRequest().post(this.uniqueIndexPath(index), data);
        if (result.statusIs((Response.StatusType)Response.Status.CREATED) || result.statusIs((Response.StatusType)Response.Status.OK)) {
            return (RestRelationship)this.getEntityExtractor().convertFromRepresentation(result);
        }
        throw new RuntimeException(String.format("Error retrieving or creating relationship for key %s and value %s with index %s", key, value, index.getIndexName()));
    }

    @Override
    public CypherResult query(String statement, Map<String, Object> params) {
        params = params == null ? Collections.emptyMap() : params;
        RequestResult requestResult = this.getRestRequest().post("cypher", MapUtil.map((Object[])new Object[]{"query", statement, "params", params}));
        return new CypherRestResult(requestResult);
    }

    @Override
    public Iterable<Relationship> getRelationships(RestNode restNode, Direction direction, RelationshipType ... types) {
        String path = types.length > 1 ? this.relPath(types) : this.relPath(direction, types.length == 0 ? null : types[0]);
        return this.wrapRelationships(this.getRestRequest().with(restNode.getUri()).get(path));
    }

    private String relPath(RelationshipType ... types) {
        String path = "relationships/all/";
        int counter = 0;
        for (RelationshipType type : types) {
            if (counter++ > 0) {
                path = path + "&";
            }
            path = path + ExecutingRestRequest.encode(type.name());
        }
        return path;
    }

    private String relPath(Direction direction, RelationshipType type) {
        String path = "relationships/" + RestDirection.from((Direction)direction).shortName;
        return type == null ? path : path + "/" + ExecutingRestRequest.encode(type.name());
    }

    @Override
    public RestTraverser traverse(RestNode restNode, Map<String, Object> description) {
        RequestResult result = this.getRestRequest().with(restNode.getUri()).post("traverse/fullpath", description);
        if (result.statusOtherThan((Response.StatusType)Response.Status.OK)) {
            throw new RuntimeException(String.format("Error executing traversal: %d %s", result.getStatus(), description));
        }
        Object col = result.toEntity();
        if (!(col instanceof Collection)) {
            throw new RuntimeException(String.format("Unexpected traversal result, %s instead of collection", col != null ? col.getClass() : null));
        }
        return new RestTraverser((Collection)col, restNode.getRestApi());
    }

    @Override
    public QueryResult<Map<String, Object>> query(String statement, Map<String, Object> params, ResultConverter resultConverter) {
        CypherResult result = this.query(statement, params);
        if (RestResultException.isExceptionResult(result.asMap())) {
            throw new RestResultException(result.asMap(), new String[0]);
        }
        return RestQueryResult.toQueryResult(result, this, resultConverter);
    }

    @Override
    public RestEntity createRestEntity(Map data) {
        String uri;
        if (data.containsKey("id") && data.containsKey("properties")) {
            long id = this.asLong(data, "id");
            Map props = (Map)data.get("properties");
            if (data.containsKey("type")) {
                return RestRelationship.fromCypher(id, (String)data.get("type"), props, this.asLong(data, "startNode"), this.asLong(data, "endNode"), this);
            }
            if (data.containsKey("labels")) {
                List labels = (List)data.get("labels");
                return this.entityCache.addToCache(RestNode.fromCypher(id, labels, props, this));
            }
        }
        if ((uri = (String)data.get("self")) == null || uri.isEmpty()) {
            return null;
        }
        if (uri.contains("/node/")) {
            return this.entityCache.addToCache(new RestNode(data, (RestAPI)this));
        }
        if (uri.contains("/relationship/")) {
            return new RestRelationship(data, (RestAPI)this);
        }
        return null;
    }

    protected long asLong(Map data, String idKey) {
        Object idValue = data.get(idKey);
        return idValue instanceof Number ? ((Number)idValue).longValue() : Long.parseLong(idValue.toString());
    }

    @Override
    public RequestResult batch(Collection<Map<String, Object>> batchRequestData) {
        return this.restRequest.post("batch", batchRequestData);
    }
}

