/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import org.springframework.util.ObjectUtils;

public record FieldName(String name, Type type, String[] parts) {
    private final String[] parts;
    private static final String ID_KEY = "_id";
    public static final FieldName ID = new FieldName("_id", Type.KEY);

    public FieldName(String name, Type type) {
        this(name, type, name.split("\\."));
    }

    public static FieldName name(String value) {
        return new FieldName(value, Type.KEY);
    }

    public static FieldName path(String value) {
        return new FieldName(value, Type.PATH);
    }

    public String[] parts() {
        if (this.isKey()) {
            return new String[]{this.name};
        }
        return this.parts;
    }

    public boolean isOfType(Type type) {
        return ObjectUtils.nullSafeEquals((Object)((Object)this.type()), (Object)((Object)type));
    }

    public boolean isKey() {
        return this.isOfType(Type.KEY);
    }

    public boolean isPath() {
        return this.isOfType(Type.PATH);
    }

    @Override
    public String toString() {
        return "FieldName{%s=%s}".formatted(this.isKey() ? "key" : "path", this.name);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldName fieldName = (FieldName)o;
        return ObjectUtils.nullSafeEquals((Object)this.name, (Object)fieldName.name) && this.type == fieldName.type;
    }

    @Override
    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode((Object)this.name);
        return 31 * hashCode + ObjectUtils.nullSafeHashCode((Object)((Object)this.type));
    }

    public static enum Type {
        PATH,
        KEY;

    }
}

